(ns pinkgorilla.notebook-ui.nrepl.events-op
  (:require-macros
   [cljs.core.async.macros :refer [go go-loop]]
   [reagent.ratom :refer [reaction]])
  (:require
   [taoensso.timbre :refer-macros [trace debug info]]
   [cljs.core.async :as async :refer [<! >! chan timeout close!]]
   [re-frame.core :refer [reg-event-fx reg-event-db dispatch]]))

(defn run-op [conn op-fn op-args store-path eval?]
  (go
    (let [r (<! (apply op-fn conn op-args))]
      (trace "nrepl run-op result: " r)
      (dispatch [:kernel/save-result store-path r eval?]))))

(reg-event-fx
 :nrepl/op
 (fn [{:keys [db] :as cofx}  [_ op-fn op-args store-path eval?]]
   (let [{:keys [nrepl]} db
         {:keys [conn]} nrepl]
     (run-op conn op-fn op-args store-path eval?)
     ;cofx
     nil)))