(ns pinkgorilla.notebook-ui.app.init
  (:require
   [taoensso.timbre :as timbre :refer [info]]
   [re-frame.core :refer [dispatch]]
   ;[pinkgorilla.ui.config :refer [set-prefix!]]
   [pinkgorilla.explorer.default-config] ; side-effects
   [pinkgorilla.notebook-ui.default-config] ; side-effects    
   [pinkgorilla.notebook-ui.codemirror.key-binding] ; side-effects
   ))

(defn notebook-init! [config]
  (info "notebook-init!")
  (let [{:keys [keybindings nrepl-endpoint routes explorer gorilla-ui-prefix]} config]

    ; from gorilla-ui
    ;(set-prefix! gorilla-ui-prefix)

    ; from explorer
    ;(dispatch [:bidi/init routes])
    (dispatch [:explorer/init explorer])

    ; from nrepl-middleware
    (dispatch [:nrepl/init nrepl-endpoint])
    (dispatch [:nrepl/connect])

    ; from notebook-ui
    (dispatch [:keybindings/init keybindings])
    (dispatch [:settings/init])
    (dispatch [:punk/init])
    (dispatch [:completion/init])))
