(ns pinkgorilla.notebook-ui.keybindings.component
  (:require
   [reagent.core :as reagent]
   [re-frame.core :refer [subscribe dispatch dispatch-sync]]))

(defn palette-item [item active?]
  [:div.palette-item
   {:class (when active? "bg-orange-300")}
   [:li.flex.flex-row
    {:on-click #(dispatch-sync [:palette/action item])}
    [:span.m-2.border.border-round.border-blue-500
     {:class "w-1/4"}
     (:kb item)]
    [:span (:desc item)]]])

(defn keybindings-dialog
  []
  (let [palette (subscribe [:palette])
        {:keys [query visible-items highlight]} @palette]
    [:div.bg-green-200

     ; search
     [:div.flex.rlex-row.mb-5
      [:span {:class "w-1/4"}]
      [:input {:class "w-3/4 ml-2"
               :type        "text"
               :value       query
               :on-change   #(dispatch [:palette/filter-changed (-> % .-target .-value)])
               :on-key-down #(dispatch-sync [:palette/filter-keydown (.-which %)])
              ;; TODO  : on-blur kicks in before menu gets the click, but we want
              ;; :on-blur   #(dispatch [:palette-blur])
              ;; :on-mouse-down #(dispatch [:palette-blur])
               :ref  #(when % (.focus %)) ; make input focused
               }]]
     ; filtered items
     [:div.palette-items
      (when visible-items
        (into [:ul]
              (map-indexed (fn [i x]
                             [palette-item x (= i highlight)])
                           visible-items)))]]))

#_(fn [this _] ;; old-argv
                               ;; TODO: Focus or not?
    (let [el (reagent.dom/dom-node this)]
      (when (:show @palette)
        (-> el
            (sel1 :input)
            .focus))
      (if-let [actEl (gdom/getElementByClass "highlight" el)]
        (if (.-scrollIntoViewIfNeeded actEl)
          (.scrollIntoViewIfNeeded actEl false)
          (.scrollIntoView actEl false)))))