(ns pinkgorilla.notebook-ui.notebook.codemirror
  (:require
   [taoensso.timbre :refer-macros [info error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkgorilla.notebook-ui.codemirror.editor :refer [codemirror-reagent]]
   [pinkgorilla.notebook-ui.eval-result.eval-result :refer [eval-result-view]]
   [pinkgorilla.notebook-ui.completion.component :refer [completion-component]]))

(defn codemirror-edit [cm-opts {:keys [id] :as eval-result}]
  (let [settings (subscribe [:settings])
        theme (or (:codemirror-theme @settings) "paraiso-dark")
        buffer (subscribe [:notebook/segment-active])
        options-notebook {:theme theme
                          :move-up #(dispatch [:notebook/move :up])
                          :move-down #(dispatch [:notebook/move :down])
                          :save (fn [code]
                                  (dispatch [:notebook/set-code id code]))
                          :eval #(dispatch [:notebook/eval])}]
    [codemirror-reagent buffer (merge options-notebook cm-opts)]))

(defn codemirror-edit-inline [{:keys [id] :as eval-result}]
  (let [_ (info "notebook buffer is loading: " id)
        cm-opts {:class "flex.flex-row"
                 :style {:height "400px" ;"100%" ; "auto" ; "200px" ; ;"auto"
                         :width  "100%" ; "400px"
                         :font-size 16
                         :padding "2px"}}]
    [codemirror-edit cm-opts eval-result]))

(defn codemirror-edit-fullscreen [{:keys [id] :as eval-result}]
  (let [_ (info "notebook buffer is loading: " id)]
    [:div.w-full.h-full.bg-red-200 ; if this is :<> then it can fuck up flexbox styling
     ; dynamically loading css will not work the first time
     ; the editor is shown. css might get rendered after codemirror. 
     ; left (code/code-completion) - right (result) 
     [:div.flex.flex-row.w-full.h-full.items-stretch ; .justify-between
      ; code-mirror / code-completion
      [:div.bg-orange-500.h-screen.flex.flex-col.items-stretch {:class "w-1/2"}
       [:p "buffer:" (:id id)]
       [:div.w-full.h-full.bg-red-300
        [codemirror-edit {} eval-result]]
       [:div.h-64.w-full.bg-teal-300
        [completion-component]]]
      ; error / console / result
      [:div.bg-blue-700.h-screen {:class "w-1/2"}
       [eval-result-view eval-result]]]]))



