(ns pinkgorilla.notebook-ui.notebook.segment
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkie.pinkie :refer-macros [register-component]]
   [pinkgorilla.notebook-ui.eval-result.eval-result :refer [eval-result-view]]
   [pinkgorilla.notebook-ui.eval-result.code-viewer :refer [code-view]]
   [pinkgorilla.notebook-ui.eval-result.code :refer [code-edit]]
   [pinkgorilla.notebook-ui.notebook.codemirror :refer [codemirror-edit-inline]]
   [pinkgorilla.notebook-ui.notebook.md :refer [md-segment-edit md-segment-view]]
   [pinkgorilla.notebook-ui.completion.component :refer [completion-component]]))

; input / output


(defn segment-input [{:keys [id code md] :as eval-result}]
  (let [settings (subscribe [:settings])
        code-editor (or (:code-editor @settings) :text)
        segment-active (subscribe [:notebook/segment-active])
        active? (= (:id @segment-active) id)]
    [:div.text-left.bg-gray-100 ; .border-solid
     {:on-click #(dispatch [:notebook/move :to id])
      :class (when active? "border border-solid border-red-600")}
     (if active?
       (cond
         code (case code-editor
                :text [code-edit eval-result]
                :codemirror [codemirror-edit-inline eval-result]
                [code-edit eval-result])
         md    [md-segment-edit eval-result])
       (cond
         code [code-view eval-result]
         md  [md-segment-view eval-result]))]))

(defn segment-output [{:keys [code md] :as eval-result}]
  [:div
   (when md
     [md-segment-view eval-result])
   (when code
     [eval-result-view eval-result])])

; layout

(defn layout-vertical [eval-result]
  [:div.w-full ; .mt-5.p-2
   [segment-input eval-result]
   [segment-output eval-result]])

(defn layout-horizontal [eval-result]
  [:div.w-full.flex.flex-row ; .mt-5.p-2
   [:div {:class "w-1/2"}
    [segment-input eval-result]]
   [:div {:class "w-1/2"}
    [segment-output eval-result]]])

(defn layout-single [{:keys [id] :as eval-result}]
  [:div.w-full.h-full.bg-red-200 ; if this is :<> then it can fuck up flexbox styling
     ; dynamically loading css will not work the first time
     ; the editor is shown. css might get rendered after codemirror. 
     ; left (code/code-completion) - right (result) 
   [:div.flex.flex-row.w-full.h-full.items-stretch ; .justify-between
      ; code-mirror / code-completion
    [:div.bg-orange-500.h-screen.flex.flex-col.items-stretch {:class "w-1/2"}
     [:p "buffer:" id]
     [:div.w-full.h-full.bg-red-300
      [segment-input eval-result]]
     [:div.h-64.w-full.bg-teal-300
      [completion-component]]]
      ; error / console / result
    [:div.bg-blue-700.h-screen {:class "w-1/2"}
     [segment-output eval-result]]]])

; segment

(defn segment-view [{:keys [id] :as eval-result}]
  (let [settings (subscribe [:settings])
        layout (or (:layout @settings) :vertical)]
    [:div {:id id}
     (case layout
       :vertical [layout-vertical eval-result]
       :horizontal [layout-horizontal eval-result]
       :single [layout-single eval-result]
       [layout-vertical eval-result])]))




