(ns pinkgorilla.notebook-ui.notebook.md
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [re-frame.core :refer [dispatch]]
   [pinkie.error :refer [error-boundary]]
   [pinkgorilla.ui.config :refer [link-css]]
   [pinkgorilla.ui.ui.markdown :refer [markdown]]
   ["react-markdown-editor-lite" :as rmdel]))

(defn md-segment-view
  "markdown segment - view-only mode"
  [{:keys [id md]}]
  [:div {; :id id
         :class "segment free"}
   [:div.segment-main
    [:div.free-markup
     [markdown md]]]
   ^{:key :segment-footer}
   [:div.segment-footer]])

; awb99: TODO: render css from npm module
; I copied the css from node-modules/react-markdown-editor-lite/lib/index.css
; to resources/css/markdowneditor.css
; 
(defn- md-segment-edit
  "markdown editor
   used only by md-segment-edit"
  [{:keys [id md]}]
  [error-boundary
   [:<>
    [link-css "react-markdown-editor-lite/lib/index.css"]
    ;[:link {:rel "stylesheet" :href "/css/markdowneditor.css"}]
    [:> rmdel/default
     {:style {:height 200 ; :width 600
              }
      :value md
      :renderHTML (fn [_ #_text] "<p> Hello Markdown! </p>")
      :config {:view {:menu true
                      :md true
                      :html false}
               :canView {:menu true
                         :md true
                         :html false
                         :fullScreen false
                         :hideMenu false}}
      :onChange (fn [data]
                  (let [data-cljs (js->clj data :keywordize-keys true)]
                    (dispatch [:notebook/set-md id (:text data-cljs)])))}]]])

(defn md-segment
  "markdown segment"
  [{:keys [id active?] :as segment}]
  (info "rendering md: " segment)
  [:div {; :id id
         :class  (str "segment free"
                      (if active? " selected" ""))
         :on-click #(dispatch [:notebook/move :to id])}
   (if active?
     [md-segment-edit segment]
     [md-segment-view segment])
   ^{:key :segment-footer}
   [:div.segment-footer]])