(ns pinkgorilla.notebook-ui.codemirror.eval
  (:require
   [reagent.core :as r]
   [re-frame.core :refer [dispatch dispatch-sync subscribe]]
   [cljs.reader]
   [cljs.tools.reader]
   [pinkgorilla.notebook-ui.codemirror.options :refer [settings]]))

(defn is-valid-cljs? [source]
  (try
    (do
      (cljs.tools.reader/read-string source)
      true)
    (catch js/Error _
      false)))

(defn should-eval [source inst evt]
  (if (.-shiftKey evt)
    false
    (if (.-metaKey evt)
      true
      (let [lines (.lineCount inst)
            in-place (or (= 1 lines)
                         (let [pos (.getCursor inst)
                               last-line (dec lines)]
                           (and
                            (= last-line (.-line pos))
                            (= (.-ch pos)
                               (count (.getLine inst last-line))))))]
        (and in-place
             (is-valid-cljs? source))))))

(defn run-eval [text]
  (println "code-mirror eval: " text))

(defn execute [a b]
  (println "a" a {:warning-as-error (:warning-as-error @settings)} "b" b))


