(ns pinkgorilla.notebook-ui.notebook.segment
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkie.pinkie :refer-macros [register-component]]
   [pinkgorilla.notebook-ui.eval-result.eval-result :refer [eval-result-view]]
   [pinkgorilla.notebook-ui.eval-result.code-viewer :refer [code-view]]
   [pinkgorilla.notebook-ui.eval-result.code :refer [code-edit]]
   [pinkgorilla.notebook-ui.notebook.codemirror :refer [codemirror-edit-inline]]
   [pinkgorilla.notebook-ui.notebook.md :refer [md-segment md-segment-view]]))

; input / output

(defn code-component [{:keys [code active?] :as eval-result}]
  (let [settings (subscribe [:settings])
        code-editor (or (:code-editor @settings) :text)]
    [:div.text-left.bg-gray-100 ; .border-solid
     {:class (when active? "border border-solid border-red-600")}
     (if active?
       (case code-editor
         :text [code-edit eval-result]
         :codemirror [codemirror-edit-inline eval-result]
         [code-edit eval-result])
       [code-view eval-result])]))

(defn segment-input [{:keys [id code md] :as eval-result}]
  [:div {:on-click #(dispatch [:notebook/move-to id])}
   (when code
     [code-component eval-result])
   (when md
     [md-segment eval-result])])

(defn segment-output [{:keys [code md] :as eval-result}]
  [:div
   (when md
     [md-segment-view eval-result])
   (when code
     [eval-result-view eval-result])])

; layout

(defn layout-vertical [eval-result]
  [:div.w-full ; .mt-5.p-2
   [segment-input eval-result]
   [segment-output eval-result]])

(defn layout-horizontal [eval-result]
  [:div.w-full.flex.flex-row ; .mt-5.p-2
   [:div {:class "w-1/2"}
    [segment-input eval-result]]
   [:div {:class "w-1/2"}
    [segment-output eval-result]]])

; segment

(defn segment-view [{:keys [id] :as eval-result}]
  (let [settings (subscribe [:settings])
        layout (or (:layout @settings) :vertical)]
    [:div {:id id}
     (case layout
       :vertical [layout-vertical eval-result]
       :horizontal [layout-horizontal eval-result]
       [layout-vertical eval-result])]))




