(ns pinkgorilla.notebook-ui.notebook.events-move
  (:require
   [taoensso.timbre :as timbre :refer [debug warn error] :refer-macros [info errorf]]
   [cljs.reader]
   [cljs.tools.reader]
   [re-frame.core :refer [dispatch reg-event-db]]
   [pinkgorilla.notebook-ui.notebook.events :refer [notebook-op]]))

(defn move [order current-segment-id direction]
  (info "move " current-segment-id direction  " order: " order)
  (let [v-indexed (map-indexed (fn [idx id] [idx id]) order)
        ;_ (info "v-indexed: " v-indexed)
        current (first
                 (filter
                  (fn [[idx id]] (= current-segment-id id))
                  v-indexed))
        ;_ (info "current: " current)
        current-idx (get current 0)
        lookup (into {} v-indexed)
        ;_ (info "lookup: " lookup)
        idx-target (case direction
                     :down (min (+ current-idx 1) (- (count order) 1))
                     :up (max 0 (- current-idx 1)))
        ;_ (info "idx-target: " idx-target)
        ]
    (info "new current: " (get lookup idx-target))
    (get lookup idx-target)))


;(.scrollTo js/window (0, tesNode.offsetTop);


(reg-event-db
 :notebook/scroll-to
 (fn [db [_]]
   (let [storage (:notebook db)
         document2 (get-in db [:document :documents storage])
         active (:active document2)]
     (doto (.getElementById js/document active)
       (.scrollIntoView))
     db)))

(reg-event-db
 :notebook/move
 (fn [db [_ direction]]
   (dispatch [:notebook/scroll-to])
   (notebook-op
    db
    #(assoc % :active (move (:order %) (:active %) direction)))))

(reg-event-db
 :notebook/move-to
 (fn [db [_ id]]
   (dispatch [:notebook/scroll-to])
   (notebook-op
    db
    #(assoc % :active id))))

(reg-event-db
 :notebook/move-first
 (fn [db [_]]
   (dispatch [:notebook/scroll-to])
   (notebook-op
    db
    #(assoc % :active (first (:order %))))))

(reg-event-db
 :notebook/move-last
 (fn [db [_]]
   (dispatch [:notebook/scroll-to])
   (notebook-op
    db
    #(assoc % :active (last (:order %))))))
