(ns pinkgorilla.notebook-ui.notebook.component
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkie.pinkie :refer-macros [register-component]]
   [pinkgorilla.notebook-ui.eval-result.code :refer [code-theme]]
   [pinkgorilla.notebook-ui.notebook.segment :refer [segment-view]]))

(defn ^{:category :pinkie}
  snippets
  "renders a snippet list"
  [list]
  [:div.w-full.h-full.bg-gray-100
   [code-theme]
   (into [:div] (map segment-view list))])

; use from encoding / hydration

(defn segments-ordered [notebook]
  (let [segments (:segments notebook)
        segment-ids-ordered (:order notebook)]
    (vec (map #(get segments %) segment-ids-ordered))))

(defn code? [segment]
  (= :code (:type segment)))

(defn add-active [notebook segments]
  (let [active (:active notebook)]
    ;(info "active segment: " active)
    (map (fn [s]
           ;(info "checking: " (:id s))
           (assoc s :active? (= (:id s) active)))
         segments)))

(defn notebook-viewer [storage notebook]
  (let [segments (segments-ordered notebook)
        segments (add-active notebook segments)]
    (dispatch [:notebook/activate! storage])
    (when-not (:active notebook)
      (dispatch [:notebook/move-last]))
    [:div.w-full.h-full.bg-gray-100
     [code-theme]
     (into [:div] (map segment-view segments))]))

(register-component :p/snippets snippets)