
(ns pinkgorilla.notebook-ui.datafy.events-dialog
  (:require
   [taoensso.timbre :refer-macros [info]]
   [re-frame.core :refer [reg-event-db reg-event-fx dispatch reg-sub]]
   ;[pinkgorilla.ui.ui.dialog :refer [close-modal]]
   [pinkgorilla.notebook-ui.datafy.events-nrepl :refer [decode]]
   [pinkgorilla.notebook-ui.datafy.dialog :refer [datafy-dialog]]))

(reg-event-db
 :punk/set-entries
 (fn [db [_ entries]]
   (assoc-in db [:punk :entries] entries)))

(reg-event-db
 :datafy/show
 (fn [db [_ datafy-str]]
   (let [datafy (when datafy-str
                  (decode datafy-str))
         entries [datafy]]
     (info "showing datafy dialog: " entries)
     (dispatch [:modal {:show? true
                        :child [datafy-dialog]
                        :size :large}])
     (assoc-in db [:punk :entries] entries))))

(reg-sub
 :datafy/data
 (fn [db _]
   (get-in db [:datafy])))