(ns pinkgorilla.notebook-ui.buffer.new
  (:require
   [taoensso.timbre :refer-macros [info]]
   [re-frame.core :refer [reg-sub subscribe dispatch-sync]]
   [pinkgorilla.notebook.hipster :refer [make-hip-nsname]]
   [pinkgorilla.storage.unsaved :refer [StorageUnsaved]]
   [pinkgorilla.explorer.bidi :refer [goto-notebook!]]))

(defn notebook-new []
  (let [id (make-hip-nsname)
        storage  (StorageUnsaved. id)]
    (dispatch-sync [:document/create id])
    (goto-notebook! storage)
    [:h1 "Creating a new notebook .."]))