(ns pinkgorilla.notebook-ui.notebook.events-segment
  (:require
   [taoensso.timbre :refer-macros [info error]]
   [re-frame.core :as re-frame :refer [reg-event-db]]
   ;[pinkgorilla.events.helper :refer [text-matches-re default-error-handler  check-and-throw  standard-interceptors]]
   ;[pinkgorilla.notifications :refer [add-notification notification]]
   [pinkgorilla.notebook-ui.notebook.events :refer [current-notebook change-current-notebook]]))

(defn segment-op [db fun]
  (let [document (current-notebook db)
        active (:active document)
        segment (when (and document active)
                  (get-in document [:segments active]))]
    (if segment
      (let [segment-new (fun segment)]
        ;(info "document: " d)
        (change-current-notebook
         db
         (assoc-in document [:segments active] segment-new)))
      (do (error "cannot do segment-op: no active segment!")
          db))))

(defn kernel-toggle [{:keys [kernel] :as segment}]
  (assoc segment :kernel
         (case kernel
           :clj :cljs
           :clj)))

(reg-event-db
 :segment/kernel-toggle
 (fn [db [_]]
   (segment-op db kernel-toggle)))


