(ns pinkgorilla.notebook-ui.notebook.events
  (:require
   [taoensso.timbre :as timbre :refer [debug warn error] :refer-macros [info errorf]]
   [cljs.reader]
   [cljs.tools.reader]
   [re-frame.core :refer [subscribe dispatch reg-event-db reg-event-fx]]
   [pinkgorilla.notebook.hydration  :refer [clear-all clear-active]]))

(reg-event-db
 :notebook/init
 (fn [db [_]]
   (let [db (or db {})]
     (assoc-in db
               [:notebook] nil))))

(reg-event-db
 :notebook/activate!
 (fn [db [_ storage]]
   (assoc-in db [:notebook] storage)))

(defn current-notebook [db]
  (let [storage (:notebook db)
        document (get-in db [:document :documents storage])]
    document))

(defn change-current-notebook [db notebook]
  (let [storage (:notebook db)]
    (assoc-in db [:document :documents storage] notebook)))

(defn notebook-op [db fun]
  (let [document (current-notebook db)]
    (if document
      (let [d (fun document)]
        ;(info "document: " d)
        (change-current-notebook db d))
      (do (error "cannot do notebook-op: no active document!")
          db))))

(reg-event-db
 :notebook/set-md
 (fn [db [_ seg-id md]]
   (notebook-op db #(assoc-in % [:segments seg-id :md] md))))

(reg-event-db
 :notebook/set-code
 (fn [db [_ seg-id code]]
   (notebook-op db
                #(assoc-in % [:segments seg-id :code] code))))

(reg-event-db
 :notebook/set-result
 (fn [db [_ seg-id result]]
   (notebook-op db #(assoc-in % [:segments seg-id :result] result))))

#_(reg-sub
   :buffer/view
   (fn [db [_ buffer-id-kw]]
     (-> db
         (get-in [:buffer :buffers buffer-id-kw])
         (assoc :id buffer-id-kw))))

#_(reg-sub
   :buffer/sort
   (fn [db [_]]
     (-> db
         (get-in [:buffer :sort]))))

(defn move [order current-segment-id direction]
  (info "move " current-segment-id direction  " order: " order)
  (let [v-indexed (map-indexed (fn [idx id] [idx id]) order)
        ;_ (info "v-indexed: " v-indexed)
        current (first
                 (filter
                  (fn [[idx id]] (= current-segment-id id))
                  v-indexed))
        ;_ (info "current: " current)
        current-idx (get current 0)
        lookup (into {} v-indexed)
        ;_ (info "lookup: " lookup)
        idx-target (case direction
                     :down (min (+ current-idx 1) (- (count order) 1))
                     :up (max 0 (- current-idx 1)))
        ;_ (info "idx-target: " idx-target)
        ]
    (info "new current: " (get lookup idx-target))
    (get lookup idx-target)))


;(.scrollTo js/window (0, tesNode.offsetTop);


(reg-event-db
 :notebook/scroll-to
 (fn [db [_]]
   (let [storage (:notebook db)
         document2 (get-in db [:document :documents storage])
         active (:active document2)]
     (doto (.getElementById js/document active)
       (.scrollIntoView))
     db)))

(reg-event-db
 :notebook/move
 (fn [db [_ direction]]
   (dispatch [:notebook/scroll-to])
   (notebook-op
    db
    #(assoc % :active (move (:order %) (:active %) direction)))))

(reg-event-db
 :notebook/move-to
 (fn [db [_ id]]
   (dispatch [:notebook/scroll-to])
   (notebook-op
    db
    #(assoc % :active id))))

(reg-event-db
 :notebook/move-first
 (fn [db [_]]
   (dispatch [:notebook/scroll-to])
   (notebook-op
    db
    #(assoc % :active (first (:order %))))))

(reg-event-db
 :notebook/move-last
 (fn [db [_]]
   (dispatch [:notebook/scroll-to])
   (notebook-op
    db
    #(assoc % :active (last (:order %))))))

; clear output

(reg-event-db
 :notebook/clear-active
 (fn [db [_]]
   (info "clear active")
   (notebook-op
    db
    clear-active)))

(reg-event-db
 :notebook/clear-all
 (fn [db [_]]
   (info "clear all")
   (notebook-op
    db
    clear-all)))