(ns pinkgorilla.notebook-ui.keybindings.default)

; https://github.com/piranha/keybind
; shift, ctrl, alt, win, cmd, defmod

; keys binding examples:
; "left"  
; "right"
; "meta-shift-l"
; "alt-shift-p"
; "ctrl-shift-left"
; "ctrl-shift-right"

(def keybindings-app
  [{:desc    "Settings Edit."
    :kb      "f1"
    :handler [:settings/show]}
   {:desc    "New notebook"
    :kb "alt-n"
    :handler [:document/new]}
   {:desc    "Explore Notebooks."
    :kb      "alt-e" ;"ctrl-e"]
    :handler [:bidi/goto :ui/explorer]}
   {:desc    "Show the command list."
    :kb      "f2"
    :handler [:palette/show]}])

(def keybindings-document
  [{:desc    "Save"
    :kb      "alt-s"
    :handler [:save-notebook]}
   {:desc    "Save As"
    :kb      "alt-shift-s"
    :handler [:document/save-as]}
   {:desc    "Clear the output of all code segments."
    :kb      "alt-shift-backspace" ;"alt+g alt+z"
    :handler [:notebook/clear-all]}
   #_{:desc    "Meta Edit."
      :kb      ["ctrl+2" "alt+g alt+2"]
      :handler [:dialog-show :meta]}
   #_{:desc    "Evaluate all segments."
      :kb      "alt-shift-enter"
      :handler [:worksheet:evaluate-all]}

   #_{:desc    "Undo the last segment operation."
      :kb      "alt+g alt+\\"
      :handler [:undo]}])

(def keybindings-notebook
  [{:desc    "Move the highlighted segment up the worksheet."
    :kb      "alt-up"
    :handler [:notebook/move :up]}
   {:desc    "Move the highlighted segment down the worksheet."
    :kb      "alt-down"
    :handler [:notebook/move :down]}
   {:desc    "Clear the output of the highlighted segment."
    :kb      "shift-backspace" ; "alt+g alt+o"
    :handler [:notebook/clear-active]}
   #_{:desc    "Convert the highlighted segment to a markdown segment."
      :kb      "alt+g alt+m"
      :handler [:worksheet:changeToFree]}
   #_{:desc    "Convert the highlighted segment to a clojure segment."
      :kb      "alt+g alt+j"
      :handler [:worksheet:changeToCode]}
   #_{:desc    "Create a new segment below the highlighted segment."
      :kb      "alt+g alt+n"
      :handler [:worksheet:newBelow]}
   #_{:desc    "Create a new segment above the highlighted segment."
      :kb      "alt+g alt+b"
      :handler [:worksheet:newAbove]}

   #_{:desc    "Kernel Toggle."
      :kb      ["ctrl+3" "alt+g alt+3"]
      :handler [:app:kernel-toggle]}
   #_{:desc    "Delete the highlighted segment."
      :kb      "alt+g alt+x"
      :handler [:worksheet:delete]}
   #_{:desc       "Move to the previous segment."
      :handler    :worksheet:leaveBack}
   #_{:desc       "Move to the next segment."
      :handler    :worksheet:leaveForward}])

(def keybindings-codemirror
  [{:desc    "move to next auto-completion candidate"
    :kb      "tab"
    :handler [:completion/next]}
   {:desc   "move to prior auto-completion candidate"
    :kb      "shift-tab"
    :handler [:completion/prior]}
   {:desc    "Show possible auto-completions."
    :kb      "ctrl-space"
    :handler [:worksheet:completions]}
   {:desc    "Evaluate the highlighted segment."
    :kb      "shift-enter"
    :handler [:notebook/eval]}
   #_{:desc    "Look up the symbol under the cursor in ClojureDocs."
      :kb      "alt+g alt+c"
      :handler clojuredocs}])

(def keybindings-default
  (into []
        (concat
         keybindings-app
         keybindings-document
         keybindings-notebook
         keybindings-codemirror)))