(ns pinkgorilla.notebook-ui.eval-result.code
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [re-frame.core :refer [subscribe dispatch]]
   ["highlight.js/lib/core" :as hljs]
   ["highlight.js/lib/languages/javascript" :as javascript]
   ["highlight.js/lib/languages/markdown" :as markdown]
   ["highlight.js/lib/languages/plaintext" :as plaintext]
   ["highlight.js/lib/languages/clojure" :as clojure]
   ["highlight.js/lib/languages/clojure-repl" :as clojure-repl]
   [pinkgorilla.ui.config :refer [link-css]]))

(.registerLanguage hljs "javascript" javascript)
(.registerLanguage hljs "markdown" markdown)
(.registerLanguage hljs "plaintext" plaintext)
(.registerLanguage hljs "clojure" clojure)
(.registerLanguage hljs "clojure-repl" clojure-repl)


;; todo https://github.com/baskeboler/cljs-karaoke-client/blob/master/package.json
;;  "react-highlight.js": "^1.0.7",

;(.initHighlightingOnLoad hljs)

; nicely formatted notebooks:
; https://nextjournal.com/gigasquid/parens-for-python---seaborn-visualizations
; https://www.maria.cloud/gallery?eval=true

; https://codepen.io/elomatreb/pen/hbgxp

; span {
;    display: block;
;    line-height: 1.5rem;
;    
;    &:before {
;      counter-increment: line;
;      content: counter(line);
;      display: inline-block;
;      border-right: 1px solid #ddd;
;      padding: 0 .5em;
;      margin-right: .5em;
;      color: #888
;    }


(def code-editor-themes
  ["default"
   "github"
   "zenburn"])

(defn code-theme []
  (let [settings (subscribe [:settings])
        theme (or (:code-editor-theme @settings) "github")]
    [link-css (str "highlight.js/styles/" theme ".css")]
   ;[:link {:rel "stylesheet" :href (str "/highlight.js/styles/" theme ".css")}]
    ))

(defn code-view [{:keys [code active?] :as eval-result}]
  [:pre ;.clojure
   [:code {:ref  #(when % (.highlightBlock hljs %))}
    ;.w-full.font-mono
    ;[:p
    code
    ; ]
    ]])

(defn code-edit [{:keys [id code active?] :as eval-result}]
  #_[:pre ;.clojure
     [:code {:ref  #(when % (.highlightBlock hljs %))
             :contenteditable "true"
             :on-input (fn [evt]
                         (let [v (-> evt .-target .-value)] ; 
                           (info "code changed!" v)
                        ;(reset! ratom v)
                           ))
           ;:value code
             }
      code]]
  (info "eval result: " eval-result)
  [:textarea.font-mono.text-left.w-full.text-gray-70
   {:value (or code "")
    :on-change (fn [evt]
                 (let [v (-> evt .-target .-value)] ; 
                   (info "code changed!" v)
                   (dispatch [:notebook/set-code id v])
                        ;(reset! ratom v)
                   ))}])

(defn code-component [{:keys [code active?] :as eval-result}]
  [:div.text-left.bg-gray-100 ; .border-solid
   {:class (when active? "border border-solid border-red-600")}
   (if active?
     [code-edit eval-result]
     [code-view eval-result])])