(ns pinkgorilla.notebook-ui.kernel.info
  (:require-macros
   [cljs.core.async.macros :refer [go go-loop]]
   [reagent.ratom :refer [reaction]])
  (:require
   [taoensso.timbre :refer-macros (info)]
   [cljs.core.async :as async :refer [<! >! chan timeout close!]]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]
   [pinkgorilla.nrepl.op.admin :refer [describe ls-sessions]]
   [pinkgorilla.notebook-ui.views.info :refer [session-panel desc-panel]]
   [pinkgorilla.nrepl.op.cider :refer [stacktrace resolve-symbol doc-string completions]]))

(reg-event-fx
 :nrepl/describe
 (fn [cofx [_]]
   (dispatch [:nrepl/op describe [] [:nrepl :info :describe]])))

(reg-event-fx
 :nrepl/ls-sessions
 (fn [cofx [_]]
   (dispatch [:nrepl/op ls-sessions [] [:nrepl :info :sessions]])))




