(ns pinkgorilla.notebook-ui.notebook.events
  (:require
   [taoensso.timbre :as timbre :refer [debug warn error] :refer-macros [info errorf]]
   [cljs.reader]
   [cljs.tools.reader]
   [pinkgorilla.nrepl.op.eval :refer [nrepl-eval]]
   [re-frame.core :refer [subscribe reg-event-db reg-event-fx]]))

(reg-event-db
 :notebook/init
 (fn [db [_]]
   (let [db (or db {})]
     (assoc-in db
               [:notebook] nil))))

(reg-event-db
 :notebook/activate!
 (fn [db [_ storage]]
   (assoc-in db [:notebook] storage)))

(defn notebook-op [db fun]
  (let [storage (:notebook db)
        document (get-in db [:document :documents storage])]
    (if document
      (let [d (fun document)]
        ;(info "document: " d)
        (assoc-in db [:document :documents storage] d))
      (do (error "cannot do notebook-op: no active document!")
          db))))

(reg-event-db
 :notebook/set-code
 (fn [db [_ seg-id code]]
   (notebook-op db
                #(assoc-in % [:segments seg-id :code] code))))

(reg-event-db
 :notebook/set-result
 (fn [db [_ seg-id result]]
   (notebook-op db #(assoc-in % [:segments seg-id :result] result))))

#_(reg-event-fx
   :notebook/eval
   (fn [{:keys [db] :as cofx} [_ buffer-id-kw]]
     (let [code (get-in db [:buffer :buffers buffer-id-kw :code])]
       (if code
         (dispatch [:nrepl/op nrepl-eval [code] [:buffer :buffers buffer-id-kw :result]])
         (errorf "cannot eval buffer %s - code is nil!" buffer-id-kw)))))

#_(reg-sub
   :buffer/view
   (fn [db [_ buffer-id-kw]]
     (-> db
         (get-in [:buffer :buffers buffer-id-kw])
         (assoc :id buffer-id-kw))))

#_(reg-sub
   :buffer/sort
   (fn [db [_]]
     (-> db
         (get-in [:buffer :sort]))))

(defn move [order current-segment-id direction]
  (info "move " current-segment-id direction  " order: " order)
  (let [v-indexed (map-indexed (fn [idx id] [idx id]) order)
        ;_ (info "v-indexed: " v-indexed)
        current (first
                 (filter
                  (fn [[idx id]] (= current-segment-id id))
                  v-indexed))
        ;_ (info "current: " current)
        current-idx (get current 0)
        lookup (into {} v-indexed)
        ;_ (info "lookup: " lookup)
        idx-target (case direction
                     :down (min (+ current-idx 1) (- (count order) 1))
                     :up (max 0 (- current-idx 1)))
        ;_ (info "idx-target: " idx-target)
        ]
    (info "new current: " (get lookup idx-target))
    (get lookup idx-target)))

(reg-event-db
 :notebook/move
 (fn [db [_ direction]]
   (notebook-op
    db
    #(assoc % :active (move (:order %) (:active %) direction)))))

(reg-event-db
 :notebook/move-first
 (fn [db [_]]
   (notebook-op
    db
    #(assoc % :active (first (:order %))))))

(reg-event-db
 :notebook/move-last
 (fn [db [_]]
   (notebook-op
    db
    #(assoc % :active (last (:order %))))))