(ns pinkgorilla.notebook-ui.notebook.component
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [re-frame.core :refer [subscribe dispatch]]
   [pinkie.pinkie :refer-macros [register-component]]
   [pinkgorilla.notebook-ui.eval-result.eval-result :refer [eval-result-view]]
   [pinkgorilla.notebook-ui.eval-result.code :refer [code-view code-theme]]))

(defn layout-vertical [{:keys [code] :as eval-result}]
  [:div.w-full ; .mt-5.p-2
   (when code
     [code-view eval-result])
   [eval-result-view eval-result]])

(defn layout-horizontal [{:keys [code] :as eval-result}]
  [:div.w-full.flex.flex-row ; .mt-5.p-2
   [:div {:class "w-1/2"}
    (when code
      [code-view eval-result])]
   [:div {:class "w-1/2"}
    [eval-result-view eval-result]]])

(defn snippet [eval-result]
  (let [settings (subscribe [:settings])
        layout (or (:layout @settings) :vertical)]
    (case layout
      :vertical [layout-vertical eval-result]
      :horizontal [layout-horizontal eval-result]
      [layout-vertical eval-result])))

(defn ^{:category :pinkie}
  snippets
  "renders a snippet list"
  [list]
  [:div.w-full.h-full.bg-gray-100
   [code-theme]
   (into [:div] (map snippet list))])


; use from encoding / hydration


(defn segments-ordered [notebook]
  (let [segments (:segments notebook)
        segment-ids-ordered (:order notebook)]
    (vec (map #(get segments %) segment-ids-ordered))))

(defn code? [segment]
  (= :code (:type segment)))

(defn add-active [notebook segments]
  (let [active (:active notebook)]
    ;(info "active segment: " active)
    (map (fn [s]
           ;(info "checking: " (:id s))
           (assoc s :active? (= (:id s) active)))
         segments)))

(defn notebook-viewer [storage notebook]
  (let [segments (segments-ordered notebook)
        _ (info "segments : " (count segments))
        segments-code (filter code? segments)
        segments-code (add-active notebook segments-code)
        _ (info "segments-code : " (count segments-code))]
    (dispatch [:notebook/activate! storage])
    (when-not (:active notebook)
      (dispatch [:notebook/move-last]))
    [:div.w-full.h-full.bg-gray-100
     [code-theme]
     (into [:div] (map snippet segments-code))]))

(register-component :p/snippets snippets)