(ns pinkgorilla.notebook-ui.buffer.snippets
  (:require
   [taoensso.timbre :as timbre :refer [debug info warn error]]
   [pinkie.pinkie :refer-macros [register-component]]
   [pinkgorilla.notebook-ui.eval-result.eval-result :refer [eval-result-view]]
   [pinkgorilla.notebook-ui.eval-result.code :refer [code-view code-theme]]))

(defn snippet [{:keys [code] :as eval-result}]
  [:div.w-full ; .mt-5.p-2
   (when code
     [code-view eval-result])
   [eval-result-view eval-result]])

(defn ^{:category :pinkie}
  snippets
  "renders a snippet list"
  [list]
  [:div.w-full.h-full.bg-gray-100
   [code-theme]
   (into [:div] (map snippet list))])


; use from encoding / hydration


(defn segments-ordered [notebook]
  (let [segments (:segments notebook)
        segment-ids-ordered (:order notebook)]
    (vec (map #(get segments %) segment-ids-ordered))))

(defn code? [segment]
  (= :code (:type segment)))

(defn notebook-viewer [notebook]
  (let [segments (segments-ordered notebook)
        _ (info "segments : " (count segments))
        segments-code (filter code? segments)
        _ (info "segments-code : " (count segments-code))]
    [:div.w-full.h-full.bg-gray-100
     [code-theme]
     (into [:div] (map snippet segments-code))]))

(register-component :p/snippets snippets)