(ns pinkgorilla.notebook-ui.eval-result.eval-result
  (:require
   [pinkgorilla.ui.config :refer [link-css]]
   [pinkgorilla.notebook-ui.eval-result.console :refer [console-view]]
   [pinkgorilla.notebook-ui.eval-result.error :refer [error-text]]
   [pinkgorilla.notebook-ui.eval-result.stacktrace :refer [stacktrace-table]]
   [pinkgorilla.notebook-ui.eval-result.picasso :refer [picasso-cell]]))

(defn eval-result-view [{:keys [picasso out stacktrace] :as result}]
  [:div.w-full.mt-5.p-2

   [error-text result]

   (when stacktrace
     [stacktrace-table result])

   (when out
     [console-view out])

   (when picasso
     [picasso-cell picasso])])

