(ns pinkgorilla.notebook-ui.buffer.notebook
  (:require
   [taoensso.timbre :refer-macros [info error]]
   [reagent.core :as r]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]
   [pinkgorilla.ui.config :refer [link-css]]
   [pinkgorilla.notebook-ui.buffer :refer [move]]
   [pinkgorilla.notebook-ui.codemirror.editor :refer [code-mirror-reagent]]
   [pinkgorilla.notebook-ui.eval-result.eval-result :refer [eval-result-view]]
   [pinkgorilla.notebook-ui.completion.component :refer [completion-component]]))

(defn notebook-buffer [buffer-id options]
  (let [_ (info "notebook buffer is loading: " buffer-id)
        buffer (subscribe [:buffer/view buffer-id])]
    [:div.w-full.h-full.bg-red-200 ; if this is :<> then it can fuck up flexbox styling
     ; dynamically loading css will not work the first time
     ; the editor is shown. css might get rendered after codemirror. 
     [link-css "codemirror/lib/codemirror.css"]
     ; left (code/code-completion) - right (result) 
     [:div.flex.flex-row.w-full.h-full.items-stretch ; .justify-between
      ; code-mirror / code-completion
      [:div.bg-orange-500.h-screen.flex.flex-col.items-stretch {:class "w-1/2"}
       [:p "buffer:" (:id @buffer)]
       [:div.w-full.h-full.bg-red-300
        [code-mirror-reagent buffer options]]
       [:div.h-64.w-full.bg-teal-300
        [completion-component]]]
      ; error / console / result
      [:div.bg-blue-700.h-screen {:class "w-1/2"}
       [eval-result-view (:result @buffer)]]]]))

(defn notebook [options]
  (let [current-id (r/atom :scratchpad)
        sort (subscribe [:buffer/sort])
        move (fn [direction]
               (info "move: " direction)
               (reset! current-id (move @sort @current-id direction))
               (info "current buffer is: " @current-id))
        move-up (fn [] (move :up))
        move-down (fn [] (move :down))
        options-notebook {:move-up move-up
                          :move-down move-down
                          :save (fn [code]
                                  (dispatch [:buffer/set-code @current-id code]))
                          :eval #(dispatch [:buffer/eval @current-id])}]
    (fn [options]
      [notebook-buffer @current-id (merge options-notebook options)])))








