(ns pinkgorilla.notebook-ui.kernel.op
  (:require-macros
   [cljs.core.async.macros :refer [go go-loop]]
   [reagent.ratom :refer [reaction]])
  (:require
   [taoensso.timbre :refer-macros [trace debug info]]
   [cljs.core.async :as async :refer [<! >! chan timeout close!]]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]))

(reg-event-db
 :nrepl/op-save
 (fn [db [_ path data]]
   (info "saving nrepl result to: " path)
   (info "saving nrepl result data: " data)
   (-> db
       (assoc-in path data))))

(defn run-op [conn op-fn op-args store-path]
  (go
    (let [r (<! (apply op-fn conn op-args))]
      (trace "nrepl run-op result: " r)
      (dispatch [:nrepl/op-save store-path r]))))

(reg-event-fx
 :nrepl/op
 (fn [{:keys [db] :as cofx}  [_ op-fn op-args store-path]]
   (let [{:keys [nrepl]} db
         {:keys [conn]} nrepl
         ;_ (info "describe db: " db)
         ;_ (info "describe conn: " conn)
         ]
     (run-op conn op-fn op-args store-path)
     ;cofx
     nil)))