(ns pinkgorilla.notebook-ui.buffer.eval-history
  (:require-macros
   [cljs.core.async.macros :refer [go go-loop]]
   [reagent.ratom :refer [reaction]])
  (:require
   [taoensso.timbre :refer-macros (info)]
   [cljs.core.async :as async :refer [<! >! chan timeout close!]]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]
   [pinkgorilla.notebook-ui.buffer.snippets :refer [snippets]]
   [pinkgorilla.notebook-ui.buffer.eval-result :refer [eval-result-view]]))

(reg-sub
 :nrepl/evals
 (fn [db _]
   (get-in db [:buffer :buffers])))

(defn eval-history []
  (let [nhistory (subscribe [:nrepl/evals])]
    (fn []
      (let [h @nhistory
           ; _ (info "nrepl-eval-history: "  h)
            evals (vals h)
            results (map :result evals)
            _ (info "nrepl-eval-history: "  results)]
        [:div
         [:h1 "nrepl eval history"]
         (when results
           (into [:div]
                 (map (fn [r] ; [:p (str r)]
                        [eval-result-view r]) results))

           ;
           )]))))