(ns pinkgorilla.notebook-ui.codemirror.options
  (:require
   [reagent.core :as r]))

(def settings (r/atom
               {:parinfer false
                :vim false
                :warning-as-error false}))

(def cm-default-opts
  {:lineNumbers true
   :firstLineNumber 1
    ;:viewportMargin js/Infinity
   :matchBrackets true
   :autofocus true
   :autoCloseBrackets "()[]{}\"\""
   :lineWrapping true ;  false=scroll, true=wrap
   :theme "paraiso-dark" ; "default" ; 
   :extraKeys #js {"Shift-Enter" "newlineAndIndent"}
   :mode (if (:parinfer @settings)
           "clojure-parinfer"
           "clojure")
   :keyMap (if (:vim @settings) "vim" "default")
   :showCursorWhenSelecting true})

(def code-mirror-key-down
  [; eval 
   {:key     ::eval
    :spec    "enter"
    :scope :codemirror-no-context
    :handler [:eval]} ; :eval goes to buffer/notebook/eval
   ; buffer navigation
   {:key     ::up
    :spec    "up"
    :scope :codemirror
    :handler [:arrow-up]} ; [:move-up]
   {:key     ::down
    :spec    "down"
    :scope :codemirror
    :handler [:arrow-down]} ; [:move-down]
   ; code completion
   #_{:key     ::hint
      :spec    "tab"
      :scope    :codemirror
      :handler [:hint]}
   {:key     ::next
    :spec    "tab"
    :scope    :codemirror
    :handler [:hint-next]}
   {:key     ::prior
    :spec     "shift-tab"; "shift-tab"
    :scope    :codemirror
    :handler [:hint-prior]}
   #_{:key     ::showallshow
      :spec    "ctrl" ; ["ctrl" "alt" "select"]  ; (ctrl alt window-left select)
      :handler [:completion/show-all true]}
   ; test
   {:key     ::test
    :spec    "t"
    :scope :codemirror-no-context
    :handler [:eval]}])

(def code-mirror-key-up
  [#_{:key     ::clear
      :spec    "enter" ;  ["enter"] ; "escape"
      :handler [:completion/clear]}
   #_{:key     ::show-all-hide
      :spec    "ctrl" ; "["ctrl" "alt"] ; #{ctrl alt window-left select} ; "select"
      :handler [:completion/show-all  false]}])



