(ns pinkgorilla.notebook-ui.buffer.eval-result
  (:require
   [pinkgorilla.ui.config :refer [link-css]]
   [picasso.protocols :refer [paint]]
   [picasso.paint.core :refer [->reagent]]
   [pinkgorilla.notebook-ui.buffer.error :refer [error-text]]
   [pinkgorilla.notebook-ui.buffer.stacktrace :refer [stacktrace-table]]))

(defn console-cell [c]
  [:div.bg-gray-100.font-mono.w-full.text-left.orange-300  ; .gray-900
   [:textarea.bg-gray-100.orange-300.w-full
    {:style {;:overflow-x "scroll"
             :overflow-x "hidden"
             :white-space "pre"}
     :value c
     :readOnly true
     ;:defaultValue c
     }]])

(defn picasso-cell [ps]
  (into [:div.w-full.mt-5.bg-gray-100.flex.flex-col]
        (->reagent ps)
        ;(map (fn [s] [paint s]) ps)
        ))

(defn eval-result-view [{:keys [picasso out err] :as result}]
  [:div.w-full.mt-5.p-2
   ;(when err
    ; [stacktrace-table result]
   [error-text result]
     ;[console-cell err]
     ;)

   (when out
     [console-cell out])

   (when picasso
     [picasso-cell picasso])])

