(ns pinkgorilla.notebook-ui.codemirror.buffer
  (:require
   [taoensso.timbre :refer-macros [info error]]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]))

(defn first-line-number [cm]
  (.-firstLine cm))

(defn last-line-number [cm]
  (.lastLine cm))

(defn current-line-number [cm]
  (let [pos (.getCursor cm)]
    (.-line pos)))

(defn first-line? [cm]
  (let [f (first-line-number cm)
        c (current-line-number cm)]
    (= f c)))

(defn last-line? [cm]
  (let [l (last-line-number cm)
        c (current-line-number cm)]
    (= l c)))

(defn run-notebook [cm-opts fun-kw & args]
  (info "running " fun-kw)
  (info "cm opts: " cm-opts)
  (info "args: " args)
  (if-let [f (fun-kw cm-opts)]
    (apply f args)
    (error "could not find function: " fun-kw)))

(defn save-code [cm-opts cm buffer]
  (let [editor-code (.getValue @cm)
        {:keys [code]} @buffer]
    (when-not (= code editor-code)
      (run-notebook cm-opts :save editor-code))))

(defn load-code [cm buffer]
  (let [editor-code (.getValue @cm)
        {:keys [code]} @buffer]
    (when-not (= code editor-code)
      (.setValue @cm code)
      true)))
