(ns pinkgorilla.notebook-ui.buffer.eval-result
  (:require
   [pinkgorilla.ui.config :refer [link-css]]
   [picasso.protocols :refer [paint]]))

(defn console-cell [c]
  [:div.bg-gray-100.font-mono.w-full.text-left.orange-300  ; .gray-900
   [:textarea.bg-gray-100.orange-300.w-full
    {:style {;:overflow-x "scroll"
             :overflow-x "hidden"
             :white-space "pre"}
      ;:value c     
     :defaultValue c}]])

(defn picasso-cell [ps]
  (into [:div.w-full.mt-5.bg-gray-100]
        (map (fn [s] [paint s]) ps)))

(defn eval-result-view [{:keys [picasso out err]}]
  [:div.w-full.mt-5.p-2
   (when out
     [console-cell out])
   (when err
     [console-cell err])
   (when picasso
     [picasso-cell picasso])])

