(ns pinkgorilla.notebook-ui.completion.events
  (:require
   [taoensso.timbre :refer-macros (info)]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]
   [pinkgorilla.nrepl.op.cider :refer [stacktrace resolve-symbol doc-string completions]]))

; map cider operations:

(reg-event-fx
 :nrepl/stacktrace
 (fn [cofx [_]]
   (dispatch [:nrepl/op stacktrace [] [:nrepl :stacktrace]])))

(reg-event-fx
 :nrepl/completions
 (fn [cofx [_ q namespace context]]
   (dispatch [:nrepl/op completions [q namespace context] [:nrepl :completion :candidates]])))

(reg-event-fx
 :nrepl/docstring
 (fn [cofx [_ symbol namespace]] ; "pprint-table" "clojure.pprint"
   (dispatch [:nrepl/op doc-string [symbol namespace] [:nrepl :completion :docstring]])))

(reg-event-fx
 :nrepl/resolve-symbol
 (fn [cofx [_ symbol namespace]] ; "doseq" "clojure.core"
   (dispatch [:nrepl/op resolve-symbol [symbol namespace] [:nrepl :completion :resolve]])))



