(ns pinkgorilla.notebook-ui.codemirror.buffer
  (:require
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]))

(defn first-line-number [cm]
  (.-firstLine cm))

(defn last-line-number [cm]
  (.lastLine cm))

(defn current-line-number [cm]
  (let [pos (.getCursor cm)]
    (.-line pos)))

(defn first-line? [cm]
  (let [f (first-line-number cm)
        c (current-line-number cm)]
    (= f c)))

(defn last-line? [cm]
  (let [l (last-line-number cm)
        c (current-line-number cm)]
    (= l c)))

(defn save-code [cm buffer]
  (let [editor-code (.getValue cm)
        {:keys [code id]} buffer]
    (when-not (= code editor-code)
      (println "save-code")
      true)))
