(ns pinkgorilla.notebook-ui.buffer
  (:require
   [taoensso.timbre :refer-macros [info errorf]]
   [reagent.core :as r]
   [re-frame.core :refer [reg-event-fx reg-event-db reg-sub reg-sub-raw subscribe dispatch]]
   [cljs.reader]
   [cljs.tools.reader]
   [pinkgorilla.nrepl.op.eval :refer [nrepl-eval]]))

(reg-event-db
 :buffer/init
 (fn [db [_]]
   (let [db (or db {})]
     (assoc db
            :buffer {:buffers {:scratchpad {:code "(+ 2 2)(println 2)" :result nil}
                               :1 {:code "(+ 1 1)(println 1)" :result nil}
                               :3 {:code "(+ 3 3)(println 3)" :result nil}}
                     :sort [:1
                            :scratchpad
                            :3]}))))

(reg-event-db
 :buffer/set-code
 (fn [db [_ buffer-id-kw code]]
   (assoc-in db [:buffer :buffers buffer-id-kw :code] code)))

(reg-event-fx
 :buffer/eval
 (fn [{:keys [db] :as cofx} [_ buffer-id-kw]]
   (let [code (get-in db [:buffer :buffers buffer-id-kw :code])]
     (if code
       (dispatch [:nrepl/op nrepl-eval [code] [:buffer :buffers buffer-id-kw :result]])
       (errorf "cannot eval buffer %s - code is nil!" buffer-id-kw)))))

(reg-event-db
 :buffer/set-result
 (fn [db [_ buffer-id-kw result]]
   (assoc-in db [:buffer :buffers buffer-id-kw :result] result)))

(reg-sub
 :buffer/view
 (fn [db [_ buffer-id-kw]]
   (-> db
       (get-in [:buffer :buffers buffer-id-kw])
       (assoc :id buffer-id-kw))))

(reg-sub
 :buffer/sort
 (fn [db [_]]
   (-> db
       (get-in [:buffer :buffers :sort]))))

(defn move [sort current-buffer-id-kw direction]
  (let [v-indexed (map-indexed #([%1 %2]) sort)
        current (filter #(= current-buffer-id-kw (get % 1)) v-indexed)
        current-idx (get current 0)
        lookup (into {} v-indexed)
        _ (info "lookup: " lookup)
        idx-target (case direction
                     :up (min (+ current-idx 1) (- (count sort) 1))
                     :down (max 0 (- current-idx 1)))]
    (get lookup idx-target)))










