(ns pinkgorilla.notebook.app
  (:require
   [taoensso.timbre :as timbre :refer [info]]
   [webly.config :refer [load-config! get-in-config]]
   [webly.user.app.app :refer [webly-run! create-ring-handler]]
   [pinkgorilla.explore.handler :refer [explore-directories-start]]
   ; nrepl relay
   [ring.adapter.jetty9 :refer [run-jetty]]
   [webly.web.handler :refer [add-ring-handler]]
   [pinkgorilla.nrepl.relay.jetty :refer [ws-handler]]
   [pinkgorilla.nrepl.server.nrepl-server :refer [run-nrepl-server]]
   ; side effects
   [pinkgorilla.notebook-ui.default-config]
   [pinkgorilla.notebook.routes])
  (:gen-class))

(defn run-jetty-server [config-backend]
  (let [handler (create-ring-handler) ; uses webly-config
        nrepl-ws-handler (ws-handler (:nrepl-client config-backend))
        {:keys [port nrepl-ws-route]} (:jetty config-backend)]
    (info "Starting Jetty web server at port " port " ..")
    (add-ring-handler :nrepl/relay nrepl-ws-handler)
    (run-jetty handler {:port port
                        :websockets {nrepl-ws-route nrepl-ws-handler}
                        :allow-null-path-info true
                           ;:join?  false        
                        })))

(defn start-notebook!
  ([]
   (start-notebook! "watch" {}))
  ([mode user-config]
   (load-config! user-config)
   (let [config-backend (get-in-config [:backend])
         mode (or mode "watch")
         config-explorer-server (get-in-config [:explorer :server])]
     (when (or (= mode "watch")
               (= mode "jetty"))
       (explore-directories-start config-explorer-server)
       (run-nrepl-server config-backend))
     (if (= mode "jetty")
       (run-jetty-server config-backend)
       (webly-run! mode)))))

(defn -main
  [mode]
  (start-notebook! mode {}))