(ns pinkgorilla.notebook.views.about
  (:require
   [re-frame.core :refer [dispatch]]
   [webly.web.handler :refer [reagent-page]]
   [webly.web.routes :refer [goto!]]))

(defn credit [user txt]
  [:li
   [:span
    [:a.w-16 {:href (str "https://github.com/deas" user)} user]
    txt]])

(defn action [{:keys [on-click href]} text]
  [:div.w-48.h-24.p-5.border-2.border-solid.border-gray-500.rounded.text-center.text-lg.cursor-pointer.bg-pink-100.hover:bg-pink-400
   {:on-click on-click
    :href href} text])

(defn notebook-about []
  [:div.container
   [:h1.mt-5.text-2xl.italic "Welcome to" [:span.pl-5.text-pink-800.text-3xl.non-italic "PinkGorilla Notebook"]]

   ; Action
   [:div.mt-5
    [:div.flex.flex-column.justify-evenly
     [action {:on-click #(goto! :ui/explorer)} "Explorer"]
     [action {:on-click #(dispatch [:document/new])} "New Notebook"]
     [action {:href "https://clojurians.zulipchat.com/#narrow/stream/212578-pink-gorilla-dev"} "Zulip Chat"]]]

   ; Features
   [:div.bg-orange-300.mt-5
    [:h1.text-2xl "Features"]
    [:ul.list-disc
     [:li "Notebook with clj kernel"]
     [:li "Many visualization components"]]]

   [:div.bg-orange-300.mt-5
    [:h1.text-2xl {:on-click #(goto! :ui/explorer)}
     "Documentation"]]

   [:div.bg-green-300.mt-5
    [:h1.text-2xl "Credits"]
    [:ul.list-disc.prose
     [credit "JonyEpsilon" "legacy gorilla-repl (with js frontend)"]
     [credit "deas" "port to re-frame, nrepl-relay, build-automation, unit-tests"]
     [credit "awb99" "gorilla-ui, goldly"]
     [credit "mauricioszabo" "goldly sci compiler, nrepl-tooling"]
     [credit "daslu" "notworking and testing, clojisr"]]]])

(defmethod reagent-page :notebook/about [& args]
  [notebook-about])