(defproject org.pinkgorilla/notebook-clj "0.0.6"
  :description "notebook - with jetty nrepl kernel"
  :url "https://github.com/pink-gorilla/notebook-ui"
  :license {:name "MIT"}
  :deploy-repositories [["releases" {:url "https://clojars.org/repo"
                                     :username :env/release_username
                                     :password :env/release_password
                                     :sign-releases false}]]

  :prep-tasks [;"javac"
              ; "compile" ; creates .class files
               ]

  :release-tasks [["vcs" "assert-committed"]
                  ["bump-version" "release"]
                  ["vcs" "commit" "Release %s"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["deploy"]
                  ["bump-version"]
                  ["vcs" "commit" "Begin %s"]
                  ["vcs" "push"]]

  :source-paths ["src"] ; "test"
  ;:test-paths ["test"]
  :target-path  "target/jar"
  :resource-paths  ["resources"
                    "target/webly"] ; bundle (will be added to the jar)
  :main ;^:skip-aot 
  pinkgorilla.notebook.app
  ; :aot [pinkgorilla.notebook.app]
  ;; :jar-exclusions   [#"(?:^|\/)foo\/" #"(?:^|\/)demo\/" #"(?:^|\/)compiled.*\/" #"html$"]

  :clean-targets ^{:protect false} [:target-path
                                    [:demo :builds :app :compiler :output-dir]
                                    [:demo :builds :app :compiler :output-to]]

  :managed-dependencies [; to avoid a :exclusion mess, we define certain versions numbers centrally

                         ; clojure
                         [org.clojure/clojure "1.10.1"]
                         [org.clojure/core.async "1.3.610"]
                         [org.clojure/clojurescript "1.10.773"]
                         [org.clojure/tools.analyzer "1.0.0"]
                         [com.google.javascript/closure-compiler-unshaded "v20200719"]
                         [com.google.code.findbugs/jsr305 "3.0.2"]
                         [org.clojure/tools.logging "1.1.0"]
                         [org.jboss.logging/jboss-logging "3.4.1.Final"]

                         ; serialization libraries are dependencies of many libraries,
                         [org.clojure/core.memoize "1.0.236"]
                         [org.clojure/data.json "1.0.0"]
                         [org.clojure/data.fressian "1.0.0"]
                         [org.clojure/data.xml "0.0.8"]
                         [org.clojure/data.csv "1.0.0"]
                         [org.clojure/core.match "1.0.0"]
                         [com.cognitect/transit-clj "1.0.324"]
                         [com.cognitect/transit-cljs "0.8.264"]
                         [com.cognitect/transit-java "1.0.343"]
                         [com.fasterxml.jackson.core/jackson-core "2.11.2"]
                         [com.fasterxml.jackson.dataformat/jackson-dataformat-cbor "2.11.2"]
                         [com.fasterxml.jackson.dataformat/jackson-dataformat-smile "2.11.2"]

                         [cheshire "5.10.0"]
                         [com.taoensso/encore "2.122.0"]
                         ; patches to get most uptodate version for certain conflicts:
                         [commons-codec "1.14"] ; selmer and clj-http (via gorilla-explore)
                         [ring/ring-codec "1.1.2"] ; ring and compojure
                         [org.flatland/useful "0.11.6"] ; clojail and ring-middleware-format
                         [tigris "0.1.2"]

                         [nrepl "0.8.0"]
                         [org.apache.httpcomponents/httpasyncclient "4.1.4"]
                         [org.apache.httpcomponents/httpcore "4.4.13"]
                         [org.ow2.asm/asm "8.0.1"]]

  :dependencies [[nrepl "0.8.0"]
                 [org.pinkgorilla/webly "0.0.27"] ; brings shadow
                 [org.pinkgorilla/notebook-ui "0.0.75"] ; brings nrepl-middleware + gorilla-ui
                 [info.sunng/ring-jetty9-adapter "0.14.0"]
                 ; user dependencies
                 [org.pinkgorilla/gorilla-plot "1.2.5" :exclusions [org.clojure/clojurescript]]]

  :profiles {:dev  {:dependencies [[clj-kondo "2020.07.29"]
                                   [thheller/shadow-cljsjs "0.0.21"]]
                    :plugins      [[lein-cljfmt "0.6.6"]
                                   [lein-cloverage "1.1.2"]
                                   [lein-ancient "0.6.15"]
                                   [lein-resource "17.06.1"]
                                   [lein-shell "0.5.0"]]
                    :aliases      {"clj-kondo"
                                   ["run" "-m" "clj-kondo.main"]

                                   "bump-version" ^{:doc "Increases project.clj version number (used by CI)."}
                                   ["change" "version" "leiningen.release/bump-version"]}
                    :cloverage    {:codecov? false ; https://github.com/codecov/example-clojure
                                  ;; In case we want to exclude stuff
                                  ;; :ns-exclude-regex [#".*util.instrument"]
                                  ;; :test-ns-regex [#"^((?!debug-integration-test).)*$$"]
                                   }
                   ;; TODO : Make cljfmt really nice : https://devhub.io/repos/bbatsov-cljfmt
                    :cljfmt       {:indents {as->                [[:inner 0]]
                                             with-debug-bindings [[:inner 0]]
                                             merge-meta          [[:inner 0]]
                                             try-if-let          [[:block 1]]}}}}

  :aliases {; only for testing:
            "build-shadow-ci" ["run" "-m" "shadow.cljs.devtools.cli" "compile" ":webly"]

            ;; APP

            "build-dev"  ^{:doc "compiles bundle via webly"}
            ["run" "-m" "webly.build-cli" "compile" "+dev" "pinkgorilla.notebook.app/handler" "pinkgorilla.notebook.app"]

            "build-prod"  ^{:doc "compiles bundle via webly"}
            ["run" "-m" "webly.build-cli" "release" "+dev" "pinkgorilla.notebook.app/handler" "pinkgorilla.notebook.app"]

            "notebook"  ^{:doc "Runs pinkgorilla notebook (jetty webserver incl nrepl-relay)"}
            ["run" "-m" "pinkgorilla.notebook.app" "watch"]})
