goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__63948 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__63949 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__63949);

try{try{var seq__63950 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__63951 = null;
var count__63952 = (0);
var i__63953 = (0);
while(true){
if((i__63953 < count__63952)){
var vec__63960 = chunk__63951.cljs$core$IIndexed$_nth$arity$2(null,i__63953);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63960,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63960,(1),null);
var temp__5733__auto___64005 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___64005)){
var effect_fn_64006 = temp__5733__auto___64005;
(effect_fn_64006.cljs$core$IFn$_invoke$arity$1 ? effect_fn_64006.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_64006.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__64007 = seq__63950;
var G__64008 = chunk__63951;
var G__64009 = count__63952;
var G__64010 = (i__63953 + (1));
seq__63950 = G__64007;
chunk__63951 = G__64008;
count__63952 = G__64009;
i__63953 = G__64010;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63950);
if(temp__5735__auto__){
var seq__63950__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63950__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63950__$1);
var G__64011 = cljs.core.chunk_rest(seq__63950__$1);
var G__64012 = c__4550__auto__;
var G__64013 = cljs.core.count(c__4550__auto__);
var G__64014 = (0);
seq__63950 = G__64011;
chunk__63951 = G__64012;
count__63952 = G__64013;
i__63953 = G__64014;
continue;
} else {
var vec__63963 = cljs.core.first(seq__63950__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63963,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63963,(1),null);
var temp__5733__auto___64015 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___64015)){
var effect_fn_64016 = temp__5733__auto___64015;
(effect_fn_64016.cljs$core$IFn$_invoke$arity$1 ? effect_fn_64016.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_64016.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__64017 = cljs.core.next(seq__63950__$1);
var G__64018 = null;
var G__64019 = (0);
var G__64020 = (0);
seq__63950 = G__64017;
chunk__63951 = G__64018;
count__63952 = G__64019;
i__63953 = G__64020;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__63654__auto___64021 = re_frame.interop.now();
var duration__63655__auto___64022 = (end__63654__auto___64021 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__63655__auto___64022,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__63654__auto___64021);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__63948);
}} else {
var seq__63966 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__63967 = null;
var count__63968 = (0);
var i__63969 = (0);
while(true){
if((i__63969 < count__63968)){
var vec__63978 = chunk__63967.cljs$core$IIndexed$_nth$arity$2(null,i__63969);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63978,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63978,(1),null);
var temp__5733__auto___64023 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___64023)){
var effect_fn_64024 = temp__5733__auto___64023;
(effect_fn_64024.cljs$core$IFn$_invoke$arity$1 ? effect_fn_64024.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_64024.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__64025 = seq__63966;
var G__64026 = chunk__63967;
var G__64027 = count__63968;
var G__64028 = (i__63969 + (1));
seq__63966 = G__64025;
chunk__63967 = G__64026;
count__63968 = G__64027;
i__63969 = G__64028;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63966);
if(temp__5735__auto__){
var seq__63966__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63966__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63966__$1);
var G__64029 = cljs.core.chunk_rest(seq__63966__$1);
var G__64030 = c__4550__auto__;
var G__64031 = cljs.core.count(c__4550__auto__);
var G__64032 = (0);
seq__63966 = G__64029;
chunk__63967 = G__64030;
count__63968 = G__64031;
i__63969 = G__64032;
continue;
} else {
var vec__63981 = cljs.core.first(seq__63966__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63981,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63981,(1),null);
var temp__5733__auto___64033 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___64033)){
var effect_fn_64034 = temp__5733__auto___64033;
(effect_fn_64034.cljs$core$IFn$_invoke$arity$1 ? effect_fn_64034.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_64034.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__64035 = cljs.core.next(seq__63966__$1);
var G__64036 = null;
var G__64037 = (0);
var G__64038 = (0);
seq__63966 = G__64035;
chunk__63967 = G__64036;
count__63968 = G__64037;
i__63969 = G__64038;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__63984 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__63985 = null;
var count__63986 = (0);
var i__63987 = (0);
while(true){
if((i__63987 < count__63986)){
var map__63993 = chunk__63985.cljs$core$IIndexed$_nth$arity$2(null,i__63987);
var map__63993__$1 = (((((!((map__63993 == null))))?(((((map__63993.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63993.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63993):map__63993);
var effect = map__63993__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63993__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63993__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__63984,chunk__63985,count__63986,i__63987,map__63993,map__63993__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__63984,chunk__63985,count__63986,i__63987,map__63993,map__63993__$1,effect,ms,dispatch))
,ms);
}


var G__64043 = seq__63984;
var G__64044 = chunk__63985;
var G__64045 = count__63986;
var G__64046 = (i__63987 + (1));
seq__63984 = G__64043;
chunk__63985 = G__64044;
count__63986 = G__64045;
i__63987 = G__64046;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63984);
if(temp__5735__auto__){
var seq__63984__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63984__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63984__$1);
var G__64047 = cljs.core.chunk_rest(seq__63984__$1);
var G__64048 = c__4550__auto__;
var G__64049 = cljs.core.count(c__4550__auto__);
var G__64050 = (0);
seq__63984 = G__64047;
chunk__63985 = G__64048;
count__63986 = G__64049;
i__63987 = G__64050;
continue;
} else {
var map__63995 = cljs.core.first(seq__63984__$1);
var map__63995__$1 = (((((!((map__63995 == null))))?(((((map__63995.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63995.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63995):map__63995);
var effect = map__63995__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63995__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63995__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__63984,chunk__63985,count__63986,i__63987,map__63995,map__63995__$1,effect,ms,dispatch,seq__63984__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__63984,chunk__63985,count__63986,i__63987,map__63995,map__63995__$1,effect,ms,dispatch,seq__63984__$1,temp__5735__auto__))
,ms);
}


var G__64054 = cljs.core.next(seq__63984__$1);
var G__64055 = null;
var G__64056 = (0);
var G__64057 = (0);
seq__63984 = G__64054;
chunk__63985 = G__64055;
count__63986 = G__64056;
i__63987 = G__64057;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__63997 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__63998 = null;
var count__63999 = (0);
var i__64000 = (0);
while(true){
if((i__64000 < count__63999)){
var event = chunk__63998.cljs$core$IIndexed$_nth$arity$2(null,i__64000);
re_frame.router.dispatch(event);


var G__64058 = seq__63997;
var G__64059 = chunk__63998;
var G__64060 = count__63999;
var G__64061 = (i__64000 + (1));
seq__63997 = G__64058;
chunk__63998 = G__64059;
count__63999 = G__64060;
i__64000 = G__64061;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63997);
if(temp__5735__auto__){
var seq__63997__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63997__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__63997__$1);
var G__64062 = cljs.core.chunk_rest(seq__63997__$1);
var G__64063 = c__4550__auto__;
var G__64064 = cljs.core.count(c__4550__auto__);
var G__64065 = (0);
seq__63997 = G__64062;
chunk__63998 = G__64063;
count__63999 = G__64064;
i__64000 = G__64065;
continue;
} else {
var event = cljs.core.first(seq__63997__$1);
re_frame.router.dispatch(event);


var G__64066 = cljs.core.next(seq__63997__$1);
var G__64067 = null;
var G__64068 = (0);
var G__64069 = (0);
seq__63997 = G__64066;
chunk__63998 = G__64067;
count__63999 = G__64068;
i__64000 = G__64069;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__64001 = cljs.core.seq(value);
var chunk__64002 = null;
var count__64003 = (0);
var i__64004 = (0);
while(true){
if((i__64004 < count__64003)){
var event = chunk__64002.cljs$core$IIndexed$_nth$arity$2(null,i__64004);
clear_event(event);


var G__64072 = seq__64001;
var G__64073 = chunk__64002;
var G__64074 = count__64003;
var G__64075 = (i__64004 + (1));
seq__64001 = G__64072;
chunk__64002 = G__64073;
count__64003 = G__64074;
i__64004 = G__64075;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__64001);
if(temp__5735__auto__){
var seq__64001__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__64001__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__64001__$1);
var G__64076 = cljs.core.chunk_rest(seq__64001__$1);
var G__64077 = c__4550__auto__;
var G__64078 = cljs.core.count(c__4550__auto__);
var G__64079 = (0);
seq__64001 = G__64076;
chunk__64002 = G__64077;
count__64003 = G__64078;
i__64004 = G__64079;
continue;
} else {
var event = cljs.core.first(seq__64001__$1);
clear_event(event);


var G__64080 = cljs.core.next(seq__64001__$1);
var G__64081 = null;
var G__64082 = (0);
var G__64083 = (0);
seq__64001 = G__64080;
chunk__64002 = G__64081;
count__64003 = G__64082;
i__64004 = G__64083;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
