goog.provide('pinkgorilla.notebook_ui.codemirror.extension.completion');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('re_frame.core');
goog.require('cljs.reader');
goog.require('reagent.core');
goog.require('cljs.tools.reader');
pinkgorilla.notebook_ui.codemirror.extension.completion.wordChars = "[^\\s\\(\\)\\[\\]\\{\\},`']*";
pinkgorilla.notebook_ui.codemirror.extension.completion.word_in_line = (function pinkgorilla$notebook_ui$codemirror$extension$completion$word_in_line(line,lno,cno){
var back = cljs.core.get.cljs$core$IFn$_invoke$arity$2(line.slice((0),cno).match((new RegExp([pinkgorilla.notebook_ui.codemirror.extension.completion.wordChars,"$"].join('')))),(0));
var forward = cljs.core.get.cljs$core$IFn$_invoke$arity$2(line.slice(cno).match((new RegExp(["^",pinkgorilla.notebook_ui.codemirror.extension.completion.wordChars].join('')))),(0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),({"line": lno, "ch": (cno - cljs.core.count(back))}),new cljs.core.Keyword(null,"end","end",-268185958),({"line": lno, "ch": (cno + cljs.core.count(forward))})], null);
});
pinkgorilla.notebook_ui.codemirror.extension.completion.cm_get_range = (function pinkgorilla$notebook_ui$codemirror$extension$completion$cm_get_range(cm,range){
return cm.getRange(new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(range),new cljs.core.Keyword(null,"end","end",-268185958).cljs$core$IFn$_invoke$arity$1(range));
});
/**
 * Find the current 'word' according to CodeMirror's `wordChars' list
 */
pinkgorilla.notebook_ui.codemirror.extension.completion.cm_current_word = (function pinkgorilla$notebook_ui$codemirror$extension$completion$cm_current_word(cm){
var pos = cm.getCursor();
var line_no = pos.line;
var column_no = pos.ch;
var line_range = cm.getLine(column_no,line_no);
if(cljs.core.truth_(line_range)){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init2571683730222641663.clj",92,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-range: ",line_range], null);
}),null)),null,-1924334840);

return pinkgorilla.notebook_ui.codemirror.extension.completion.cm_get_range(cm,pinkgorilla.notebook_ui.codemirror.extension.completion.word_in_line(line_range,line_no,column_no));
} else {
return null;
}
});
pinkgorilla.notebook_ui.codemirror.extension.completion.get_completion_candidates = (function pinkgorilla$notebook_ui$codemirror$extension$completion$get_completion_candidates(cm){
var word = pinkgorilla.notebook_ui.codemirror.extension.completion.cm_current_word(cm);
if(cljs.core.empty_QMARK_(word)){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init2571683730222641663.clj",99,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["no current word - cannot get hint!"], null);
}),null)),null,-1339623756);
} else {
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init2571683730222641663.clj",101,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["getting code-completion for word: ",word], null);
}),null)),null,1919850045);

var G__74680_74692 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("completion","hint","completion/hint",-1183694070),word,"user",""], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__74680_74692) : re_frame.core.dispatch.call(null,G__74680_74692));

return true;
}
});
/**
 * Get a new completion state.
 */
pinkgorilla.notebook_ui.codemirror.extension.completion.hint = (function pinkgorilla$notebook_ui$codemirror$extension$completion$hint(p__74681){
var map__74682 = p__74681;
var map__74682__$1 = (((((!((map__74682 == null))))?(((((map__74682.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74682.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__74682):map__74682);
var cm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74682__$1,new cljs.core.Keyword(null,"cm","cm",540591536));
var e = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74682__$1,new cljs.core.Keyword(null,"e","e",1381269198));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init2571683730222641663.clj",108,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["hint-get .. "], null);
}),null)),null,-2062109512);

if(cljs.core.truth_(cm)){
pinkgorilla.notebook_ui.codemirror.extension.completion.get_completion_candidates(cm);
} else {
}

return e.preventDefault();
});
/**
 * Get a new completion state.
 */
pinkgorilla.notebook_ui.codemirror.extension.completion.hint_prior = (function pinkgorilla$notebook_ui$codemirror$extension$completion$hint_prior(p__74684){
var map__74685 = p__74684;
var map__74685__$1 = (((((!((map__74685 == null))))?(((((map__74685.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74685.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__74685):map__74685);
var cm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74685__$1,new cljs.core.Keyword(null,"cm","cm",540591536));
var e = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74685__$1,new cljs.core.Keyword(null,"e","e",1381269198));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init2571683730222641663.clj",116,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["hint-prior .. "], null);
}),null)),null,-2056425475);

var G__74687_74693 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("completion","prior","completion/prior",-481875588)], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__74687_74693) : re_frame.core.dispatch.call(null,G__74687_74693));

return e.preventDefault();
});
/**
 * Get a new completion state.
 */
pinkgorilla.notebook_ui.codemirror.extension.completion.hint_next = (function pinkgorilla$notebook_ui$codemirror$extension$completion$hint_next(p__74688){
var map__74689 = p__74688;
var map__74689__$1 = (((((!((map__74689 == null))))?(((((map__74689.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74689.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__74689):map__74689);
var cm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74689__$1,new cljs.core.Keyword(null,"cm","cm",540591536));
var e = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74689__$1,new cljs.core.Keyword(null,"e","e",1381269198));
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"pinkgorilla.notebook-ui.codemirror.extension.completion","/tmp/form-init2571683730222641663.clj",123,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["hint-next .. "], null);
}),null)),null,1138644144);

pinkgorilla.notebook_ui.codemirror.extension.completion.get_completion_candidates(cm);

var G__74691_74694 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("completion","next","completion/next",1497262191)], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__74691_74694) : re_frame.core.dispatch.call(null,G__74691_74694));

return e.preventDefault();
});

//# sourceMappingURL=pinkgorilla.notebook_ui.codemirror.extension.completion.js.map
