goog.provide('pinkgorilla.dsl.leaflet');
goog.require('cljs.core');
pinkgorilla.dsl.leaflet.default_options = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"zoom","zoom",-1827487038),new cljs.core.Keyword(null,"line-join","line-join",-1560936092),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"center","center",-748944368),new cljs.core.Keyword(null,"dash-array","dash-array",2130256592),new cljs.core.Keyword(null,"weight","weight",-1262796205),new cljs.core.Keyword(null,"opacity","opacity",397153780),new cljs.core.Keyword(null,"line-cap","line-cap",448406012),new cljs.core.Keyword(null,"height","height",1025178622)],[(10),"miter","steelblue",(600),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [8.5407166,-79.8833319], null),"1, 0",5.0,1.0,"butt",(400)]);
pinkgorilla.dsl.leaflet.transpose_coord = (function pinkgorilla$dsl$leaflet$transpose_coord(p__65915){
var vec__65916 = p__65915;
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65916,(0),null);
var lon = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65916,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lon,lat], null);
});
pinkgorilla.dsl.leaflet.multipoint_feature = (function pinkgorilla$dsl$leaflet$multipoint_feature(coords){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"Feature","Feature",2013251655),new cljs.core.Keyword(null,"geometry","geometry",-405034994),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"MultiPoint","MultiPoint",507414646),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668),cljs.core.map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.dsl.leaflet.transpose_coord,coords)], null)], null);
});
pinkgorilla.dsl.leaflet.linestring_feature = (function pinkgorilla$dsl$leaflet$linestring_feature(coords){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"Feature","Feature",2013251655),new cljs.core.Keyword(null,"geometry","geometry",-405034994),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"LineString","LineString",-1553785666),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668),cljs.core.map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.dsl.leaflet.transpose_coord,coords)], null)], null);
});
pinkgorilla.dsl.leaflet.polygon_feature = (function pinkgorilla$dsl$leaflet$polygon_feature(coords_arrays){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"Feature","Feature",2013251655),new cljs.core.Keyword(null,"geometry","geometry",-405034994),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"Polygon","Polygon",-148258306),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__65931_SHARP_){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.dsl.leaflet.transpose_coord,p1__65931_SHARP_);
}),coords_arrays)], null)], null);
});
if((typeof pinkgorilla !== 'undefined') && (typeof pinkgorilla.dsl !== 'undefined') && (typeof pinkgorilla.dsl.leaflet !== 'undefined') && (typeof pinkgorilla.dsl.leaflet.geojson_for_geodesc !== 'undefined')){
} else {
pinkgorilla.dsl.leaflet.geojson_for_geodesc = (function (){var method_table__4613__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__65932 = cljs.core.get_global_hierarchy;
return (fexpr__65932.cljs$core$IFn$_invoke$arity$0 ? fexpr__65932.cljs$core$IFn$_invoke$arity$0() : fexpr__65932.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("pinkgorilla.dsl.leaflet","geojson-for-geodesc"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
pinkgorilla.dsl.leaflet.geojson_for_geodesc.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"geojson","geojson",-719473398),(function (geodesc){
return new cljs.core.Keyword(null,"desc","desc",2093485764).cljs$core$IFn$_invoke$arity$1(geodesc);
}));
pinkgorilla.dsl.leaflet.geojson_for_geodesc.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"points","points",-1486596883),(function (geodesc){
return pinkgorilla.dsl.leaflet.multipoint_feature(new cljs.core.Keyword(null,"desc","desc",2093485764).cljs$core$IFn$_invoke$arity$1(geodesc));
}));
pinkgorilla.dsl.leaflet.geojson_for_geodesc.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"line","line",212345235),(function (geodesc){
return pinkgorilla.dsl.leaflet.linestring_feature(new cljs.core.Keyword(null,"desc","desc",2093485764).cljs$core$IFn$_invoke$arity$1(geodesc));
}));
pinkgorilla.dsl.leaflet.geojson_for_geodesc.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"polygon","polygon",837053759),(function (geodesc){
return pinkgorilla.dsl.leaflet.polygon_feature(new cljs.core.Keyword(null,"desc","desc",2093485764).cljs$core$IFn$_invoke$arity$1(geodesc));
}));
/**
 * parses custom syntax for geo-data specification.
 * see unit test
 * [vec of points] & [:kw1 val1 :kw2 val2]   
 */
pinkgorilla.dsl.leaflet.parse_args = (function pinkgorilla$dsl$leaflet$parse_args(args){
var args__$1 = args;
var geodescs = cljs.core.PersistentVector.EMPTY;
var options = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(cljs.core.not(cljs.core.seq(args__$1))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [geodescs,options], null);
} else {
var arg = cljs.core.first(args__$1);
var rstargs = cljs.core.next(args__$1);
if((arg instanceof cljs.core.Keyword)){
if(cljs.core.seq(rstargs)){
var G__65957 = cljs.core.next(rstargs);
var G__65958 = geodescs;
var G__65959 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(options,arg,cljs.core.first(rstargs));
args__$1 = G__65957;
geodescs = G__65958;
options = G__65959;
continue;
} else {
return null;
}
} else {
var G__65960 = rstargs;
var G__65961 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(geodescs,arg);
var G__65962 = options;
args__$1 = G__65960;
geodescs = G__65961;
options = G__65962;
continue;
}
}
break;
}
});
pinkgorilla.dsl.leaflet.canonicalize_geodesc = (function pinkgorilla$dsl$leaflet$canonicalize_geodesc(default_type,g){
var type_desig = cljs.core.first(g);
var desc = cljs.core.second(g);
var canon = (((type_desig instanceof cljs.core.Keyword))?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),type_desig,new cljs.core.Keyword(null,"desc","desc",2093485764),desc], null):new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),default_type,new cljs.core.Keyword(null,"desc","desc",2093485764),g], null));
return canon;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
pinkgorilla.dsl.leaflet.LeafletView = (function (geodescs,opts,__meta,__extmap,__hash){
this.geodescs = geodescs;
this.opts = opts;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4374__auto__,k__4375__auto__){
var self__ = this;
var this__4374__auto____$1 = this;
return this__4374__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4375__auto__,null);
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4376__auto__,k65934,else__4377__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var G__65938 = k65934;
var G__65938__$1 = (((G__65938 instanceof cljs.core.Keyword))?G__65938.fqn:null);
switch (G__65938__$1) {
case "geodescs":
return self__.geodescs;

break;
case "opts":
return self__.opts;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k65934,else__4377__auto__);

}
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4393__auto__,f__4394__auto__,init__4395__auto__){
var self__ = this;
var this__4393__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4396__auto__,p__65939){
var vec__65940 = p__65939;
var k__4397__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65940,(0),null);
var v__4398__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65940,(1),null);
return (f__4394__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4394__auto__.cljs$core$IFn$_invoke$arity$3(ret__4396__auto__,k__4397__auto__,v__4398__auto__) : f__4394__auto__.call(null,ret__4396__auto__,k__4397__auto__,v__4398__auto__));
}),init__4395__auto__,this__4393__auto____$1);
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4388__auto__,writer__4389__auto__,opts__4390__auto__){
var self__ = this;
var this__4388__auto____$1 = this;
var pr_pair__4391__auto__ = (function (keyval__4392__auto__){
return cljs.core.pr_sequential_writer(writer__4389__auto__,cljs.core.pr_writer,""," ","",opts__4390__auto__,keyval__4392__auto__);
});
return cljs.core.pr_sequential_writer(writer__4389__auto__,pr_pair__4391__auto__,"#pinkgorilla.dsl.leaflet.LeafletView{",", ","}",opts__4390__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"geodescs","geodescs",-105626026),self__.geodescs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opts","opts",155075701),self__.opts],null))], null),self__.__extmap));
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__65933){
var self__ = this;
var G__65933__$1 = this;
return (new cljs.core.RecordIter((0),G__65933__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"geodescs","geodescs",-105626026),new cljs.core.Keyword(null,"opts","opts",155075701)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4372__auto__){
var self__ = this;
var this__4372__auto____$1 = this;
return self__.__meta;
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4369__auto__){
var self__ = this;
var this__4369__auto____$1 = this;
return (new pinkgorilla.dsl.leaflet.LeafletView(self__.geodescs,self__.opts,self__.__meta,self__.__extmap,self__.__hash));
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4370__auto__){
var self__ = this;
var this__4370__auto____$1 = this;
var h__4232__auto__ = self__.__hash;
if((!((h__4232__auto__ == null)))){
return h__4232__auto__;
} else {
var h__4232__auto____$1 = (function (coll__4371__auto__){
return (-1319916287 ^ cljs.core.hash_unordered_coll(coll__4371__auto__));
})(this__4370__auto____$1);
(self__.__hash = h__4232__auto____$1);

return h__4232__auto____$1;
}
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this65935,other65936){
var self__ = this;
var this65935__$1 = this;
return (((!((other65936 == null)))) && ((this65935__$1.constructor === other65936.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65935__$1.geodescs,other65936.geodescs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65935__$1.opts,other65936.opts)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65935__$1.__extmap,other65936.__extmap)));
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4383__auto__,k__4384__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"opts","opts",155075701),null,new cljs.core.Keyword(null,"geodescs","geodescs",-105626026),null], null), null),k__4384__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4383__auto____$1),self__.__meta),k__4384__auto__);
} else {
return (new pinkgorilla.dsl.leaflet.LeafletView(self__.geodescs,self__.opts,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4384__auto__)),null));
}
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4381__auto__,k__4382__auto__,G__65933){
var self__ = this;
var this__4381__auto____$1 = this;
var pred__65943 = cljs.core.keyword_identical_QMARK_;
var expr__65944 = k__4382__auto__;
if(cljs.core.truth_((pred__65943.cljs$core$IFn$_invoke$arity$2 ? pred__65943.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"geodescs","geodescs",-105626026),expr__65944) : pred__65943.call(null,new cljs.core.Keyword(null,"geodescs","geodescs",-105626026),expr__65944)))){
return (new pinkgorilla.dsl.leaflet.LeafletView(G__65933,self__.opts,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__65943.cljs$core$IFn$_invoke$arity$2 ? pred__65943.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"opts","opts",155075701),expr__65944) : pred__65943.call(null,new cljs.core.Keyword(null,"opts","opts",155075701),expr__65944)))){
return (new pinkgorilla.dsl.leaflet.LeafletView(self__.geodescs,G__65933,self__.__meta,self__.__extmap,null));
} else {
return (new pinkgorilla.dsl.leaflet.LeafletView(self__.geodescs,self__.opts,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4382__auto__,G__65933),null));
}
}
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4386__auto__){
var self__ = this;
var this__4386__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"geodescs","geodescs",-105626026),self__.geodescs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opts","opts",155075701),self__.opts,null))], null),self__.__extmap));
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4373__auto__,G__65933){
var self__ = this;
var this__4373__auto____$1 = this;
return (new pinkgorilla.dsl.leaflet.LeafletView(self__.geodescs,self__.opts,G__65933,self__.__extmap,self__.__hash));
}));

(pinkgorilla.dsl.leaflet.LeafletView.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4379__auto__,entry__4380__auto__){
var self__ = this;
var this__4379__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4380__auto__)){
return this__4379__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4380__auto__,(0)),cljs.core._nth(entry__4380__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4379__auto____$1,entry__4380__auto__);
}
}));

(pinkgorilla.dsl.leaflet.LeafletView.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"geodescs","geodescs",1534905501,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null)], null);
}));

(pinkgorilla.dsl.leaflet.LeafletView.cljs$lang$type = true);

(pinkgorilla.dsl.leaflet.LeafletView.cljs$lang$ctorPrSeq = (function (this__4417__auto__){
return (new cljs.core.List(null,"pinkgorilla.dsl.leaflet/LeafletView",null,(1),null));
}));

(pinkgorilla.dsl.leaflet.LeafletView.cljs$lang$ctorPrWriter = (function (this__4417__auto__,writer__4418__auto__){
return cljs.core._write(writer__4418__auto__,"pinkgorilla.dsl.leaflet/LeafletView");
}));

/**
 * Positional factory function for pinkgorilla.dsl.leaflet/LeafletView.
 */
pinkgorilla.dsl.leaflet.__GT_LeafletView = (function pinkgorilla$dsl$leaflet$__GT_LeafletView(geodescs,opts){
return (new pinkgorilla.dsl.leaflet.LeafletView(geodescs,opts,null,null,null));
});

/**
 * Factory function for pinkgorilla.dsl.leaflet/LeafletView, taking a map of keywords to field values.
 */
pinkgorilla.dsl.leaflet.map__GT_LeafletView = (function pinkgorilla$dsl$leaflet$map__GT_LeafletView(G__65937){
var extmap__4413__auto__ = (function (){var G__65946 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__65937,new cljs.core.Keyword(null,"geodescs","geodescs",-105626026),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
if(cljs.core.record_QMARK_(G__65937)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__65946);
} else {
return G__65946;
}
})();
return (new pinkgorilla.dsl.leaflet.LeafletView(new cljs.core.Keyword(null,"geodescs","geodescs",-105626026).cljs$core$IFn$_invoke$arity$1(G__65937),new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(G__65937),null,cljs.core.not_empty(extmap__4413__auto__),null));
});

/**
 * Plots geometries on a map.
 */
pinkgorilla.dsl.leaflet.geo = (function pinkgorilla$dsl$leaflet$geo(var_args){
var args__4736__auto__ = [];
var len__4730__auto___65964 = arguments.length;
var i__4731__auto___65965 = (0);
while(true){
if((i__4731__auto___65965 < len__4730__auto___65964)){
args__4736__auto__.push((arguments[i__4731__auto___65965]));

var G__65966 = (i__4731__auto___65965 + (1));
i__4731__auto___65965 = G__65966;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return pinkgorilla.dsl.leaflet.geo.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

(pinkgorilla.dsl.leaflet.geo.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var vec__65949 = pinkgorilla.dsl.leaflet.parse_args(args);
var geometries = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65949,(0),null);
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65949,(1),null);
return (new pinkgorilla.dsl.leaflet.LeafletView(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__65947_SHARP_){
return pinkgorilla.dsl.leaflet.canonicalize_geodesc(new cljs.core.Keyword(null,"points","points",-1486596883),p1__65947_SHARP_);
}),geometries),opts,null,null,null));
}));

(pinkgorilla.dsl.leaflet.geo.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(pinkgorilla.dsl.leaflet.geo.cljs$lang$applyTo = (function (seq65948){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq65948));
}));

/**
 * Plots geometries on a map.
 */
pinkgorilla.dsl.leaflet.geojson = (function pinkgorilla$dsl$leaflet$geojson(var_args){
var args__4736__auto__ = [];
var len__4730__auto___65967 = arguments.length;
var i__4731__auto___65968 = (0);
while(true){
if((i__4731__auto___65968 < len__4730__auto___65967)){
args__4736__auto__.push((arguments[i__4731__auto___65968]));

var G__65969 = (i__4731__auto___65968 + (1));
i__4731__auto___65968 = G__65969;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return pinkgorilla.dsl.leaflet.geojson.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

(pinkgorilla.dsl.leaflet.geojson.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var vec__65954 = pinkgorilla.dsl.leaflet.parse_args(args);
var geodescs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65954,(0),null);
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65954,(1),null);
return (new pinkgorilla.dsl.leaflet.LeafletView(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__65952_SHARP_){
return pinkgorilla.dsl.leaflet.canonicalize_geodesc(new cljs.core.Keyword(null,"geojson","geojson",-719473398),p1__65952_SHARP_);
}),geodescs),opts,null,null,null));
}));

(pinkgorilla.dsl.leaflet.geojson.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(pinkgorilla.dsl.leaflet.geojson.cljs$lang$applyTo = (function (seq65953){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq65953));
}));


//# sourceMappingURL=pinkgorilla.dsl.leaflet.js.map
