goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__66216 = (line + (1));
var G__66217 = (1);
var G__66218 = (counter + (1));
line = G__66216;
col = G__66217;
counter = G__66218;
continue;
} else {
var G__66219 = line;
var G__66220 = (col + (1));
var G__66221 = (counter + (1));
line = G__66219;
col = G__66220;
counter = G__66221;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__66222 = cljs.core.next(chars);
var G__66223 = (n__$1 - (1));
chars = G__66222;
n__$1 = G__66223;
continue;
} else {
var G__66224 = cljs.core.next(chars);
var G__66225 = n__$1;
chars = G__66224;
n__$1 = G__66225;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__66193){
var map__66194 = p__66193;
var map__66194__$1 = (((((!((map__66194 == null))))?(((((map__66194.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66194.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__66194):map__66194);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66194__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66194__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66194__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66194__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__66197_66226 = cljs.core.seq(full_reasons);
var chunk__66198_66227 = null;
var count__66199_66228 = (0);
var i__66200_66229 = (0);
while(true){
if((i__66200_66229 < count__66199_66228)){
var r_66230 = chunk__66198_66227.cljs$core$IIndexed$_nth$arity$2(null,i__66200_66229);
instaparse.failure.print_reason(r_66230);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__66231 = seq__66197_66226;
var G__66232 = chunk__66198_66227;
var G__66233 = count__66199_66228;
var G__66234 = (i__66200_66229 + (1));
seq__66197_66226 = G__66231;
chunk__66198_66227 = G__66232;
count__66199_66228 = G__66233;
i__66200_66229 = G__66234;
continue;
} else {
var temp__5735__auto___66235 = cljs.core.seq(seq__66197_66226);
if(temp__5735__auto___66235){
var seq__66197_66236__$1 = temp__5735__auto___66235;
if(cljs.core.chunked_seq_QMARK_(seq__66197_66236__$1)){
var c__4550__auto___66237 = cljs.core.chunk_first(seq__66197_66236__$1);
var G__66238 = cljs.core.chunk_rest(seq__66197_66236__$1);
var G__66239 = c__4550__auto___66237;
var G__66240 = cljs.core.count(c__4550__auto___66237);
var G__66241 = (0);
seq__66197_66226 = G__66238;
chunk__66198_66227 = G__66239;
count__66199_66228 = G__66240;
i__66200_66229 = G__66241;
continue;
} else {
var r_66242 = cljs.core.first(seq__66197_66236__$1);
instaparse.failure.print_reason(r_66242);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__66243 = cljs.core.next(seq__66197_66236__$1);
var G__66244 = null;
var G__66245 = (0);
var G__66246 = (0);
seq__66197_66226 = G__66243;
chunk__66198_66227 = G__66244;
count__66199_66228 = G__66245;
i__66200_66229 = G__66246;
continue;
}
} else {
}
}
break;
}

var seq__66211 = cljs.core.seq(partial_reasons);
var chunk__66212 = null;
var count__66213 = (0);
var i__66214 = (0);
while(true){
if((i__66214 < count__66213)){
var r = chunk__66212.cljs$core$IIndexed$_nth$arity$2(null,i__66214);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__66248 = seq__66211;
var G__66249 = chunk__66212;
var G__66250 = count__66213;
var G__66251 = (i__66214 + (1));
seq__66211 = G__66248;
chunk__66212 = G__66249;
count__66213 = G__66250;
i__66214 = G__66251;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__66211);
if(temp__5735__auto__){
var seq__66211__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__66211__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__66211__$1);
var G__66254 = cljs.core.chunk_rest(seq__66211__$1);
var G__66255 = c__4550__auto__;
var G__66256 = cljs.core.count(c__4550__auto__);
var G__66257 = (0);
seq__66211 = G__66254;
chunk__66212 = G__66255;
count__66213 = G__66256;
i__66214 = G__66257;
continue;
} else {
var r = cljs.core.first(seq__66211__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__66258 = cljs.core.next(seq__66211__$1);
var G__66259 = null;
var G__66260 = (0);
var G__66261 = (0);
seq__66211 = G__66258;
chunk__66212 = G__66259;
count__66213 = G__66260;
i__66214 = G__66261;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=instaparse.failure.js.map
