goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_(path)){
return cljs.core.every_QMARK_(com.rpl.specter.static_path_QMARK_,path);
} else {
return (!(com.rpl.specter.impl.dynamic_param_QMARK_(path)));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__74434__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
if(((cljs.core.sequential_QMARK_(ret)) && (com.rpl.specter.static_path_QMARK_(ret)))){
return com.rpl.specter.impl.comp_paths_STAR_(ret);
} else {
if(((cljs.core.sequential_QMARK_(ret)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(ret))))){
return cljs.core.first(ret);
} else {
return ret;

}
}
};
var G__74434 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__74435__i = 0, G__74435__a = new Array(arguments.length -  0);
while (G__74435__i < G__74435__a.length) {G__74435__a[G__74435__i] = arguments[G__74435__i + 0]; ++G__74435__i;}
  args = new cljs.core.IndexedSeq(G__74435__a,0,null);
} 
return G__74434__delegate.call(this,args);};
G__74434.cljs$lang$maxFixedArity = 0;
G__74434.cljs$lang$applyTo = (function (arglist__74436){
var args = cljs.core.seq(arglist__74436);
return G__74434__delegate(args);
});
G__74434.cljs$core$IFn$_invoke$arity$variadic = G__74434__delegate;
return G__74434;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__4736__auto__ = [];
var len__4730__auto___74437 = arguments.length;
var i__4731__auto___74438 = (0);
while(true){
if((i__4731__auto___74438 < len__4730__auto___74437)){
args__4736__auto__.push((arguments[i__4731__auto___74438]));

var G__74439 = (i__4731__auto___74438 + (1));
i__4731__auto___74438 = G__74439;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

(com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_(cljs.core.vec(apath));
}));

(com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq74102){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq74102));
}));

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
var G__74103 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74104 = structure;
return (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(G__74103,G__74104) : com.rpl.specter.compiled_select.call(null,G__74103,G__74104));
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
var G__74105 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74106 = structure;
return (com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(G__74105,G__74106) : com.rpl.specter.compiled_select_one.call(null,G__74105,G__74106));
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
var G__74107 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74108 = structure;
return (com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2(G__74107,G__74108) : com.rpl.specter.compiled_select_one_BANG_.call(null,G__74107,G__74108));
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
var G__74109 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74110 = structure;
return (com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2(G__74109,G__74110) : com.rpl.specter.compiled_select_first.call(null,G__74109,G__74110));
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
var G__74112 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74113 = structure;
return (com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2(G__74112,G__74113) : com.rpl.specter.compiled_select_any.call(null,G__74112,G__74113));
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
var G__74114 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74115 = structure;
return (com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__74114,G__74115) : com.rpl.specter.compiled_selected_any_QMARK_.call(null,G__74114,G__74115));
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
var G__74116 = com.rpl.specter.impl.comp_paths_STAR_(apath);
var G__74117 = structure;
return (com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(G__74116,G__74117) : com.rpl.specter.compiled_traverse.call(null,G__74116,G__74117));
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
var G__74118 = com.rpl.specter.impl.comp_paths_STAR_(apath);
return (com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1(G__74118) : com.rpl.specter.compiled_traverse_all.call(null,G__74118));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Version of vtransform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_vtransform = com.rpl.specter.impl.compiled_vtransform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
var G__74119 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74120 = transform_fn;
var G__74121 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__74119,G__74120,G__74121) : com.rpl.specter.compiled_transform.call(null,G__74119,G__74120,G__74121));
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal` or `vterminal`. Error is thrown if navigation finishes
 * at a non-terminal navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
var G__74122 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74123 = structure;
return (com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2(G__74122,G__74123) : com.rpl.specter.compiled_multi_transform.call(null,G__74122,G__74123));
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
var G__74124 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74125 = val;
var G__74126 = structure;
return (com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3(G__74124,G__74125,G__74126) : com.rpl.specter.compiled_setval.call(null,G__74124,G__74125,G__74126));
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___74440 = arguments.length;
var i__4731__auto___74441 = (0);
while(true){
if((i__4731__auto___74441 < len__4730__auto___74440)){
args__4736__auto__.push((arguments[i__4731__auto___74441]));

var G__74442 = (i__4731__auto___74441 + (1));
i__4731__auto___74441 = G__74442;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

(com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__74131){
var map__74132 = p__74131;
var map__74132__$1 = (((((!((map__74132 == null))))?(((((map__74132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74132.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__74132):map__74132);
var merge_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74132__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
var G__74134 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__74135 = transform_fn;
var G__74136 = structure;
var G__74137 = new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341);
var G__74138 = merge_fn;
return (com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5 ? com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5(G__74134,G__74135,G__74136,G__74137,G__74138) : com.rpl.specter.compiled_replace_in.call(null,G__74134,G__74135,G__74136,G__74137,G__74138));
}));

(com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq74127){
var G__74128 = cljs.core.first(seq74127);
var seq74127__$1 = cljs.core.next(seq74127);
var G__74129 = cljs.core.first(seq74127__$1);
var seq74127__$2 = cljs.core.next(seq74127__$1);
var G__74130 = cljs.core.first(seq74127__$2);
var seq74127__$3 = cljs.core.next(seq74127__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74128,G__74129,G__74130,seq74127__$3);
}));

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (navfn){
var latenavfn = (com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1(navfn) : com.rpl.specter.late_resolved_fn.call(null,navfn));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74443__delegate = function (args){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(latenavfn,args);
};
var G__74443 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__74444__i = 0, G__74444__a = new Array(arguments.length -  0);
while (G__74444__i < G__74444__a.length) {G__74444__a[G__74444__i] = arguments[G__74444__i + 0]; ++G__74444__i;}
  args = new cljs.core.IndexedSeq(G__74444__a,0,null);
} 
return G__74443__delegate.call(this,args);};
G__74443.cljs$lang$maxFixedArity = 0;
G__74443.cljs$lang$applyTo = (function (arglist__74445){
var args = cljs.core.seq(arglist__74445);
return G__74443__delegate(args);
});
G__74443.cljs$core$IFn$_invoke$arity$variadic = G__74443__delegate;
return G__74443;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74139 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74139 = (function (meta74140){
this.meta74140 = meta74140;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74139.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74141,meta74140__$1){
var self__ = this;
var _74141__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74139(meta74140__$1));
}));

(com.rpl.specter.t_com$rpl$specter74139.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74141){
var self__ = this;
var _74141__$1 = this;
return self__.meta74140;
}));

(com.rpl.specter.t_com$rpl$specter74139.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74139.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter74139.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return structure;
}));

(com.rpl.specter.t_com$rpl$specter74139.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74140","meta74140",-2015421075,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74139.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74139.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74139");

(com.rpl.specter.t_com$rpl$specter74139.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74139");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74139.
 */
com.rpl.specter.__GT_t_com$rpl$specter74139 = (function com$rpl$specter$__GT_t_com$rpl$specter74139(meta74140){
return (new com.rpl.specter.t_com$rpl$specter74139(meta74140));
});

}

return (new com.rpl.specter.t_com$rpl$specter74139(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * Defines an endpoint in the navigation the transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74143 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74143 = (function (afn,meta74144){
this.afn = afn;
this.meta74144 = meta74144;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74143.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74145,meta74144__$1){
var self__ = this;
var _74145__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74143(self__.afn,meta74144__$1));
}));

(com.rpl.specter.t_com$rpl$specter74143.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74145){
var self__ = this;
var _74145__$1 = this;
return self__.meta74144;
}));

(com.rpl.specter.t_com$rpl$specter74143.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74143.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter74143.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_(self__.afn,vals,structure);
}));

(com.rpl.specter.t_com$rpl$specter74143.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta74144","meta74144",-561185537,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74143.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74143.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74143");

(com.rpl.specter.t_com$rpl$specter74143.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74143");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74143.
 */
com.rpl.specter.__GT_t_com$rpl$specter74143 = (function com$rpl$specter$__GT_t_com$rpl$specter74143(afn__$1,meta74144){
return (new com.rpl.specter.t_com$rpl$specter74143(afn__$1,meta74144));
});

}

return (new com.rpl.specter.t_com$rpl$specter74143(afn,null));
}));
/**
 * Defines an endpoint in the navigation the transform function run.The transform
 *        function works differently than it does in `transform`. Rather than receive
 *        collected vals spliced in as the first arguments to the function, this function
 *        always takes two arguemnts. The first is all collected vals in a vector, and
 *        the second is the navigated value.
 */
com.rpl.specter.vterminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74146 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74146 = (function (afn,meta74147){
this.afn = afn;
this.meta74147 = meta74147;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74146.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74148,meta74147__$1){
var self__ = this;
var _74148__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74146(self__.afn,meta74147__$1));
}));

(com.rpl.specter.t_com$rpl$specter74146.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74148){
var self__ = this;
var _74148__$1 = this;
return self__.meta74147;
}));

(com.rpl.specter.t_com$rpl$specter74146.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74146.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter74146.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(vals,structure) : self__.afn.call(null,vals,structure));
}));

(com.rpl.specter.t_com$rpl$specter74146.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta74147","meta74147",419343893,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74146.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74146.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74146");

(com.rpl.specter.t_com$rpl$specter74146.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74146");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74146.
 */
com.rpl.specter.__GT_t_com$rpl$specter74146 = (function com$rpl$specter$__GT_t_com$rpl$specter74146(afn__$1,meta74147){
return (new com.rpl.specter.t_com$rpl$specter74146(afn__$1,meta74147));
});

}

return (new com.rpl.specter.t_com$rpl$specter74146(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
var G__74149 = com.rpl.specter.impl.fast_constantly(v);
return (com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1(G__74149) : com.rpl.specter.terminal.call(null,G__74149));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform(structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74150 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74150 = (function (meta74151){
this.meta74151 = meta74151;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74150.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74152,meta74151__$1){
var self__ = this;
var _74152__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74150(meta74151__$1));
}));

(com.rpl.specter.t_com$rpl$specter74150.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74152){
var self__ = this;
var _74152__$1 = this;
return self__.meta74151;
}));

(com.rpl.specter.t_com$rpl$specter74150.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74150.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74150.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return com.rpl.specter.navs.all_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74150.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74151","meta74151",555638493,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74150.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74150.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74150");

(com.rpl.specter.t_com$rpl$specter74150.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74150");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74150.
 */
com.rpl.specter.__GT_t_com$rpl$specter74150 = (function com$rpl$specter$__GT_t_com$rpl$specter74150(meta74151){
return (new com.rpl.specter.t_com$rpl$specter74150(meta74151));
});

}

return (new com.rpl.specter.t_com$rpl$specter74150(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74154 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74154 = (function (meta74155){
this.meta74155 = meta74155;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74154.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74156,meta74155__$1){
var self__ = this;
var _74156__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74154(meta74155__$1));
}));

(com.rpl.specter.t_com$rpl$specter74154.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74156){
var self__ = this;
var _74156__$1 = this;
return self__.meta74155;
}));

(com.rpl.specter.t_com$rpl$specter74154.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74154.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74154.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
}));

(com.rpl.specter.t_com$rpl$specter74154.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74155","meta74155",-196645968,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74154.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74154.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74154");

(com.rpl.specter.t_com$rpl$specter74154.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74154");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74154.
 */
com.rpl.specter.__GT_t_com$rpl$specter74154 = (function com$rpl$specter$__GT_t_com$rpl$specter74154(meta74155){
return (new com.rpl.specter.t_com$rpl$specter74154(meta74155));
});

}

return (new com.rpl.specter.t_com$rpl$specter74154(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38235__auto__,v){
var ret__38236__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(v) : next_fn.call(null,v));
if((ret__38236__auto__ === com.rpl.specter.NONE)){
return curr__38235__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38236__auto__)){
return cljs.core.reduced(ret__38236__auto__);
} else {
return ret__38236__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74157 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74157 = (function (meta74158){
this.meta74158 = meta74158;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74157.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74159,meta74158__$1){
var self__ = this;
var _74159__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74157(meta74158__$1));
}));

(com.rpl.specter.t_com$rpl$specter74157.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74159){
var self__ = this;
var _74159__$1 = this;
return self__.meta74158;
}));

(com.rpl.specter.t_com$rpl$specter74157.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74157.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38235__auto__,v){
var ret__38236__auto__ = next_fn(v);
if((ret__38236__auto__ === com.rpl.specter.NONE)){
return curr__38235__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38236__auto__)){
return cljs.core.reduced(ret__38236__auto__);
} else {
return ret__38236__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
}));

(com.rpl.specter.t_com$rpl$specter74157.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74157.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74158","meta74158",71102077,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74157.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74157.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74157");

(com.rpl.specter.t_com$rpl$specter74157.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74157");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74157.
 */
com.rpl.specter.__GT_t_com$rpl$specter74157 = (function com$rpl$specter$__GT_t_com$rpl$specter74157(meta74158){
return (new com.rpl.specter.t_com$rpl$specter74157(meta74158));
});

}

return (new com.rpl.specter.t_com$rpl$specter74157(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38235__auto__,k){
var ret__38236__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(k) : next_fn.call(null,k));
if((ret__38236__auto__ === com.rpl.specter.NONE)){
return curr__38235__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38236__auto__)){
return cljs.core.reduced(ret__38236__auto__);
} else {
return ret__38236__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74160 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74160 = (function (meta74161){
this.meta74161 = meta74161;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74160.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74162,meta74161__$1){
var self__ = this;
var _74162__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74160(meta74161__$1));
}));

(com.rpl.specter.t_com$rpl$specter74160.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74162){
var self__ = this;
var _74162__$1 = this;
return self__.meta74161;
}));

(com.rpl.specter.t_com$rpl$specter74160.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74160.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38235__auto__,k){
var ret__38236__auto__ = next_fn(k);
if((ret__38236__auto__ === com.rpl.specter.NONE)){
return curr__38235__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38236__auto__)){
return cljs.core.reduced(ret__38236__auto__);
} else {
return ret__38236__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
}));

(com.rpl.specter.t_com$rpl$specter74160.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74160.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74161","meta74161",-1710327583,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74160.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74160.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74160");

(com.rpl.specter.t_com$rpl$specter74160.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74160");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74160.
 */
com.rpl.specter.__GT_t_com$rpl$specter74160 = (function com$rpl$specter$__GT_t_com$rpl$specter74160(meta74161){
return (new com.rpl.specter.t_com$rpl$specter74160(meta74161));
});

}

return (new com.rpl.specter.t_com$rpl$specter74160(null));
})()
;
com.rpl.specter.VAL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74164 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74164 = (function (meta74165){
this.meta74165 = meta74165;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74164.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74166,meta74165__$1){
var self__ = this;
var _74166__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74164(meta74165__$1));
}));

(com.rpl.specter.t_com$rpl$specter74164.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74166){
var self__ = this;
var _74166__$1 = this;
return self__.meta74165;
}));

(com.rpl.specter.t_com$rpl$specter74164.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74164.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39918__auto__,vals__39919__auto__,structure,next_fn__39920__auto__){
var self__ = this;
var this__39918__auto____$1 = this;
var G__74167 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39919__auto__,structure);
var G__74168 = structure;
return (next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2(G__74167,G__74168) : next_fn__39920__auto__.call(null,G__74167,G__74168));
}));

(com.rpl.specter.t_com$rpl$specter74164.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39918__auto__,vals__39919__auto__,structure,next_fn__39920__auto__){
var self__ = this;
var this__39918__auto____$1 = this;
var G__74169 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39919__auto__,structure);
var G__74170 = structure;
return (next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2(G__74169,G__74170) : next_fn__39920__auto__.call(null,G__74169,G__74170));
}));

(com.rpl.specter.t_com$rpl$specter74164.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74165","meta74165",-2082642781,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74164.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74164.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74164");

(com.rpl.specter.t_com$rpl$specter74164.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74164");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74164.
 */
com.rpl.specter.__GT_t_com$rpl$specter74164 = (function com$rpl$specter$__GT_t_com$rpl$specter74164(meta74165){
return (new com.rpl.specter.t_com$rpl$specter74164(meta74165));
});

}

return (new com.rpl.specter.t_com$rpl$specter74164(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last));
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first));


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
var G__74171 = structure;
var G__74172 = s;
var G__74173 = com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s);
var G__74174 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__74171,G__74172,G__74173,G__74174) : com.rpl.specter.navs.srange_transform.call(null,G__74171,G__74172,G__74173,G__74174));
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj((function (start_index_fn,end_index_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74175 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74175 = (function (start_index_fn,end_index_fn,meta74176){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta74176 = meta74176;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74175.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74177,meta74176__$1){
var self__ = this;
var _74177__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74175(self__.start_index_fn,self__.end_index_fn,meta74176__$1));
}));

(com.rpl.specter.t_com$rpl$specter74175.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74177){
var self__ = this;
var _74177__$1 = this;
return self__.meta74176;
}));

(com.rpl.specter.t_com$rpl$specter74175.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74175.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s),next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74175.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
var G__74178 = structure;
var G__74179 = s;
var G__74180 = com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s);
var G__74181 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__74178,G__74179,G__74180,G__74181) : com.rpl.specter.navs.srange_transform.call(null,G__74178,G__74179,G__74180,G__74181));
}));

(com.rpl.specter.t_com$rpl$specter74175.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta74176","meta74176",-1901364310,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74175.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74175.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74175");

(com.rpl.specter.t_com$rpl$specter74175.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74175");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74175.
 */
com.rpl.specter.__GT_t_com$rpl$specter74175 = (function com$rpl$specter$__GT_t_com$rpl$specter74175(start_index_fn__$1,end_index_fn__$1,meta74176){
return (new com.rpl.specter.t_com$rpl$specter74175(start_index_fn__$1,end_index_fn__$1,meta74176));
});

}

return (new com.rpl.specter.t_com$rpl$specter74175(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select(structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,start,end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn));
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj((function (start,end){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74182 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74182 = (function (start,end,meta74183){
this.start = start;
this.end = end;
this.meta74183 = meta74183;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74182.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74184,meta74183__$1){
var self__ = this;
var _74184__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74182(self__.start,self__.end,meta74183__$1));
}));

(com.rpl.specter.t_com$rpl$specter74182.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74184){
var self__ = this;
var _74184__$1 = this;
return self__.meta74183;
}));

(com.rpl.specter.t_com$rpl$specter74182.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74182.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return com.rpl.specter.navs.srange_select(structure,self__.start,self__.end,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74182.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,self__.start,self__.end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn));
}));

(com.rpl.specter.t_com$rpl$specter74182.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta74183","meta74183",-1104144588,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74182.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74182.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74182");

(com.rpl.specter.t_com$rpl$specter74182.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74182");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74182.
 */
com.rpl.specter.__GT_t_com$rpl$specter74182 = (function com$rpl$specter$__GT_t_com$rpl$specter74182(start__$1,end__$1,meta74183){
return (new com.rpl.specter.t_com$rpl$specter74182(start__$1,end__$1,meta74183));
});

}

return (new com.rpl.specter.t_com$rpl$specter74182(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38235__auto__,p__74185){
var vec__74187 = p__74185;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74187,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74187,(1),null);
var ret__38236__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__38236__auto__ === com.rpl.specter.NONE)){
return curr__38235__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38236__auto__)){
return cljs.core.reduced(ret__38236__auto__);
} else {
return ret__38236__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj((function (pred){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74190 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74190 = (function (pred,meta74191){
this.pred = pred;
this.meta74191 = meta74191;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74190.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74192,meta74191__$1){
var self__ = this;
var _74192__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74190(self__.pred,meta74191__$1));
}));

(com.rpl.specter.t_com$rpl$specter74190.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74192){
var self__ = this;
var _74192__$1 = this;
return self__.meta74191;
}));

(com.rpl.specter.t_com$rpl$specter74190.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74190.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38235__auto__,p__74193){
var vec__74194 = p__74193;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74194,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74194,(1),null);
var ret__38236__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__38236__auto__ === com.rpl.specter.NONE)){
return curr__38235__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38236__auto__)){
return cljs.core.reduced(ret__38236__auto__);
} else {
return ret__38236__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,self__.pred));
}));

(com.rpl.specter.t_com$rpl$specter74190.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(self__.pred,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74190.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta74191","meta74191",-1706434860,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74190.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74190.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74190");

(com.rpl.specter.t_com$rpl$specter74190.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74190");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74190.
 */
com.rpl.specter.__GT_t_com$rpl$specter74190 = (function com$rpl$specter$__GT_t_com$rpl$specter74190(pred__$1,meta74191){
return (new com.rpl.specter.t_com$rpl$specter74190(pred__$1,meta74191));
});

}

return (new com.rpl.specter.t_com$rpl$specter74190(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
var G__74197 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74197) : next_fn.call(null,G__74197));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,""))),structure].join('');
} else {
var to_prepend = (function (){var G__74198 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74198) : next_fn.call(null,G__74198));
})();
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74199 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74199 = (function (meta74200){
this.meta74200 = meta74200;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74199.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74201,meta74200__$1){
var self__ = this;
var _74201__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74199(meta74200__$1));
}));

(com.rpl.specter.t_com$rpl$specter74199.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74201){
var self__ = this;
var _74201__$1 = this;
return self__.meta74200;
}));

(com.rpl.specter.t_com$rpl$specter74199.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74199.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter74199.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn("")),structure].join('');
} else {
var to_prepend = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
}));

(com.rpl.specter.t_com$rpl$specter74199.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74200","meta74200",-874341734,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74199.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74199.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74199");

(com.rpl.specter.t_com$rpl$specter74199.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74199");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74199.
 */
com.rpl.specter.__GT_t_com$rpl$specter74199 = (function com$rpl$specter$__GT_t_com$rpl$specter74199(meta74200){
return (new com.rpl.specter.t_com$rpl$specter74199(meta74200));
});

}

return (new com.rpl.specter.t_com$rpl$specter74199(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
var G__74202 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74202) : next_fn.call(null,G__74202));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,"")))].join('');
} else {
var to_append = (function (){var G__74203 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74203) : next_fn.call(null,G__74203));
})();
return com.rpl.specter.navs.append_all(structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74204 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74204 = (function (meta74205){
this.meta74205 = meta74205;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74204.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74206,meta74205__$1){
var self__ = this;
var _74206__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74204(meta74205__$1));
}));

(com.rpl.specter.t_com$rpl$specter74204.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74206){
var self__ = this;
var _74206__$1 = this;
return self__.meta74205;
}));

(com.rpl.specter.t_com$rpl$specter74204.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74204.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter74204.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn(""))].join('');
} else {
var to_append = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all(structure,to_append);
}
}));

(com.rpl.specter.t_com$rpl$specter74204.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74205","meta74205",-1969137868,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74204.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74204.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74204");

(com.rpl.specter.t_com$rpl$specter74204.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74204");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74204.
 */
com.rpl.specter.__GT_t_com$rpl$specter74204 = (function com$rpl$specter$__GT_t_com$rpl$specter74204(meta74205){
return (new com.rpl.specter.t_com$rpl$specter74204(meta74205));
});

}

return (new com.rpl.specter.t_com$rpl$specter74204(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74208 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74208 = (function (meta74209){
this.meta74209 = meta74209;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74208.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74210,meta74209__$1){
var self__ = this;
var _74210__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74208(meta74209__$1));
}));

(com.rpl.specter.t_com$rpl$specter74208.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74210){
var self__ = this;
var _74210__$1 = this;
return self__.meta74209;
}));

(com.rpl.specter.t_com$rpl$specter74208.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74208.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter74208.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
}));

(com.rpl.specter.t_com$rpl$specter74208.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74209","meta74209",-113430389,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74208.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74208.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74208");

(com.rpl.specter.t_com$rpl$specter74208.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74208");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74208.
 */
com.rpl.specter.__GT_t_com$rpl$specter74208 = (function com$rpl$specter$__GT_t_com$rpl$specter74208(meta74209){
return (new com.rpl.specter.t_com$rpl$specter74208(meta74209));
});

}

return (new com.rpl.specter.t_com$rpl$specter74208(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74211 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74211 = (function (meta74212){
this.meta74212 = meta74212;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74211.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74213,meta74212__$1){
var self__ = this;
var _74213__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74211(meta74212__$1));
}));

(com.rpl.specter.t_com$rpl$specter74211.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74213){
var self__ = this;
var _74213__$1 = this;
return self__.meta74212;
}));

(com.rpl.specter.t_com$rpl$specter74211.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74211.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter74211.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter74211.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74212","meta74212",2113612280,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74211.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74211.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74211");

(com.rpl.specter.t_com$rpl$specter74211.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74211");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74211.
 */
com.rpl.specter.__GT_t_com$rpl$specter74211 = (function com$rpl$specter$__GT_t_com$rpl$specter74211(meta74212){
return (new com.rpl.specter.t_com$rpl$specter74211(meta74212));
});

}

return (new com.rpl.specter.t_com$rpl$specter74211(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74214 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74214 = (function (meta74215){
this.meta74215 = meta74215;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74214.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74216,meta74215__$1){
var self__ = this;
var _74216__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74214(meta74215__$1));
}));

(com.rpl.specter.t_com$rpl$specter74214.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74216){
var self__ = this;
var _74216__$1 = this;
return self__.meta74215;
}));

(com.rpl.specter.t_com$rpl$specter74214.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74214.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter74214.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter74214.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74215","meta74215",122548944,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74214.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74214.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74214");

(com.rpl.specter.t_com$rpl$specter74214.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74214");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74214.
 */
com.rpl.specter.__GT_t_com$rpl$specter74214 = (function com$rpl$specter$__GT_t_com$rpl$specter74214(meta74215){
return (new com.rpl.specter.t_com$rpl$specter74214(meta74215));
});

}

return (new com.rpl.specter.t_com$rpl$specter74214(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
var G__74217 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74217) : next_fn.call(null,G__74217));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
var newset = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(subset) : next_fn.call(null,subset));
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj((function (aset){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74218 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74218 = (function (aset,meta74219){
this.aset = aset;
this.meta74219 = meta74219;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74218.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74220,meta74219__$1){
var self__ = this;
var _74220__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74218(self__.aset,meta74219__$1));
}));

(com.rpl.specter.t_com$rpl$specter74218.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74220){
var self__ = this;
var _74220__$1 = this;
return self__.meta74219;
}));

(com.rpl.specter.t_com$rpl$specter74218.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74218.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset));
}));

(com.rpl.specter.t_com$rpl$specter74218.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset);
var newset = next_fn(subset);
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
}));

(com.rpl.specter.t_com$rpl$specter74218.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta74219","meta74219",-1286690264,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74218.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74218.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74218");

(com.rpl.specter.t_com$rpl$specter74218.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74218");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74218.
 */
com.rpl.specter.__GT_t_com$rpl$specter74218 = (function com$rpl$specter$__GT_t_com$rpl$specter74218(aset__$1,meta74219){
return (new com.rpl.specter.t_com$rpl$specter74218(aset__$1,meta74219));
});

}

return (new com.rpl.specter.t_com$rpl$specter74218(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
var G__74222 = cljs.core.select_keys(structure,m_keys);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74222) : next_fn.call(null,G__74222));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys(structure,m_keys);
var newmap = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(submap) : next_fn.call(null,submap));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,m_keys),newmap], 0));
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj((function (m_keys){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74223 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74223 = (function (m_keys,meta74224){
this.m_keys = m_keys;
this.meta74224 = meta74224;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74223.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74225,meta74224__$1){
var self__ = this;
var _74225__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74223(self__.m_keys,meta74224__$1));
}));

(com.rpl.specter.t_com$rpl$specter74223.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74225){
var self__ = this;
var _74225__$1 = this;
return self__.meta74224;
}));

(com.rpl.specter.t_com$rpl$specter74223.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74223.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn(cljs.core.select_keys(structure,self__.m_keys));
}));

(com.rpl.specter.t_com$rpl$specter74223.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var submap = cljs.core.select_keys(structure,self__.m_keys);
var newmap = next_fn(submap);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,self__.m_keys),newmap], 0));
}));

(com.rpl.specter.t_com$rpl$specter74223.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta74224","meta74224",-881719994,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74223.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74223.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74223");

(com.rpl.specter.t_com$rpl$specter74223.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74223");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74223.
 */
com.rpl.specter.__GT_t_com$rpl$specter74223 = (function com$rpl$specter$__GT_t_com$rpl$specter74223(m_keys__$1,meta74224){
return (new com.rpl.specter.t_com$rpl$specter74223(m_keys__$1,meta74224));
});

}

return (new com.rpl.specter.t_com$rpl$specter74223(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 * 
 *   Value collection (e.g. collect, collect-one) may not be used in the subpath.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74448__delegate = function (path){
var builder__39921__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74226 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74226 = (function (path,late,meta74227){
this.path = path;
this.late = late;
this.meta74227 = meta74227;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74226.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74228,meta74227__$1){
var self__ = this;
var _74228__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74226(self__.path,self__.late,meta74227__$1));
}));

(com.rpl.specter.t_com$rpl$specter74226.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74228){
var self__ = this;
var _74228__$1 = this;
return self__.meta74227;
}));

(com.rpl.specter.t_com$rpl$specter74226.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74226.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn((com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
}));

(com.rpl.specter.t_com$rpl$specter74226.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var select_result = (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure));
var transformed = next_fn(select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(transformed));
var G__74229 = self__.late;
var G__74230 = (function (_){
var vs = com.rpl.specter.impl.get_cell(values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_(values_to_insert,cljs.core.next);

return cljs.core.first(vs);
} else {
return com.rpl.specter.NONE;
}
});
var G__74231 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__74229,G__74230,G__74231) : com.rpl.specter.compiled_transform.call(null,G__74229,G__74230,G__74231));
}));

(com.rpl.specter.t_com$rpl$specter74226.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta74227","meta74227",940817774,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74226.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74226.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74226");

(com.rpl.specter.t_com$rpl$specter74226.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74226");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74226.
 */
com.rpl.specter.__GT_t_com$rpl$specter74226 = (function com$rpl$specter$__GT_t_com$rpl$specter74226(path__$1,late__$1,meta74227){
return (new com.rpl.specter.t_com$rpl$specter74226(path__$1,late__$1,meta74227));
});

}

return (new com.rpl.specter.t_com$rpl$specter74226(path,late,null));
}));
var curr_params__39922__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39922__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39921__auto__,curr_params__39922__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39921__auto__,curr_params__39922__auto__,null);
}
};
var G__74448 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__74449__i = 0, G__74449__a = new Array(arguments.length -  0);
while (G__74449__i < G__74449__a.length) {G__74449__a[G__74449__i] = arguments[G__74449__i + 0]; ++G__74449__i;}
  path = new cljs.core.IndexedSeq(G__74449__a,0,null);
} 
return G__74448__delegate.call(this,path);};
G__74448.cljs$lang$maxFixedArity = 0;
G__74448.cljs$lang$applyTo = (function (arglist__74450){
var path = cljs.core.seq(arglist__74450);
return G__74448__delegate(path);
});
G__74448.cljs$core$IFn$_invoke$arity$variadic = G__74448__delegate;
return G__74448;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj((function (key){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74232 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74232 = (function (key,meta74233){
this.key = key;
this.meta74233 = meta74233;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74232.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74234,meta74233__$1){
var self__ = this;
var _74234__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74232(self__.key,meta74233__$1));
}));

(com.rpl.specter.t_com$rpl$specter74232.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74234){
var self__ = this;
var _74234__$1 = this;
return self__.meta74233;
}));

(com.rpl.specter.t_com$rpl$specter74232.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74232.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter74232.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
var newkey = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
var dissoced = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(dissoced,newkey,cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.key));
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter74232.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta74233","meta74233",-1521428661,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74232.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74232.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74232");

(com.rpl.specter.t_com$rpl$specter74232.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74232");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74232.
 */
com.rpl.specter.__GT_t_com$rpl$specter74232 = (function com$rpl$specter$__GT_t_com$rpl$specter74232(key__$1,meta74233){
return (new com.rpl.specter.t_com$rpl$specter74232(key__$1,meta74233));
});

}

return (new com.rpl.specter.t_com$rpl$specter74232(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj((function (elem){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74235 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74235 = (function (elem,meta74236){
this.elem = elem;
this.meta74236 = meta74236;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74235.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74237,meta74236__$1){
var self__ = this;
var _74237__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74235(self__.elem,meta74236__$1));
}));

(com.rpl.specter.t_com$rpl$specter74235.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74237){
var self__ = this;
var _74237__$1 = this;
return self__.meta74236;
}));

(com.rpl.specter.t_com$rpl$specter74235.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74235.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter74235.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
var newelem = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
var removed = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(removed,newelem);
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter74235.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta74236","meta74236",-1137806686,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74235.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74235.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74235");

(com.rpl.specter.t_com$rpl$specter74235.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74235");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74235.
 */
com.rpl.specter.__GT_t_com$rpl$specter74235 = (function com$rpl$specter$__GT_t_com$rpl$specter74235(elem__$1,meta74236){
return (new com.rpl.specter.t_com$rpl$specter74235(elem__$1,meta74236));
});

}

return (new com.rpl.specter.t_com$rpl$specter74235(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.keypath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_));
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.must_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_));
/**
 * Navigate to the specified indices one after another. If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.nthpath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_));
/**
 * Navigates to the empty space between the index and the prior index. For select
 *        navigates to NONE, and transforms to non-NONE insert at that position.
 */
com.rpl.specter.before_index = com.rpl.specter.impl.direct_nav_obj((function (index){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74238 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74238 = (function (index,meta74239){
this.index = index;
this.meta74239 = meta74239;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74238.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74240,meta74239__$1){
var self__ = this;
var _74240__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74238(self__.index,meta74239__$1));
}));

(com.rpl.specter.t_com$rpl$specter74238.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74240){
var self__ = this;
var _74240__$1 = this;
return self__.meta74239;
}));

(com.rpl.specter.t_com$rpl$specter74238.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74238.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter74238.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var v = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,com.rpl.specter.NONE) : next_fn.call(null,vals,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === v)){
return structure;
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39928__auto__ = com.rpl.specter.pathcache74242;
var info__39928__auto____$1 = (((info__39928__auto__ == null))?(function (){var info74243 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.srange,new cljs.core.Var(function(){return com.rpl.specter.srange;},new cljs.core.Symbol("com.rpl.specter","srange","com.rpl.specter/srange",-978851939,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"srange","srange",-1324254972,null),"com/rpl/specter.cljc",9,1,755,758,cljs.core.List.EMPTY,"Navigates to the subsequence bound by the indexes start (inclusive)\n          and end (exclusive)",(cljs.core.truth_(com.rpl.specter.srange)?com.rpl.specter.srange.cljs$lang$test:null)])),new cljs.core.Symbol(null,"srange","srange",-1324254972,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null)),com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null))], null),cljs.core.list(new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null));
com.rpl.specter.pathcache74242 = info74243;

return info74243;
})():info__39928__auto__);
var precompiled74244 = com.rpl.specter.impl.cached_path_info_precompiled(info__39928__auto____$1);
var dynamic_QMARK___39929__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39928__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39929__auto__)){
var G__74245 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.srange,self__.index,self__.index], null);
return (precompiled74244.cljs$core$IFn$_invoke$arity$1 ? precompiled74244.cljs$core$IFn$_invoke$arity$1(G__74245) : precompiled74244.call(null,G__74245));
} else {
return precompiled74244;
}
})(),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null),structure);
}
}));

(com.rpl.specter.t_com$rpl$specter74238.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"meta74239","meta74239",1064083846,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74238.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74238.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74238");

(com.rpl.specter.t_com$rpl$specter74238.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74238");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74238.
 */
com.rpl.specter.__GT_t_com$rpl$specter74238 = (function com$rpl$specter$__GT_t_com$rpl$specter74238(index__$1,meta74239){
return (new com.rpl.specter.t_com$rpl$specter74238(index__$1,meta74239));
});

}

return (new com.rpl.specter.t_com$rpl$specter74238(index,null));
}));
/**
 * Navigates to the index of the sequence if within 0 and size. Transforms move element
 *        at that index to the new index, shifting other elements in the sequence.
 */
com.rpl.specter.index_nav = com.rpl.specter.impl.direct_nav_obj((function (i){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74246 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74246 = (function (i,meta74247){
this.i = i;
this.meta74247 = meta74247;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74246.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74248,meta74247__$1){
var self__ = this;
var _74248__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74246(self__.i,meta74247__$1));
}));

(com.rpl.specter.t_com$rpl$specter74246.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74248){
var self__ = this;
var _74248__$1 = this;
return self__.meta74247;
}));

(com.rpl.specter.t_com$rpl$specter74246.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74246.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter74246.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
var newi = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(newi,self__.i)){
return structure;
} else {
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(structure,self__.i);
if(cljs.core.vector_QMARK_(structure)){
var shifted = (((newi < self__.i))?(function (){var j = (self__.i - (1));
var s = structure;
while(true){
if((j < newi)){
return s;
} else {
var G__74451 = (j - (1));
var G__74452 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j + (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__74451;
s = G__74452;
continue;
}
break;
}
})():(function (){var j = (self__.i + (1));
var s = structure;
while(true){
if((j > newi)){
return s;
} else {
var G__74453 = (j + (1));
var G__74454 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j - (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__74453;
s = G__74454;
continue;
}
break;
}
})());
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(shifted,newi,v);
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39928__auto__ = com.rpl.specter.pathcache74249;
var info__39928__auto____$1 = (((info__39928__auto__ == null))?(function (){var info74250 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.before_index,new cljs.core.Var(function(){return com.rpl.specter.before_index;},new cljs.core.Symbol("com.rpl.specter","before-index","com.rpl.specter/before-index",1952616274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),"com/rpl/specter.cljc",15,1,968,971,cljs.core.List.EMPTY,"Navigates to the empty space between the index and the prior index. For select\n          navigates to NONE, and transforms to non-NONE insert at that position.",(cljs.core.truth_(com.rpl.specter.before_index)?com.rpl.specter.before_index.cljs$lang$test:null)])),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(newi,new cljs.core.Symbol(null,"newi","newi",857919881,null))], null),cljs.core.list(new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null));
com.rpl.specter.pathcache74249 = info74250;

return info74250;
})():info__39928__auto__);
var precompiled74251 = com.rpl.specter.impl.cached_path_info_precompiled(info__39928__auto____$1);
var dynamic_QMARK___39929__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39928__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39929__auto__)){
var G__74252 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.before_index,newi], null);
return (precompiled74251.cljs$core$IFn$_invoke$arity$1 ? precompiled74251.cljs$core$IFn$_invoke$arity$1(G__74252) : precompiled74251.call(null,G__74252));
} else {
return precompiled74251;
}
})(),v,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39928__auto__ = com.rpl.specter.pathcache74253;
var info__39928__auto____$1 = (((info__39928__auto__ == null))?(function (){var info74254 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.i,new cljs.core.Symbol(null,"i","i",253690212,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null));
com.rpl.specter.pathcache74253 = info74254;

return info74254;
})():info__39928__auto__);
var precompiled74255 = com.rpl.specter.impl.cached_path_info_precompiled(info__39928__auto____$1);
var dynamic_QMARK___39929__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39928__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39929__auto__)){
var G__74256 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,self__.i], null);
return (precompiled74255.cljs$core$IFn$_invoke$arity$1 ? precompiled74255.cljs$core$IFn$_invoke$arity$1(G__74256) : precompiled74255.call(null,G__74256));
} else {
return precompiled74255;
}
})(),com.rpl.specter.NONE,structure));
}
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter74246.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta74247","meta74247",-784067903,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74246.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74246.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74246");

(com.rpl.specter.t_com$rpl$specter74246.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74246");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74246.
 */
com.rpl.specter.__GT_t_com$rpl$specter74246 = (function com$rpl$specter$__GT_t_com$rpl$specter74246(i__$1,meta74247){
return (new com.rpl.specter.t_com$rpl$specter74246(i__$1,meta74247));
});

}

return (new com.rpl.specter.t_com$rpl$specter74246(i,null));
}));


com.rpl.specter.indexed_vals_select_STAR_ = (function com$rpl$specter$indexed_vals_select_STAR_(start,structure,next_fn){
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38235__auto__,e){
var ret__38236__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

var G__74259 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74259) : next_fn.call(null,G__74259));
})()
;
if((ret__38236__auto__ === com.rpl.specter.NONE)){
return curr__38235__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38236__auto__)){
return cljs.core.reduced(ret__38236__auto__);
} else {
return ret__38236__auto__;
}
}
}),com.rpl.specter.NONE,structure);
});

com.rpl.specter.indexed_vals_transform_STAR_ = (function com$rpl$specter$indexed_vals_transform_STAR_(start,structure,next_fn){
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__74260 = (function (){var G__74263 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(start + curri),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74263) : next_fn.call(null,G__74263));
})();
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74260,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74260,(1),null);
var newi = (newi_STAR_ - start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__39928__auto__ = com.rpl.specter.pathcache74264;
var info__39928__auto____$1 = (((info__39928__auto__ == null))?(function (){var info74265 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__74257_SHARP_){
return (p1__74257_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74257#","p1__74257#",-275389623,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__74257#","p1__74257#",-275389623,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__74258_SHARP_){
return (p1__74258_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74258#","p1__74258#",256465859,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__74258#","p1__74258#",256465859,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74257#","p1__74257#",-275389623,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__74257#","p1__74257#",-275389623,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74258#","p1__74258#",256465859,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__74258#","p1__74258#",256465859,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74257#","p1__74257#",-275389623,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__74257#","p1__74257#",-275389623,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74258#","p1__74258#",256465859,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__74258#","p1__74258#",256465859,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache74264 = info74265;

return info74265;
})():info__39928__auto__);
var precompiled74266 = com.rpl.specter.impl.cached_path_info_precompiled(info__39928__auto____$1);
var dynamic_QMARK___39929__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39928__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39929__auto__)){
var G__74267 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__74257_SHARP_){
return (p1__74257_SHARP_ >= (curri + (1)));
}),(function (p1__74258_SHARP_){
return (p1__74258_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__74257_SHARP_){
return (p1__74257_SHARP_ >= (curri + (1)));
}),(function (p1__74258_SHARP_){
return (p1__74258_SHARP_ <= newi);
})], null);
return (precompiled74266.cljs$core$IFn$_invoke$arity$1 ? precompiled74266.cljs$core$IFn$_invoke$arity$1(G__74267) : precompiled74266.call(null,G__74267));
} else {
return precompiled74266;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39928__auto__ = com.rpl.specter.pathcache74268;
var info__39928__auto____$1 = (((info__39928__auto__ == null))?(function (){var info74269 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache74268 = info74269;

return info74269;
})():info__39928__auto__);
var precompiled74270 = com.rpl.specter.impl.cached_path_info_precompiled(info__39928__auto____$1);
var dynamic_QMARK___39929__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39928__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39929__auto__)){
var G__74271 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled74270.cljs$core$IFn$_invoke$arity$1 ? precompiled74270.cljs$core$IFn$_invoke$arity$1(G__74271) : precompiled74270.call(null,G__74271));
} else {
return precompiled74270;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39928__auto__ = com.rpl.specter.pathcache74272;
var info__39928__auto____$1 = (((info__39928__auto__ == null))?(function (){var info74273 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache74272 = info74273;

return info74273;
})():info__39928__auto__);
var precompiled74274 = com.rpl.specter.impl.cached_path_info_precompiled(info__39928__auto____$1);
var dynamic_QMARK___39929__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39928__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39929__auto__)){
var G__74275 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled74274.cljs$core$IFn$_invoke$arity$1 ? precompiled74274.cljs$core$IFn$_invoke$arity$1(G__74275) : precompiled74274.call(null,G__74275));
} else {
return precompiled74274;
}
})(),newe,s));
}),structure,structure);
});

/**
 * Navigate to [index elem] pairs for each element in a sequence. The sequence will be indexed
 *        starting from `start`. Changing index in transform has same effect as `index-nav`. Indices seen
 *        during transform take into account any shifting from prior sequence elements changing indices.
 */
com.rpl.specter.indexed_vals = com.rpl.specter.impl.direct_nav_obj((function (start){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74276 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74276 = (function (start,meta74277){
this.start = start;
this.meta74277 = meta74277;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74276.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74278,meta74277__$1){
var self__ = this;
var _74278__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74276(self__.start,meta74277__$1));
}));

(com.rpl.specter.t_com$rpl$specter74276.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74278){
var self__ = this;
var _74278__$1 = this;
return self__.meta74277;
}));

(com.rpl.specter.t_com$rpl$specter74276.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74276.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((self__.start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38235__auto__,e){
var ret__38236__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

return next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null));
})()
;
if((ret__38236__auto__ === com.rpl.specter.NONE)){
return curr__38235__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38236__auto__)){
return cljs.core.reduced(ret__38236__auto__);
} else {
return ret__38236__auto__;
}
}
}),com.rpl.specter.NONE,structure);
}));

(com.rpl.specter.t_com$rpl$specter74276.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__74280 = next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.start + curri),e], null));
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74280,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74280,(1),null);
var newi = (newi_STAR_ - self__.start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__39928__auto__ = com.rpl.specter.pathcache74283;
var info__39928__auto____$1 = (((info__39928__auto__ == null))?(function (){var info74284 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__74257_SHARP_){
return (p1__74257_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74257#","p1__74257#",-275389623,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__74257#","p1__74257#",-275389623,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__74258_SHARP_){
return (p1__74258_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74258#","p1__74258#",256465859,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__74258#","p1__74258#",256465859,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74257#","p1__74257#",-275389623,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__74257#","p1__74257#",-275389623,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74258#","p1__74258#",256465859,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__74258#","p1__74258#",256465859,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74257#","p1__74257#",-275389623,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__74257#","p1__74257#",-275389623,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__74258#","p1__74258#",256465859,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__74258#","p1__74258#",256465859,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache74283 = info74284;

return info74284;
})():info__39928__auto__);
var precompiled74285 = com.rpl.specter.impl.cached_path_info_precompiled(info__39928__auto____$1);
var dynamic_QMARK___39929__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39928__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39929__auto__)){
var G__74286 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__74257_SHARP_){
return (p1__74257_SHARP_ >= (curri + (1)));
}),(function (p1__74258_SHARP_){
return (p1__74258_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__74257_SHARP_){
return (p1__74257_SHARP_ >= (curri + (1)));
}),(function (p1__74258_SHARP_){
return (p1__74258_SHARP_ <= newi);
})], null);
return (precompiled74285.cljs$core$IFn$_invoke$arity$1 ? precompiled74285.cljs$core$IFn$_invoke$arity$1(G__74286) : precompiled74285.call(null,G__74286));
} else {
return precompiled74285;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39928__auto__ = com.rpl.specter.pathcache74287;
var info__39928__auto____$1 = (((info__39928__auto__ == null))?(function (){var info74288 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,983,986,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache74287 = info74288;

return info74288;
})():info__39928__auto__);
var precompiled74289 = com.rpl.specter.impl.cached_path_info_precompiled(info__39928__auto____$1);
var dynamic_QMARK___39929__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39928__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39929__auto__)){
var G__74290 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled74289.cljs$core$IFn$_invoke$arity$1 ? precompiled74289.cljs$core$IFn$_invoke$arity$1(G__74290) : precompiled74289.call(null,G__74290));
} else {
return precompiled74289;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__39928__auto__ = com.rpl.specter.pathcache74291;
var info__39928__auto____$1 = (((info__39928__auto__ == null))?(function (){var info74292 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,963,965,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache74291 = info74292;

return info74292;
})():info__39928__auto__);
var precompiled74293 = com.rpl.specter.impl.cached_path_info_precompiled(info__39928__auto____$1);
var dynamic_QMARK___39929__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39928__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39929__auto__)){
var G__74294 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled74293.cljs$core$IFn$_invoke$arity$1 ? precompiled74293.cljs$core$IFn$_invoke$arity$1(G__74294) : precompiled74293.call(null,G__74294));
} else {
return precompiled74293;
}
})(),newe,s));
}),structure,structure);
}));

(com.rpl.specter.t_com$rpl$specter74276.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"meta74277","meta74277",-1902170887,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74276.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74276.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74276");

(com.rpl.specter.t_com$rpl$specter74276.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74276");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74276.
 */
com.rpl.specter.__GT_t_com$rpl$specter74276 = (function com$rpl$specter$__GT_t_com$rpl$specter74276(start__$1,meta74277){
return (new com.rpl.specter.t_com$rpl$specter74276(start__$1,meta74277));
});

}

return (new com.rpl.specter.t_com$rpl$specter74276(start,null));
}));
/**
 * `indexed-vals` with a starting index of 0.
 */
com.rpl.specter.INDEXED_VALS = (com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1((0)) : com.rpl.specter.indexed_vals.call(null,(0)));
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74295 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74295 = (function (afn,meta74296){
this.afn = afn;
this.meta74296 = meta74296;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74295.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74297,meta74296__$1){
var self__ = this;
var _74297__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74295(self__.afn,meta74296__$1));
}));

(com.rpl.specter.t_com$rpl$specter74295.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74297){
var self__ = this;
var _74297__$1 = this;
return self__.meta74296;
}));

(com.rpl.specter.t_com$rpl$specter74295.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74295.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__74298 = vals;
var G__74299 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__74298,G__74299) : next_fn.call(null,G__74298,G__74299));
}));

(com.rpl.specter.t_com$rpl$specter74295.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__74300 = vals;
var G__74301 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__74300,G__74301) : next_fn.call(null,G__74300,G__74301));
}));

(com.rpl.specter.t_com$rpl$specter74295.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta74296","meta74296",351317782,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74295.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74295.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74295");

(com.rpl.specter.t_com$rpl$specter74295.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74295");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74295.
 */
com.rpl.specter.__GT_t_com$rpl$specter74295 = (function com$rpl$specter$__GT_t_com$rpl$specter74295(afn__$1,meta74296){
return (new com.rpl.specter.t_com$rpl$specter74295(afn__$1,meta74296));
});

}

return (new com.rpl.specter.t_com$rpl$specter74295(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__74302 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74302) : next_fn.call(null,G__74302));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__74303 = (function (){var G__74304 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74304) : next_fn.call(null,G__74304));
})();
return (unparse_fn.cljs$core$IFn$_invoke$arity$1 ? unparse_fn.cljs$core$IFn$_invoke$arity$1(G__74303) : unparse_fn.call(null,G__74303));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj((function (parse_fn,unparse_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74305 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74305 = (function (parse_fn,unparse_fn,meta74306){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta74306 = meta74306;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74305.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74307,meta74306__$1){
var self__ = this;
var _74307__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74305(self__.parse_fn,self__.unparse_fn,meta74306__$1));
}));

(com.rpl.specter.t_com$rpl$specter74305.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74307){
var self__ = this;
var _74307__$1 = this;
return self__.meta74306;
}));

(com.rpl.specter.t_com$rpl$specter74305.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74305.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
}));

(com.rpl.specter.t_com$rpl$specter74305.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var G__74308 = next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
return (self__.unparse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.unparse_fn.cljs$core$IFn$_invoke$arity$1(G__74308) : self__.unparse_fn.call(null,G__74308));
}));

(com.rpl.specter.t_com$rpl$specter74305.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta74306","meta74306",1492521980,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74305.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74305.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74305");

(com.rpl.specter.t_com$rpl$specter74305.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74305");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74305.
 */
com.rpl.specter.__GT_t_com$rpl$specter74305 = (function com$rpl$specter$__GT_t_com$rpl$specter74305(parse_fn__$1,unparse_fn__$1,meta74306){
return (new com.rpl.specter.t_com$rpl$specter74305(parse_fn__$1,unparse_fn__$1,meta74306));
});

}

return (new com.rpl.specter.t_com$rpl$specter74305(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
var G__74309 = cljs.core.deref(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74309) : next_fn.call(null,G__74309));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74311 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74311 = (function (meta74312){
this.meta74312 = meta74312;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74311.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74313,meta74312__$1){
var self__ = this;
var _74313__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74311(meta74312__$1));
}));

(com.rpl.specter.t_com$rpl$specter74311.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74313){
var self__ = this;
var _74313__$1 = this;
return self__.meta74312;
}));

(com.rpl.specter.t_com$rpl$specter74311.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74311.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn(cljs.core.deref(structure));
}));

(com.rpl.specter.t_com$rpl$specter74311.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
}));

(com.rpl.specter.t_com$rpl$specter74311.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74312","meta74312",-821520060,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74311.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74311.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74311");

(com.rpl.specter.t_com$rpl$specter74311.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74311");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74311.
 */
com.rpl.specter.__GT_t_com$rpl$specter74311 = (function com$rpl$specter$__GT_t_com$rpl$specter74311(meta74312){
return (new com.rpl.specter.t_com$rpl$specter74311(meta74312));
});

}

return (new com.rpl.specter.t_com$rpl$specter74311(null));
})()
;


com.rpl.specter.regex_nav_select_STAR_ = (function com$rpl$specter$regex_nav_select_STAR_(re,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38235__auto__,s){
var ret__38236__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(s) : next_fn.call(null,s));
if((ret__38236__auto__ === com.rpl.specter.NONE)){
return curr__38235__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38236__auto__)){
return cljs.core.reduced(ret__38236__auto__);
} else {
return ret__38236__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(re,structure));
});

com.rpl.specter.regex_nav_transform_STAR_ = (function com$rpl$specter$regex_nav_transform_STAR_(re,structure,next_fn){
return clojure.string.replace(structure,re,next_fn);
});

com.rpl.specter.regex_nav = com.rpl.specter.impl.direct_nav_obj((function (re){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74314 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74314 = (function (re,meta74315){
this.re = re;
this.meta74315 = meta74315;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74314.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74316,meta74315__$1){
var self__ = this;
var _74316__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74314(self__.re,meta74315__$1));
}));

(com.rpl.specter.t_com$rpl$specter74314.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74316){
var self__ = this;
var _74316__$1 = this;
return self__.meta74315;
}));

(com.rpl.specter.t_com$rpl$specter74314.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74314.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__38235__auto__,s){
var ret__38236__auto__ = next_fn(s);
if((ret__38236__auto__ === com.rpl.specter.NONE)){
return curr__38235__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__38236__auto__)){
return cljs.core.reduced(ret__38236__auto__);
} else {
return ret__38236__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(self__.re,structure));
}));

(com.rpl.specter.t_com$rpl$specter74314.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return clojure.string.replace(structure,self__.re,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74314.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"re","re",1869207729,null),new cljs.core.Symbol(null,"meta74315","meta74315",184799577,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74314.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74314.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74314");

(com.rpl.specter.t_com$rpl$specter74314.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74314");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74314.
 */
com.rpl.specter.__GT_t_com$rpl$specter74314 = (function com$rpl$specter$__GT_t_com$rpl$specter74314(re__$1,meta74315){
return (new com.rpl.specter.t_com$rpl$specter74314(re__$1,meta74315));
});

}

return (new com.rpl.specter.t_com$rpl$specter74314(re,null));
}));
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74465__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return afn;
} else {
var builder__39921__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74319 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74319 = (function (path,temp__5733__auto__,late,meta74320){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta74320 = meta74320;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74319.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74321,meta74320__$1){
var self__ = this;
var _74321__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74319(self__.path,self__.temp__5733__auto__,self__.late,meta74320__$1));
}));

(com.rpl.specter.t_com$rpl$specter74319.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74321){
var self__ = this;
var _74321__$1 = this;
return self__.meta74320;
}));

(com.rpl.specter.t_com$rpl$specter74319.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74319.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__74317_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__74317_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74319.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__74318_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__74318_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74319.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta74320","meta74320",2096889174,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74319.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74319.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74319");

(com.rpl.specter.t_com$rpl$specter74319.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74319");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74319.
 */
com.rpl.specter.__GT_t_com$rpl$specter74319 = (function com$rpl$specter$__GT_t_com$rpl$specter74319(path__$1,temp__5733__auto____$1,late__$1,meta74320){
return (new com.rpl.specter.t_com$rpl$specter74319(path__$1,temp__5733__auto____$1,late__$1,meta74320));
});

}

return (new com.rpl.specter.t_com$rpl$specter74319(path,temp__5733__auto__,late,null));
}));
var curr_params__39922__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39922__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39921__auto__,curr_params__39922__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39921__auto__,curr_params__39922__auto__,null);
}
}
};
var G__74465 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__74466__i = 0, G__74466__a = new Array(arguments.length -  0);
while (G__74466__i < G__74466__a.length) {G__74466__a[G__74466__i] = arguments[G__74466__i + 0]; ++G__74466__i;}
  path = new cljs.core.IndexedSeq(G__74466__a,0,null);
} 
return G__74465__delegate.call(this,path);};
G__74465.cljs$lang$maxFixedArity = 0;
G__74465.cljs$lang$applyTo = (function (arglist__74467){
var path = cljs.core.seq(arglist__74467);
return G__74465__delegate(path);
});
G__74465.cljs$core$IFn$_invoke$arity$variadic = G__74465__delegate;
return G__74465;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74468__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return (function (s){
return cljs.core.not((afn.cljs$core$IFn$_invoke$arity$1 ? afn.cljs$core$IFn$_invoke$arity$1(s) : afn.call(null,s)));
});
} else {
var builder__39921__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74324 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74324 = (function (path,temp__5733__auto__,late,meta74325){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta74325 = meta74325;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74324.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74326,meta74325__$1){
var self__ = this;
var _74326__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74324(self__.path,self__.temp__5733__auto__,self__.late,meta74325__$1));
}));

(com.rpl.specter.t_com$rpl$specter74324.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74326){
var self__ = this;
var _74326__$1 = this;
return self__.meta74325;
}));

(com.rpl.specter.t_com$rpl$specter74324.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74324.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__74322_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__74322_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74324.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__74323_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__74323_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74324.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta74325","meta74325",-1082223416,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74324.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74324.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74324");

(com.rpl.specter.t_com$rpl$specter74324.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74324");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74324.
 */
com.rpl.specter.__GT_t_com$rpl$specter74324 = (function com$rpl$specter$__GT_t_com$rpl$specter74324(path__$1,temp__5733__auto____$1,late__$1,meta74325){
return (new com.rpl.specter.t_com$rpl$specter74324(path__$1,temp__5733__auto____$1,late__$1,meta74325));
});

}

return (new com.rpl.specter.t_com$rpl$specter74324(path,temp__5733__auto__,late,null));
}));
var curr_params__39922__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39922__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39921__auto__,curr_params__39922__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39921__auto__,curr_params__39922__auto__,null);
}
}
};
var G__74468 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__74469__i = 0, G__74469__a = new Array(arguments.length -  0);
while (G__74469__i < G__74469__a.length) {G__74469__a[G__74469__i] = arguments[G__74469__i + 0]; ++G__74469__i;}
  path = new cljs.core.IndexedSeq(G__74469__a,0,null);
} 
return G__74468__delegate.call(this,path);};
G__74468.cljs$lang$maxFixedArity = 0;
G__74468.cljs$lang$applyTo = (function (arglist__74470){
var path = cljs.core.seq(arglist__74470);
return G__74468__delegate(path);
});
G__74468.cljs$core$IFn$_invoke$arity$variadic = G__74468__delegate;
return G__74468;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74471__delegate = function (path){
var G__74327 = com.rpl.specter.ALL;
var G__74328 = (com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.selected_QMARK_.call(null,path));
return (com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2(G__74327,G__74328) : com.rpl.specter.subselect.call(null,G__74327,G__74328));
};
var G__74471 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__74472__i = 0, G__74472__a = new Array(arguments.length -  0);
while (G__74472__i < G__74472__a.length) {G__74472__a[G__74472__i] = arguments[G__74472__i + 0]; ++G__74472__i;}
  path = new cljs.core.IndexedSeq(G__74472__a,0,null);
} 
return G__74471__delegate.call(this,path);};
G__74471.cljs$lang$maxFixedArity = 0;
G__74471.cljs$lang$applyTo = (function (arglist__74473){
var path = cljs.core.seq(arglist__74473);
return G__74471__delegate(path);
});
G__74471.cljs$core$IFn$_invoke$arity$variadic = G__74471__delegate;
return G__74471;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,update_fn){
var builder__39921__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74329 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74329 = (function (path,update_fn,late,late_fn,meta74330){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta74330 = meta74330;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74329.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74331,meta74330__$1){
var self__ = this;
var _74331__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74329(self__.path,self__.update_fn,self__.late,self__.late_fn,meta74330__$1));
}));

(com.rpl.specter.t_com$rpl$specter74329.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74331){
var self__ = this;
var _74331__$1 = this;
return self__.meta74330;
}));

(com.rpl.specter.t_com$rpl$specter74329.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74329.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter74329.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter74329.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta74330","meta74330",497886526,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74329.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74329.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74329");

(com.rpl.specter.t_com$rpl$specter74329.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74329");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74329.
 */
com.rpl.specter.__GT_t_com$rpl$specter74329 = (function com$rpl$specter$__GT_t_com$rpl$specter74329(path__$1,update_fn__$1,late__$1,late_fn__$1,meta74330){
return (new com.rpl.specter.t_com$rpl$specter74329(path__$1,update_fn__$1,late__$1,late_fn__$1,meta74330));
});

}

return (new com.rpl.specter.t_com$rpl$specter74329(path,update_fn,late,late_fn,null));
}));
var curr_params__39922__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),update_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39922__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39921__auto__,curr_params__39922__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39921__auto__,curr_params__39922__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,reduce_fn){
var builder__39921__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74333 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74333 = (function (path,reduce_fn,late,late_fn,meta74334){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta74334 = meta74334;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74333.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74335,meta74334__$1){
var self__ = this;
var _74335__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74333(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta74334__$1));
}));

(com.rpl.specter.t_com$rpl$specter74333.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74335){
var self__ = this;
var _74335__$1 = this;
return self__.meta74334;
}));

(com.rpl.specter.t_com$rpl$specter74333.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74333.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter74333.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter74333.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta74334","meta74334",162062201,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74333.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74333.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74333");

(com.rpl.specter.t_com$rpl$specter74333.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74333");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74333.
 */
com.rpl.specter.__GT_t_com$rpl$specter74333 = (function com$rpl$specter$__GT_t_com$rpl$specter74333(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta74334){
return (new com.rpl.specter.t_com$rpl$specter74333(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta74334));
});

}

return (new com.rpl.specter.t_com$rpl$specter74333(path,reduce_fn,late,late_fn,null));
}));
var curr_params__39922__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),reduce_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39922__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39921__auto__,curr_params__39922__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39921__auto__,curr_params__39922__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. Functions in paths
 *        implicitly convert to this navigator.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
var G__74337 = (function (p1__74336_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__74336_SHARP_,v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__74337) : com.rpl.specter.pred.call(null,G__74337));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
var G__74339 = (function (p1__74338_SHARP_){
return (p1__74338_SHARP_ < v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__74339) : com.rpl.specter.pred.call(null,G__74339));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
var G__74341 = (function (p1__74340_SHARP_){
return (p1__74340_SHARP_ > v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__74341) : com.rpl.specter.pred.call(null,G__74341));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
var G__74343 = (function (p1__74342_SHARP_){
return (p1__74342_SHARP_ <= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__74343) : com.rpl.specter.pred.call(null,G__74343));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
var G__74345 = (function (p1__74344_SHARP_){
return (p1__74344_SHARP_ >= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__74345) : com.rpl.specter.pred.call(null,G__74345));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"null",(function (this$){
return com.rpl.specter.STAY;
}));
(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"string",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"string",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"number",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"number",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"boolean",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"boolean",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"function",(function (this$){
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.pred.call(null,this$));
}));
(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.pred.call(null,this$__$1));
}));
(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.regex_nav.call(null,this$__$1));
}));


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
var G__74346 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74346) : next_fn.call(null,G__74346));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
var G__74347 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74347) : next_fn.call(null,G__74347));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj((function (v){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74348 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74348 = (function (v,meta74349){
this.v = v;
this.meta74349 = meta74349;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74348.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74350,meta74349__$1){
var self__ = this;
var _74350__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74348(self__.v,meta74349__$1));
}));

(com.rpl.specter.t_com$rpl$specter74348.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74350){
var self__ = this;
var _74350__$1 = this;
return self__.meta74349;
}));

(com.rpl.specter.t_com$rpl$specter74348.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74348.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter74348.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter74348.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta74349","meta74349",-1092465432,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74348.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74348.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74348");

(com.rpl.specter.t_com$rpl$specter74348.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74348");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74348.
 */
com.rpl.specter.__GT_t_com$rpl$specter74348 = (function com$rpl$specter$__GT_t_com$rpl$specter74348(v__$1,meta74349){
return (new com.rpl.specter.t_com$rpl$specter74348(v__$1,meta74349));
});

}

return (new com.rpl.specter.t_com$rpl$specter74348(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = (function (){var G__74351 = cljs.core.PersistentHashSet.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__74351) : com.rpl.specter.nil__GT_val.call(null,G__74351));
})();
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = (function (){var G__74352 = cljs.core.List.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__74352) : com.rpl.specter.nil__GT_val.call(null,G__74352));
})();
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = (function (){var G__74353 = cljs.core.PersistentVector.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__74353) : com.rpl.specter.nil__GT_val.call(null,G__74353));
})();


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
var G__74354 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74354) : next_fn.call(null,G__74354));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta(structure,(function (){var G__74355 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74355) : next_fn.call(null,G__74355));
})());
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74356 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74356 = (function (meta74357){
this.meta74357 = meta74357;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74356.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74358,meta74357__$1){
var self__ = this;
var _74358__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74356(meta74357__$1));
}));

(com.rpl.specter.t_com$rpl$specter74356.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74358){
var self__ = this;
var _74358__$1 = this;
return self__.meta74357;
}));

(com.rpl.specter.t_com$rpl$specter74356.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74356.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn(cljs.core.meta(structure));
}));

(com.rpl.specter.t_com$rpl$specter74356.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return cljs.core.with_meta(structure,next_fn(cljs.core.meta(structure)));
}));

(com.rpl.specter.t_com$rpl$specter74356.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74357","meta74357",-1021639874,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74356.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74356.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74356");

(com.rpl.specter.t_com$rpl$specter74356.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74356");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74356.
 */
com.rpl.specter.__GT_t_com$rpl$specter74356 = (function com$rpl$specter$__GT_t_com$rpl$specter74356(meta74357){
return (new com.rpl.specter.t_com$rpl$specter74356(meta74357));
});

}

return (new com.rpl.specter.t_com$rpl$specter74356(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
var G__74360 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74360) : next_fn.call(null,G__74360));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = (function (){var G__74361 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74361) : next_fn.call(null,G__74361));
})();
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74362 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74362 = (function (meta74363){
this.meta74363 = meta74363;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74362.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74364,meta74363__$1){
var self__ = this;
var _74364__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74362(meta74363__$1));
}));

(com.rpl.specter.t_com$rpl$specter74362.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74364){
var self__ = this;
var _74364__$1 = this;
return self__.meta74363;
}));

(com.rpl.specter.t_com$rpl$specter74362.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74362.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn(cljs.core.name(structure));
}));

(com.rpl.specter.t_com$rpl$specter74362.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var new_name = next_fn(cljs.core.name(structure));
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter74362.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74363","meta74363",-91216147,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74362.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74362.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74362");

(com.rpl.specter.t_com$rpl$specter74362.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74362");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74362.
 */
com.rpl.specter.__GT_t_com$rpl$specter74362 = (function com$rpl$specter$__GT_t_com$rpl$specter74362(meta74363){
return (new com.rpl.specter.t_com$rpl$specter74362(meta74363));
});

}

return (new com.rpl.specter.t_com$rpl$specter74362(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
var G__74365 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74365) : next_fn.call(null,G__74365));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name(structure);
var new_ns = (function (){var G__74366 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__74366) : next_fn.call(null,G__74366));
})();
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74367 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74367 = (function (meta74368){
this.meta74368 = meta74368;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74367.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74369,meta74368__$1){
var self__ = this;
var _74369__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74367(meta74368__$1));
}));

(com.rpl.specter.t_com$rpl$specter74367.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74369){
var self__ = this;
var _74369__$1 = this;
return self__.meta74368;
}));

(com.rpl.specter.t_com$rpl$specter74367.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74367.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
return next_fn(cljs.core.namespace(structure));
}));

(com.rpl.specter.t_com$rpl$specter74367.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39134__auto__,vals__39135__auto__,structure,next_fn__39136__auto__){
var self__ = this;
var this__39134__auto____$1 = this;
var next_fn = (function (s__39137__auto__){
return (next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39136__auto__.cljs$core$IFn$_invoke$arity$2(vals__39135__auto__,s__39137__auto__) : next_fn__39136__auto__.call(null,vals__39135__auto__,s__39137__auto__));
});
var name = cljs.core.name(structure);
var new_ns = next_fn(cljs.core.namespace(structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter74367.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74368","meta74368",-874694976,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74367.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74367.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74367");

(com.rpl.specter.t_com$rpl$specter74367.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74367");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74367.
 */
com.rpl.specter.__GT_t_com$rpl$specter74367 = (function com$rpl$specter$__GT_t_com$rpl$specter74367(meta74368){
return (new com.rpl.specter.t_com$rpl$specter74367(meta74368));
});

}

return (new com.rpl.specter.t_com$rpl$specter74367(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74474__delegate = function (path){
var builder__39921__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74370 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74370 = (function (path,late,meta74371){
this.path = path;
this.late = late;
this.meta74371 = meta74371;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74370.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74372,meta74371__$1){
var self__ = this;
var _74372__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74370(self__.path,self__.late,meta74371__$1));
}));

(com.rpl.specter.t_com$rpl$specter74370.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74372){
var self__ = this;
var _74372__$1 = this;
return self__.meta74371;
}));

(com.rpl.specter.t_com$rpl$specter74370.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74370.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39918__auto__,vals__39919__auto__,structure,next_fn__39920__auto__){
var self__ = this;
var this__39918__auto____$1 = this;
var G__74373 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39919__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__74374 = structure;
return (next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2(G__74373,G__74374) : next_fn__39920__auto__.call(null,G__74373,G__74374));
}));

(com.rpl.specter.t_com$rpl$specter74370.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39918__auto__,vals__39919__auto__,structure,next_fn__39920__auto__){
var self__ = this;
var this__39918__auto____$1 = this;
var G__74375 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39919__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__74376 = structure;
return (next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2(G__74375,G__74376) : next_fn__39920__auto__.call(null,G__74375,G__74376));
}));

(com.rpl.specter.t_com$rpl$specter74370.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta74371","meta74371",-193557271,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74370.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74370.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74370");

(com.rpl.specter.t_com$rpl$specter74370.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74370");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74370.
 */
com.rpl.specter.__GT_t_com$rpl$specter74370 = (function com$rpl$specter$__GT_t_com$rpl$specter74370(path__$1,late__$1,meta74371){
return (new com.rpl.specter.t_com$rpl$specter74370(path__$1,late__$1,meta74371));
});

}

return (new com.rpl.specter.t_com$rpl$specter74370(path,late,null));
}));
var curr_params__39922__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39922__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39921__auto__,curr_params__39922__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39921__auto__,curr_params__39922__auto__,null);
}
};
var G__74474 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__74475__i = 0, G__74475__a = new Array(arguments.length -  0);
while (G__74475__i < G__74475__a.length) {G__74475__a[G__74475__i] = arguments[G__74475__i + 0]; ++G__74475__i;}
  path = new cljs.core.IndexedSeq(G__74475__a,0,null);
} 
return G__74474__delegate.call(this,path);};
G__74474.cljs$lang$maxFixedArity = 0;
G__74474.cljs$lang$applyTo = (function (arglist__74476){
var path = cljs.core.seq(arglist__74476);
return G__74474__delegate(path);
});
G__74474.cljs$core$IFn$_invoke$arity$variadic = G__74474__delegate;
return G__74474;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74477__delegate = function (path){
var builder__39921__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74377 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74377 = (function (path,late,meta74378){
this.path = path;
this.late = late;
this.meta74378 = meta74378;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74377.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74379,meta74378__$1){
var self__ = this;
var _74379__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74377(self__.path,self__.late,meta74378__$1));
}));

(com.rpl.specter.t_com$rpl$specter74377.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74379){
var self__ = this;
var _74379__$1 = this;
return self__.meta74378;
}));

(com.rpl.specter.t_com$rpl$specter74377.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74377.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39918__auto__,vals__39919__auto__,structure,next_fn__39920__auto__){
var self__ = this;
var this__39918__auto____$1 = this;
var G__74380 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39919__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__74381 = structure;
return (next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2(G__74380,G__74381) : next_fn__39920__auto__.call(null,G__74380,G__74381));
}));

(com.rpl.specter.t_com$rpl$specter74377.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39918__auto__,vals__39919__auto__,structure,next_fn__39920__auto__){
var self__ = this;
var this__39918__auto____$1 = this;
var G__74382 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39919__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__74383 = structure;
return (next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2(G__74382,G__74383) : next_fn__39920__auto__.call(null,G__74382,G__74383));
}));

(com.rpl.specter.t_com$rpl$specter74377.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta74378","meta74378",-1842125070,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74377.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74377.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74377");

(com.rpl.specter.t_com$rpl$specter74377.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74377");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74377.
 */
com.rpl.specter.__GT_t_com$rpl$specter74377 = (function com$rpl$specter$__GT_t_com$rpl$specter74377(path__$1,late__$1,meta74378){
return (new com.rpl.specter.t_com$rpl$specter74377(path__$1,late__$1,meta74378));
});

}

return (new com.rpl.specter.t_com$rpl$specter74377(path,late,null));
}));
var curr_params__39922__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39922__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39921__auto__,curr_params__39922__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39921__auto__,curr_params__39922__auto__,null);
}
};
var G__74477 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__74478__i = 0, G__74478__a = new Array(arguments.length -  0);
while (G__74478__i < G__74478__a.length) {G__74478__a[G__74478__i] = arguments[G__74478__i + 0]; ++G__74478__i;}
  path = new cljs.core.IndexedSeq(G__74478__a,0,null);
} 
return G__74477__delegate.call(this,path);};
G__74477.cljs$lang$maxFixedArity = 0;
G__74477.cljs$lang$applyTo = (function (arglist__74479){
var path = cljs.core.seq(arglist__74479);
return G__74477__delegate(path);
});
G__74477.cljs$core$IFn$_invoke$arity$variadic = G__74477__delegate;
return G__74477;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj((function (val){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74384 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74384 = (function (val,meta74385){
this.val = val;
this.meta74385 = meta74385;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74384.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74386,meta74385__$1){
var self__ = this;
var _74386__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74384(self__.val,meta74385__$1));
}));

(com.rpl.specter.t_com$rpl$specter74384.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74386){
var self__ = this;
var _74386__$1 = this;
return self__.meta74385;
}));

(com.rpl.specter.t_com$rpl$specter74384.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74384.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__39918__auto__,vals__39919__auto__,structure,next_fn__39920__auto__){
var self__ = this;
var this__39918__auto____$1 = this;
var G__74387 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39919__auto__,self__.val);
var G__74388 = structure;
return (next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2(G__74387,G__74388) : next_fn__39920__auto__.call(null,G__74387,G__74388));
}));

(com.rpl.specter.t_com$rpl$specter74384.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__39918__auto__,vals__39919__auto__,structure,next_fn__39920__auto__){
var self__ = this;
var this__39918__auto____$1 = this;
var G__74389 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__39919__auto__,self__.val);
var G__74390 = structure;
return (next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__39920__auto__.cljs$core$IFn$_invoke$arity$2(G__74389,G__74390) : next_fn__39920__auto__.call(null,G__74389,G__74390));
}));

(com.rpl.specter.t_com$rpl$specter74384.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta74385","meta74385",910960850,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74384.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74384.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74384");

(com.rpl.specter.t_com$rpl$specter74384.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74384");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74384.
 */
com.rpl.specter.__GT_t_com$rpl$specter74384 = (function com$rpl$specter$__GT_t_com$rpl$specter74384(val__$1,meta74385){
return (new com.rpl.specter.t_com$rpl$specter74384(val__$1,meta74385));
});

}

return (new com.rpl.specter.t_com$rpl$specter74384(val,null));
}));
/**
 * Continues navigating on the given path with the collected vals reset to []. Once
 *   navigation leaves the scope of with-fresh-collected, the collected vals revert
 *   to what they were before.
 */
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74480__delegate = function (path){
var builder__39921__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74391 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74391 = (function (path,late,meta74392){
this.path = path;
this.late = late;
this.meta74392 = meta74392;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74391.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74393,meta74392__$1){
var self__ = this;
var _74393__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74391(self__.path,self__.late,meta74392__$1));
}));

(com.rpl.specter.t_com$rpl$specter74391.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74393){
var self__ = this;
var _74393__$1 = this;
return self__.meta74392;
}));

(com.rpl.specter.t_com$rpl$specter74391.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74391.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter74391.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter74391.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta74392","meta74392",-1021229271,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74391.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74391.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74391");

(com.rpl.specter.t_com$rpl$specter74391.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74391");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74391.
 */
com.rpl.specter.__GT_t_com$rpl$specter74391 = (function com$rpl$specter$__GT_t_com$rpl$specter74391(path__$1,late__$1,meta74392){
return (new com.rpl.specter.t_com$rpl$specter74391(path__$1,late__$1,meta74392));
});

}

return (new com.rpl.specter.t_com$rpl$specter74391(path,late,null));
}));
var curr_params__39922__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39922__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39921__auto__,curr_params__39922__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39921__auto__,curr_params__39922__auto__,null);
}
};
var G__74480 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__74481__i = 0, G__74481__a = new Array(arguments.length -  0);
while (G__74481__i < G__74481__a.length) {G__74481__a[G__74481__i] = arguments[G__74481__i + 0]; ++G__74481__i;}
  path = new cljs.core.IndexedSeq(G__74481__a,0,null);
} 
return G__74480__delegate.call(this,path);};
G__74480.cljs$lang$maxFixedArity = 0;
G__74480.cljs$lang$applyTo = (function (arglist__74482){
var path = cljs.core.seq(arglist__74482);
return G__74480__delegate(path);
});
G__74480.cljs$core$IFn$_invoke$arity$variadic = G__74480__delegate;
return G__74480;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74396 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74396 = (function (meta74397){
this.meta74397 = meta74397;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74396.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74398,meta74397__$1){
var self__ = this;
var _74398__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74396(meta74397__$1));
}));

(com.rpl.specter.t_com$rpl$specter74396.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74398){
var self__ = this;
var _74398__$1 = this;
return self__.meta74397;
}));

(com.rpl.specter.t_com$rpl$specter74396.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74396.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__74400 = cljs.core.PersistentVector.EMPTY;
var G__74401 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__74400,G__74401) : next_fn.call(null,G__74400,G__74401));
}));

(com.rpl.specter.t_com$rpl$specter74396.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__74402 = cljs.core.PersistentVector.EMPTY;
var G__74403 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__74402,G__74403) : next_fn.call(null,G__74402,G__74403));
}));

(com.rpl.specter.t_com$rpl$specter74396.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta74397","meta74397",-1721330656,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74396.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74396.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74396");

(com.rpl.specter.t_com$rpl$specter74396.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74396");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74396.
 */
com.rpl.specter.__GT_t_com$rpl$specter74396 = (function com$rpl$specter$__GT_t_com$rpl$specter74396(meta74397){
return (new com.rpl.specter.t_com$rpl$specter74396(meta74397));
});

}

return (new com.rpl.specter.t_com$rpl$specter74396(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__74483 = null;
var G__74483__2 = (function (cond_p,then_path){
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(cond_p,then_path,com.rpl.specter.STOP) : com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP));
});
var G__74483__3 = (function (cond_p,then_path,else_path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(cond_p);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
var builder__39921__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74406 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74406 = (function (cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,meta74407){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta74407 = meta74407;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74406.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74408,meta74407__$1){
var self__ = this;
var _74408__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74406(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.afn,self__.late_then,self__.late_else,meta74407__$1));
}));

(com.rpl.specter.t_com$rpl$specter74406.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74408){
var self__ = this;
var _74408__$1 = this;
return self__.meta74407;
}));

(com.rpl.specter.t_com$rpl$specter74406.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74406.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter74406.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter74406.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta74407","meta74407",-92681872,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74406.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74406.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74406");

(com.rpl.specter.t_com$rpl$specter74406.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74406");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74406.
 */
com.rpl.specter.__GT_t_com$rpl$specter74406 = (function com$rpl$specter$__GT_t_com$rpl$specter74406(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta74407){
return (new com.rpl.specter.t_com$rpl$specter74406(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta74407));
});

}

return (new com.rpl.specter.t_com$rpl$specter74406(cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,null));
}));
var curr_params__39922__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39922__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39921__auto__,curr_params__39922__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39921__auto__,curr_params__39922__auto__,null);
}
} else {
var builder__39921__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_cond,late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74409 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74409 = (function (cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,meta74410){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta74410 = meta74410;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74409.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74411,meta74410__$1){
var self__ = this;
var _74411__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74409(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.late_cond,self__.late_then,self__.late_else,meta74410__$1));
}));

(com.rpl.specter.t_com$rpl$specter74409.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74411){
var self__ = this;
var _74411__$1 = this;
return self__.meta74410;
}));

(com.rpl.specter.t_com$rpl$specter74409.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74409.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,(function (p1__74404_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__74404_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter74409.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,(function (p1__74405_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__74405_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter74409.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta74410","meta74410",584270440,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74409.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74409.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74409");

(com.rpl.specter.t_com$rpl$specter74409.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74409");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74409.
 */
com.rpl.specter.__GT_t_com$rpl$specter74409 = (function com$rpl$specter$__GT_t_com$rpl$specter74409(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta74410){
return (new com.rpl.specter.t_com$rpl$specter74409(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta74410));
});

}

return (new com.rpl.specter.t_com$rpl$specter74409(cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,null));
}));
var curr_params__39922__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(cond_p) : com.rpl.specter.late_path.call(null,cond_p)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39922__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39921__auto__,curr_params__39922__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39921__auto__,curr_params__39922__auto__,null);
}
}
});
G__74483 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__74483__2.call(this,cond_p,then_path);
case 3:
return G__74483__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__74483.cljs$core$IFn$_invoke$arity$2 = G__74483__2;
G__74483.cljs$core$IFn$_invoke$arity$3 = G__74483__3;
return G__74483;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74484__delegate = function (conds){
var pairs = cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),conds));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p,p__74412){
var vec__74413 = p__74412;
var tester = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74413,(0),null);
var apath = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74413,(1),null);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(tester,apath,p) : com.rpl.specter.if_path.call(null,tester,apath,p));
}),com.rpl.specter.STOP,pairs);
};
var G__74484 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__74485__i = 0, G__74485__a = new Array(arguments.length -  0);
while (G__74485__i < G__74485__a.length) {G__74485__a[G__74485__i] = arguments[G__74485__i + 0]; ++G__74485__i;}
  conds = new cljs.core.IndexedSeq(G__74485__a,0,null);
} 
return G__74484__delegate.call(this,conds);};
G__74484.cljs$lang$maxFixedArity = 0;
G__74484.cljs$lang$applyTo = (function (arglist__74486){
var conds = cljs.core.seq(arglist__74486);
return G__74484__delegate(conds);
});
G__74484.cljs$core$IFn$_invoke$arity$variadic = G__74484__delegate;
return G__74484;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__74487 = null;
var G__74487__0 = (function (){
return com.rpl.specter.STAY;
});
var G__74487__1 = (function (path){
return path;
});
var G__74487__2 = (function (path1,path2){
var builder__39921__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late1,late2){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter74416 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter74416 = (function (path1,path2,late1,late2,meta74417){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta74417 = meta74417;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter74416.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_74418,meta74417__$1){
var self__ = this;
var _74418__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter74416(self__.path1,self__.path2,self__.late1,self__.late2,meta74417__$1));
}));

(com.rpl.specter.t_com$rpl$specter74416.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_74418){
var self__ = this;
var _74418__$1 = this;
return self__.meta74417;
}));

(com.rpl.specter.t_com$rpl$specter74416.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter74416.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_(self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_(res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_(self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
}));

(com.rpl.specter.t_com$rpl$specter74416.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_(self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_(self__.late2,vals,s1,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter74416.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta74417","meta74417",-759229353,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter74416.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter74416.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter74416");

(com.rpl.specter.t_com$rpl$specter74416.cljs$lang$ctorPrWriter = (function (this__4363__auto__,writer__4364__auto__,opt__4365__auto__){
return cljs.core._write(writer__4364__auto__,"com.rpl.specter/t_com$rpl$specter74416");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter74416.
 */
com.rpl.specter.__GT_t_com$rpl$specter74416 = (function com$rpl$specter$__GT_t_com$rpl$specter74416(path1__$1,path2__$1,late1__$1,late2__$1,meta74417){
return (new com.rpl.specter.t_com$rpl$specter74416(path1__$1,path2__$1,late1__$1,late2__$1,meta74417));
});

}

return (new com.rpl.specter.t_com$rpl$specter74416(path1,path2,late1,late2,null));
}));
var curr_params__39922__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path1) : com.rpl.specter.late_path.call(null,path1)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path2) : com.rpl.specter.late_path.call(null,path2))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__39922__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__39921__auto__,curr_params__39922__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__39921__auto__,curr_params__39922__auto__,null);
}
});
var G__74487__3 = (function() { 
var G__74488__delegate = function (path1,path2,paths){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(com.rpl.specter.multi_path,(com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path1,path2) : com.rpl.specter.multi_path.call(null,path1,path2)),paths);
};
var G__74488 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__74489__i = 0, G__74489__a = new Array(arguments.length -  2);
while (G__74489__i < G__74489__a.length) {G__74489__a[G__74489__i] = arguments[G__74489__i + 2]; ++G__74489__i;}
  paths = new cljs.core.IndexedSeq(G__74489__a,0,null);
} 
return G__74488__delegate.call(this,path1,path2,paths);};
G__74488.cljs$lang$maxFixedArity = 2;
G__74488.cljs$lang$applyTo = (function (arglist__74490){
var path1 = cljs.core.first(arglist__74490);
arglist__74490 = cljs.core.next(arglist__74490);
var path2 = cljs.core.first(arglist__74490);
var paths = cljs.core.rest(arglist__74490);
return G__74488__delegate(path1,path2,paths);
});
G__74488.cljs$core$IFn$_invoke$arity$variadic = G__74488__delegate;
return G__74488;
})()
;
G__74487 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__74487__0.call(this);
case 1:
return G__74487__1.call(this,path1);
case 2:
return G__74487__2.call(this,path1,path2);
default:
var G__74491 = null;
if (arguments.length > 2) {
var G__74492__i = 0, G__74492__a = new Array(arguments.length -  2);
while (G__74492__i < G__74492__a.length) {G__74492__a[G__74492__i] = arguments[G__74492__i + 2]; ++G__74492__i;}
G__74491 = new cljs.core.IndexedSeq(G__74492__a,0,null);
}
return G__74487__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__74491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__74487.cljs$lang$maxFixedArity = 2;
G__74487.cljs$lang$applyTo = G__74487__3.cljs$lang$applyTo;
G__74487.cljs$core$IFn$_invoke$arity$0 = G__74487__0;
G__74487.cljs$core$IFn$_invoke$arity$1 = G__74487__1;
G__74487.cljs$core$IFn$_invoke$arity$2 = G__74487__2;
G__74487.cljs$core$IFn$_invoke$arity$variadic = G__74487__3.cljs$core$IFn$_invoke$arity$variadic;
return G__74487;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74493__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.STAY,path) : com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path));
};
var G__74493 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__74494__i = 0, G__74494__a = new Array(arguments.length -  0);
while (G__74494__i < G__74494__a.length) {G__74494__a[G__74494__i] = arguments[G__74494__i + 0]; ++G__74494__i;}
  path = new cljs.core.IndexedSeq(G__74494__a,0,null);
} 
return G__74493__delegate.call(this,path);};
G__74493.cljs$lang$maxFixedArity = 0;
G__74493.cljs$lang$applyTo = (function (arglist__74495){
var path = cljs.core.seq(arglist__74495);
return G__74493__delegate(path);
});
G__74493.cljs$core$IFn$_invoke$arity$variadic = G__74493__delegate;
return G__74493;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74496__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path,com.rpl.specter.STAY) : com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY));
};
var G__74496 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__74497__i = 0, G__74497__a = new Array(arguments.length -  0);
while (G__74497__i < G__74497__a.length) {G__74497__a[G__74497__i] = arguments[G__74497__i + 0]; ++G__74497__i;}
  path = new cljs.core.IndexedSeq(G__74497__a,0,null);
} 
return G__74496__delegate.call(this,path);};
G__74496.cljs$lang$maxFixedArity = 0;
G__74496.cljs$lang$applyTo = (function (arglist__74498){
var path = cljs.core.seq(arglist__74498);
return G__74496__delegate(path);
});
G__74496.cljs$core$IFn$_invoke$arity$variadic = G__74496__delegate;
return G__74496;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__39928__auto__ = com.rpl.specter.pathcache74423;
var info__39928__auto____$1 = (((info__39928__auto__ == null))?(function (){var info74424 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,679,682,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache74423 = info74424;

return info74424;
})():info__39928__auto__);
var precompiled74425 = com.rpl.specter.impl.cached_path_info_precompiled(info__39928__auto____$1);
var dynamic_QMARK___39929__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39928__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39929__auto__)){
var G__74426 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null);
return (precompiled74425.cljs$core$IFn$_invoke$arity$1 ? precompiled74425.cljs$core$IFn$_invoke$arity$1(G__74426) : precompiled74425.call(null,G__74426));
} else {
return precompiled74425;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__39928__auto__ = com.rpl.specter.pathcache74427;
var info__39928__auto____$1 = (((info__39928__auto__ == null))?(function (){var info74428 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"com/rpl/specter.cljc",25,1,1394,1394,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1175,1179,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,644,646,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"com/rpl/specter.cljc",16,1,689,691,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache74427 = info74428;

return info74428;
})():info__39928__auto__);
var precompiled74429 = com.rpl.specter.impl.cached_path_info_precompiled(info__39928__auto____$1);
var dynamic_QMARK___39929__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__39928__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___39929__auto__)){
var G__74430 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null);
return (precompiled74429.cljs$core$IFn$_invoke$arity$1 ? precompiled74429.cljs$core$IFn$_invoke$arity$1(G__74430) : precompiled74429.call(null,G__74430));
} else {
return precompiled74429;
}
})());

return p;
}));
var empty__GT_NONE_74499 = (function (){var G__74431 = cljs.core.empty_QMARK_;
var G__74432 = com.rpl.specter.terminal_val(com.rpl.specter.NONE);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2(G__74431,G__74432) : com.rpl.specter.if_path.call(null,G__74431,G__74432));
})();
var compact_STAR__74500 = (function (nav){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(nav,empty__GT_NONE_74499) : com.rpl.specter.multi_path.call(null,nav,empty__GT_NONE_74499));
});
/**
 * During transforms, after each step of navigation in subpath check if the
 *  value is empty. If so, remove that value by setting it to NONE.
 */
com.rpl.specter.compact = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__74501__delegate = function (path){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(compact_STAR__74500,path);
};
var G__74501 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__74502__i = 0, G__74502__a = new Array(arguments.length -  0);
while (G__74502__i < G__74502__a.length) {G__74502__a[G__74502__i] = arguments[G__74502__i + 0]; ++G__74502__i;}
  path = new cljs.core.IndexedSeq(G__74502__a,0,null);
} 
return G__74501__delegate.call(this,path);};
G__74501.cljs$lang$maxFixedArity = 0;
G__74501.cljs$lang$applyTo = (function (arglist__74503){
var path = cljs.core.seq(arglist__74503);
return G__74501__delegate(path);
});
G__74501.cljs$core$IFn$_invoke$arity$variadic = G__74501__delegate;
return G__74501;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);

//# sourceMappingURL=com.rpl.specter.js.map
