goog.provide('chord.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('chord.channels');
goog.require('chord.format');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e75000){var e = e75000;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4736__auto__ = [];
var len__4730__auto___75116 = arguments.length;
var i__4731__auto___75117 = (0);
while(true){
if((i__4731__auto___75117 < len__4730__auto___75116)){
args__4736__auto__.push((arguments[i__4731__auto___75117]));

var G__75118 = (i__4731__auto___75117 + (1));
i__4731__auto___75117 = G__75118;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__75005){
var vec__75006 = p__75005;
var map__75009 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75006,(0),null);
var map__75009__$1 = (((((!((map__75009 == null))))?(((((map__75009.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75009.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75009):map__75009);
var opts = map__75009__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75009__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75009__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75009__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75009__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__75011 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4120__auto__ = read_ch;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4120__auto__ = write_ch;
if(cljs.core.truth_(or__4120__auto__)){
return or__4120__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__75011__$1 = (((((!((map__75011 == null))))?(((((map__75011.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75011.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75011):map__75011);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75011__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75011__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__75001_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__75001_SHARP_);
}));

(web_socket.onclose = (function (p1__75002_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__75002_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__70370__auto___75119 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__70371__auto__ = (function (){var switch__70334__auto__ = (function (state_75080){
var state_val_75081 = (state_75080[(1)]);
if((state_val_75081 === (7))){
var inst_75076 = (state_75080[(2)]);
var state_75080__$1 = state_75080;
var statearr_75082_75120 = state_75080__$1;
(statearr_75082_75120[(2)] = inst_75076);

(statearr_75082_75120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (20))){
var state_75080__$1 = state_75080;
var statearr_75083_75121 = state_75080__$1;
(statearr_75083_75121[(2)] = null);

(statearr_75083_75121[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (1))){
var inst_75013 = false;
var state_75080__$1 = (function (){var statearr_75084 = state_75080;
(statearr_75084[(7)] = inst_75013);

return statearr_75084;
})();
var statearr_75085_75122 = state_75080__$1;
(statearr_75085_75122[(2)] = null);

(statearr_75085_75122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (4))){
var inst_75028 = (state_75080[(8)]);
var inst_75030 = (state_75080[(9)]);
var inst_75022 = (state_75080[(10)]);
var inst_75028__$1 = (state_75080[(2)]);
var inst_75029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75028__$1,(0),null);
var inst_75030__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75028__$1,(1),null);
var inst_75031 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75030__$1,inst_75022);
var state_75080__$1 = (function (){var statearr_75086 = state_75080;
(statearr_75086[(8)] = inst_75028__$1);

(statearr_75086[(9)] = inst_75030__$1);

(statearr_75086[(11)] = inst_75029);

return statearr_75086;
})();
if(inst_75031){
var statearr_75087_75125 = state_75080__$1;
(statearr_75087_75125[(1)] = (5));

} else {
var statearr_75088_75129 = state_75080__$1;
(statearr_75088_75129[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (15))){
var inst_75061 = (state_75080[(2)]);
var state_75080__$1 = state_75080;
var statearr_75089_75195 = state_75080__$1;
(statearr_75089_75195[(2)] = inst_75061);

(statearr_75089_75195[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (21))){
var inst_75072 = (state_75080[(2)]);
var state_75080__$1 = state_75080;
var statearr_75090_75196 = state_75080__$1;
(statearr_75090_75196[(2)] = inst_75072);

(statearr_75090_75196[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (13))){
var state_75080__$1 = state_75080;
var statearr_75091_75198 = state_75080__$1;
(statearr_75091_75198[(2)] = null);

(statearr_75091_75198[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (6))){
var inst_75030 = (state_75080[(9)]);
var inst_75023 = (state_75080[(12)]);
var inst_75045 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75030,inst_75023);
var state_75080__$1 = state_75080;
if(inst_75045){
var statearr_75092_75201 = state_75080__$1;
(statearr_75092_75201[(1)] = (9));

} else {
var statearr_75093_75203 = state_75080__$1;
(statearr_75093_75203[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (17))){
var state_75080__$1 = state_75080;
var statearr_75094_75204 = state_75080__$1;
(statearr_75094_75204[(2)] = initial_ch);

(statearr_75094_75204[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (3))){
var inst_75078 = (state_75080[(2)]);
var state_75080__$1 = state_75080;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75080__$1,inst_75078);
} else {
if((state_val_75081 === (12))){
var inst_75013 = (state_75080[(7)]);
var state_75080__$1 = state_75080;
if(cljs.core.truth_(inst_75013)){
var statearr_75095_75205 = state_75080__$1;
(statearr_75095_75205[(1)] = (16));

} else {
var statearr_75096_75207 = state_75080__$1;
(statearr_75096_75207[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (2))){
var inst_75023 = (state_75080[(12)]);
var inst_75022 = (state_75080[(10)]);
var inst_75022__$1 = open_ch;
var inst_75023__$1 = close_ch;
var inst_75024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75025 = [inst_75022__$1,inst_75023__$1];
var inst_75026 = (new cljs.core.PersistentVector(null,2,(5),inst_75024,inst_75025,null));
var state_75080__$1 = (function (){var statearr_75097 = state_75080;
(statearr_75097[(12)] = inst_75023__$1);

(statearr_75097[(10)] = inst_75022__$1);

return statearr_75097;
})();
return cljs.core.async.ioc_alts_BANG_(state_75080__$1,(4),inst_75026);
} else {
if((state_val_75081 === (19))){
var inst_75029 = (state_75080[(11)]);
var state_75080__$1 = state_75080;
var statearr_75098_75211 = state_75080__$1;
(statearr_75098_75211[(2)] = inst_75029);

(statearr_75098_75211[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (11))){
var inst_75074 = (state_75080[(2)]);
var state_75080__$1 = state_75080;
var statearr_75099_75217 = state_75080__$1;
(statearr_75099_75217[(2)] = inst_75074);

(statearr_75099_75217[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (9))){
var inst_75028 = (state_75080[(8)]);
var inst_75051 = (state_75080[(13)]);
var inst_75050 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75028,(0),null);
var inst_75051__$1 = chord.client.close_event__GT_maybe_error(inst_75050);
var state_75080__$1 = (function (){var statearr_75100 = state_75080;
(statearr_75100[(13)] = inst_75051__$1);

return statearr_75100;
})();
if(cljs.core.truth_(inst_75051__$1)){
var statearr_75101_75220 = state_75080__$1;
(statearr_75101_75220[(1)] = (12));

} else {
var statearr_75102_75221 = state_75080__$1;
(statearr_75102_75221[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (5))){
var inst_75028 = (state_75080[(8)]);
var inst_75036 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75028,(0),null);
var inst_75037 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_75038 = [ws_chan];
var inst_75039 = cljs.core.PersistentHashMap.fromArrays(inst_75037,inst_75038);
var state_75080__$1 = (function (){var statearr_75103 = state_75080;
(statearr_75103[(14)] = inst_75036);

return statearr_75103;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_75080__$1,(8),initial_ch,inst_75039);
} else {
if((state_val_75081 === (14))){
var inst_75064 = (state_75080[(2)]);
var inst_75065 = cljs.core.async.close_BANG_(ws_chan);
var inst_75066 = cljs.core.async.close_BANG_(initial_ch);
var state_75080__$1 = (function (){var statearr_75104 = state_75080;
(statearr_75104[(15)] = inst_75065);

(statearr_75104[(16)] = inst_75064);

return statearr_75104;
})();
var statearr_75105_75225 = state_75080__$1;
(statearr_75105_75225[(2)] = inst_75066);

(statearr_75105_75225[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (16))){
var state_75080__$1 = state_75080;
var statearr_75106_75226 = state_75080__$1;
(statearr_75106_75226[(2)] = read_ch__$1);

(statearr_75106_75226[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (10))){
var inst_75030 = (state_75080[(9)]);
var inst_75068 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75030,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_75080__$1 = state_75080;
if(inst_75068){
var statearr_75107_75228 = state_75080__$1;
(statearr_75107_75228[(1)] = (19));

} else {
var statearr_75108_75230 = state_75080__$1;
(statearr_75108_75230[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75081 === (18))){
var inst_75051 = (state_75080[(13)]);
var inst_75056 = (state_75080[(2)]);
var inst_75057 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75058 = [inst_75051];
var inst_75059 = cljs.core.PersistentHashMap.fromArrays(inst_75057,inst_75058);
var state_75080__$1 = state_75080;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_75080__$1,(15),inst_75056,inst_75059);
} else {
if((state_val_75081 === (8))){
var inst_75041 = (state_75080[(2)]);
var inst_75042 = cljs.core.async.close_BANG_(initial_ch);
var inst_75013 = true;
var state_75080__$1 = (function (){var statearr_75109 = state_75080;
(statearr_75109[(17)] = inst_75041);

(statearr_75109[(7)] = inst_75013);

(statearr_75109[(18)] = inst_75042);

return statearr_75109;
})();
var statearr_75110_75235 = state_75080__$1;
(statearr_75110_75235[(2)] = null);

(statearr_75110_75235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__70335__auto__ = null;
var chord$client$state_machine__70335__auto____0 = (function (){
var statearr_75111 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75111[(0)] = chord$client$state_machine__70335__auto__);

(statearr_75111[(1)] = (1));

return statearr_75111;
});
var chord$client$state_machine__70335__auto____1 = (function (state_75080){
while(true){
var ret_value__70336__auto__ = (function (){try{while(true){
var result__70337__auto__ = switch__70334__auto__(state_75080);
if(cljs.core.keyword_identical_QMARK_(result__70337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70337__auto__;
}
break;
}
}catch (e75112){var ex__70338__auto__ = e75112;
var statearr_75113_75239 = state_75080;
(statearr_75113_75239[(2)] = ex__70338__auto__);


if(cljs.core.seq((state_75080[(4)]))){
var statearr_75114_75240 = state_75080;
(statearr_75114_75240[(1)] = cljs.core.first((state_75080[(4)])));

} else {
throw ex__70338__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__70336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75242 = state_75080;
state_75080 = G__75242;
continue;
} else {
return ret_value__70336__auto__;
}
break;
}
});
chord$client$state_machine__70335__auto__ = function(state_75080){
switch(arguments.length){
case 0:
return chord$client$state_machine__70335__auto____0.call(this);
case 1:
return chord$client$state_machine__70335__auto____1.call(this,state_75080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__70335__auto____0;
chord$client$state_machine__70335__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__70335__auto____1;
return chord$client$state_machine__70335__auto__;
})()
})();
var state__70372__auto__ = (function (){var statearr_75115 = f__70371__auto__();
(statearr_75115[(6)] = c__70370__auto___75119);

return statearr_75115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__70372__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq75003){
var G__75004 = cljs.core.first(seq75003);
var seq75003__$1 = cljs.core.next(seq75003);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__75004,seq75003__$1);
}));


//# sourceMappingURL=chord.client.js.map
