(ns pinkgorilla.notebook.views.explorer
  (:require
   [taoensso.timbre :as timbre :refer [info]]
   [webly.web.handler :refer [reagent-page]]
   [webly.web.routes :refer [query-params]]
   [pinkgorilla.explore.component :refer [notebook-explorer]]
   [pinkgorilla.document.component :refer [document-page]]
   [pinkgorilla.explorer.bidi :refer [goto-notebook!]]
   [pinkgorilla.notebook-ui.notebook.component :refer [notebook-viewer]])) ; side-effects

;; NOTEBOOK

(defn document-viewer [storage document]
  [:div.m-3.bg-blue-300
   [:link {:rel "stylesheet" :href "/r/codemirror/lib/codemirror.css"}]
   [:link {:rel "stylesheet" :href "/r/notebook-ui/datatypes.css"}]
   ;[:a {:on-click #(goto! :ui/explorer)} "explorer"]
   [notebook-viewer storage @document]])

(defmethod reagent-page :ui/notebook [& args]
  [document-page @query-params document-viewer])

;; EXPLORER

(defn open-notebook [nb]
  (info "load-notebook-click" nb)
  (goto-notebook! (:storage nb)))

(defmethod reagent-page :ui/explorer [& args]
  [notebook-explorer open-notebook])
