(ns pinkgorilla.notebook.views.about
  (:require
   [re-frame.core :refer [dispatch]]
   [webly.web.handler :refer [reagent-page]]
   [webly.web.routes :refer [goto!]]))

(defn credit [user txt]
  [:li
   [:span
    [:a.w-16 {:href (str "https://github.com/deas" user)}
     user
     txt]]])

(defn notebook-about []
  [:div.container
   [:h1.text-2xl.italic "Welcome to" [:span.text-blue-500.text-3xl.non-italic "PinkGorilla Notebook"]]

   ; Action
   [:div.bg-pink-300
    [:h1.text-2xl "Action"]
    [:div.flex.flex-column
     [:div.w-32.h-16.border.p-2.text-center.border-gray-500
      {:on-click #(goto! :ui/explorer)} "Explorer"]
     [:div.w-32.h-16.border.p-2.text-center.border-gray-500
      {:on-click  #(dispatch [:notebook/new])} "New Notebook"]
     [:div.w-32.h-16.border.p-2.text-center.border-gray-500
      [:a {:href "https://clojurians.zulipchat.com/#narrow/stream/212578-pink-gorilla-dev"} "Zulip Chat"]]]]

   ; Features


   [:div.bg-orange-300
    [:h1.text-2xl "Features"]
    [:ul
     [:li "Notebook with clj kernel"]
     [:li "Many visualization components"]]]

   [:div.bg-orange-300
    [:h1.text-2xl "Documentation"]]

   [:div.bg-green-300
    [:h1.text-2xl "Credits"]
    [:ul
     [credit "JonyEpsilon" "legacy gorilla-repl (with js frontend)"]
     [credit "deas" "port to re-frame, nrepl-relay, build-automation, unit-tests"]
     [credit "awb99" "gorilla-ui, goldly"]
     [credit "mauricioszabo" "goldly sci compiler, nrepl-tooling"]
     [credit "daslu" "notworking and testing, clojisr"]]]])

(defmethod reagent-page :notebook/about [& args]
  [notebook-about])