(ns pinkgorilla.notebook.routes
  (:require
   [webly.web.resources :refer [resource-handler]]
   [pinkgorilla.explorer.default-config :refer [explorer-routes-app explorer-routes-api]]))

(def notebook-routes-app
  (assoc explorer-routes-app
         "" :notebook/about))

(def notebook-routes-api
  (assoc explorer-routes-api
         "relay" :nrepl/relay)) ; relay really is an api-handler

(def notebook-routes-frontend
  ["/" notebook-routes-app])

(def notebook-routes-backend
  ["/" {"" notebook-routes-app
        "api" notebook-routes-api
        "nrepl" :nrepl/relay
        "r" resource-handler}])
