(ns pinkgorilla.notebook.app
  (:require
   [clojure.string :as str]
   [cemerick.url :as url]
   [taoensso.timbre :as timbre :refer [info]]
   [re-frame.core :refer [dispatch-sync]]
   [webly.web.app]
   [webly.config :refer [webly-config]]
   [pinkgorilla.explorer.default-config :refer [config-client]] ;; side-effects
   [pinkgorilla.notebook-ui.app.init :refer [notebook-init!]]
   [pinkgorilla.notebook.config :refer [notebook-config]]
   [pinkgorilla.notebook.routes :refer [notebook-routes-backend]]
   [pinkgorilla.notebook.views.explorer] ; side-effects
   [pinkgorilla.notebook.views.about] ; side-effects
   ))

;; common url convenience stolen from gorilla-notebook
(defn application-url []
  (url/url (-> js/window .-location .-href)))

(defn ws-origin [path app-url]
  (let [proto (if (= (:protocol app-url) "http") "ws" "wss")
        port-postfix  (let [port (:port app-url)]
                        (if (< 0 port)
                          (str ":" port)
                          ""))]
    (str proto ":" (:host app-url) port-postfix (str/replace (:path app-url) #"[^/]*$" path))))

(defn ^:export start []
  (swap! webly-config assoc :timbre-loglevel :debug)
  (info "pinkgorilla notebook app starting ..")
  (dispatch-sync [:explorer/init config-client])
  (notebook-init! notebook-config)
  (webly.web.app/start notebook-routes-backend)
  (webly.web.app/mount-app))