(ns pinkgorilla.notebook.app
  (:require
   [taoensso.timbre :as timbre :refer [info]]
   ;[webly.build :refer [build-cli]]
   [webly.config :refer [webly-config]]
   [webly.web.handler :refer [make-handler add-ring-handler]]
   [pinkgorilla.explorer.default-config :refer [config-server]] ; side effects
   [pinkgorilla.explorer.handler] ; side-effects   
   [pinkgorilla.explore.handler :refer [explore-directories-start]]
   [pinkgorilla.notebook.routes :refer [notebook-routes-backend notebook-routes-frontend]]
   [pinkgorilla.notebook.config :refer [notebook-config]]
   [ring.adapter.jetty9 :refer [run-jetty]]
   [pinkgorilla.nrepl.service.relay-jetty :refer [jetty-relay-handler #_run-relay-jetty]]
   [pinkgorilla.nrepl.service.nrepl-server :refer [run-nrepl-server]]))

(add-ring-handler :nrepl/relay jetty-relay-handler)

(info "making handler ..")
(def handler (make-handler notebook-routes-backend notebook-routes-frontend))

(defn run-jetty-server [config]
  (let [ws-handler (jetty-relay-handler)
        relay-config (:relay config)
        {:keys [port route]} relay-config]
    (info "Starting notebook web server at port" port " ..")
    (run-jetty handler {:port port
                        :websockets {route ws-handler}
                        :allow-null-path-info true
                           ;:join?  false        
                        })))

(defn start-notebook-server [config]
  (info "notebook-server starting..")
  (run-nrepl-server config)
  (run-jetty-server config))

(defn -main
  []
  (info "pinkgorilla notebook starting..")
  (swap! webly-config assoc :timbre-loglevel :debug)
  (swap! webly-config assoc :title "PinkGorilla Notebook")
  (swap! webly-config assoc :start "pinkgorilla.notebook.app.start (); ")

  (explore-directories-start config-server)
  (start-notebook-server notebook-config)

  ;(build-cli :watch "+dev" "demo.app/handler" "demo.app")
  )