(defproject org.pinkgorilla/lein-pinkgorilla "0.0.14"
  :description "A Leiningen plugin for the PinkGorilla Notebook."
  :url "https://github.com/pink-gorilla/lein-pinkgorilla"
  :license {:name "MIT"}
  :deploy-repositories [["releases" {:url "https://clojars.org/repo"
                                     :username :env/release_username
                                     :password :env/release_password
                                     :sign-releases false}]]
  :min-lein-version "2.9.1"
  :min-java-version "1.11"

  :release-tasks [["vcs" "assert-committed"]
                  ["bump-version" "release"]
                  ["vcs" "commit" "Release %s"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["deploy"]
                  ["bump-version"]
                  ["vcs" "commit" "Begin %s"]
                  ["vcs" "push"]]

  :eval-in-leiningen true

  :dependencies
  [[org.pinkgorilla/notebook-encoding "0.0.37"] ; encodig is more recent than in notebook
   [org.pinkgorilla/gorilla-notebook "0.4.17"
    :exclusions [org.pinkgorilla/notebook-encoding]]]

  :aliases {"bump-version"
            ["change" "version" "leiningen.release/bump-version"]})

