goog.provide('cljs.source_map');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__13292){
var vec__13293 = p__13292;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13293,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13293,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__13296 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13296,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__13299 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13299,(4),null);
var vec__13302 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13302,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13302,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13302,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13302,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13302,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4185__auto__ = col;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__13309 = segmap;
var map__13309__$1 = (((((!((map__13309 == null))))?(((((map__13309.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13309.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13309):map__13309);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13309__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13309__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13309__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13309__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13309__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__13312 = arguments.length;
switch (G__13312) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__13316 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__14221 = cljs.core.next(segs__$1);
var G__14222 = nrelseg;
var G__14223 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__14221;
relseg__$1 = G__14222;
result__$1 = G__14223;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13316,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13316,(1),null);
var G__14224 = (gline + (1));
var G__14225 = cljs.core.next(lines__$1);
var G__14226 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__14227 = result__$1;
gline = G__14224;
lines__$1 = G__14225;
relseg = G__14226;
result = G__14227;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__13320 = segmap;
var map__13320__$1 = (((((!((map__13320 == null))))?(((((map__13320.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13320.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13320):map__13320);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13320__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13320__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13320__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13320__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13320__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__13319_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__13319_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__13323 = arguments.length;
switch (G__13323) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__13327 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__14229 = cljs.core.next(segs__$1);
var G__14230 = nrelseg;
var G__14231 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__14229;
relseg__$1 = G__14230;
result__$1 = G__14231;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13327,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13327,(1),null);
var G__14232 = (gline + (1));
var G__14233 = cljs.core.next(lines__$1);
var G__14234 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__14235 = result__$1;
gline = G__14232;
lines__$1 = G__14233;
relseg = G__14234;
result = G__14235;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__13334){
var vec__13336 = p__13334;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13336,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13336,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13336,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13336,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13336,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__13341){
var vec__13342 = p__13341;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13342,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13342,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13342,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13342,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13342,(4),null);
var seg = vec__13342;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__13348){
var vec__13349 = p__13348;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13349,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13349,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13349,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13349,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13349,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__13376 = cljs.core.seq(infos);
var chunk__13377 = null;
var count__13378 = (0);
var i__13379 = (0);
while(true){
if((i__13379 < count__13378)){
var info = chunk__13377.cljs$core$IIndexed$_nth$arity$2(null,i__13379);
var segv_14245 = info__GT_segv(info,source_idx,line,col);
var gline_14246 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_14247 = cljs.core.count(cljs.core.deref(lines));
if((gline_14246 > (lc_14247 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13376,chunk__13377,count__13378,i__13379,segv_14245,gline_14246,lc_14247,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_14246 - (lc_14247 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_14245], null));
});})(seq__13376,chunk__13377,count__13378,i__13379,segv_14245,gline_14246,lc_14247,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13376,chunk__13377,count__13378,i__13379,segv_14245,gline_14246,lc_14247,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14246], null),cljs.core.conj,segv_14245);
});})(seq__13376,chunk__13377,count__13378,i__13379,segv_14245,gline_14246,lc_14247,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__14256 = seq__13376;
var G__14257 = chunk__13377;
var G__14258 = count__13378;
var G__14259 = (i__13379 + (1));
seq__13376 = G__14256;
chunk__13377 = G__14257;
count__13378 = G__14258;
i__13379 = G__14259;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__13376);
if(temp__5735__auto__){
var seq__13376__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__13376__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__13376__$1);
var G__14260 = cljs.core.chunk_rest(seq__13376__$1);
var G__14261 = c__4609__auto__;
var G__14262 = cljs.core.count(c__4609__auto__);
var G__14263 = (0);
seq__13376 = G__14260;
chunk__13377 = G__14261;
count__13378 = G__14262;
i__13379 = G__14263;
continue;
} else {
var info = cljs.core.first(seq__13376__$1);
var segv_14264 = info__GT_segv(info,source_idx,line,col);
var gline_14265 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_14266 = cljs.core.count(cljs.core.deref(lines));
if((gline_14265 > (lc_14266 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13376,chunk__13377,count__13378,i__13379,segv_14264,gline_14265,lc_14266,info,seq__13376__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_14265 - (lc_14266 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_14264], null));
});})(seq__13376,chunk__13377,count__13378,i__13379,segv_14264,gline_14265,lc_14266,info,seq__13376__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__13376,chunk__13377,count__13378,i__13379,segv_14264,gline_14265,lc_14266,info,seq__13376__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14265], null),cljs.core.conj,segv_14264);
});})(seq__13376,chunk__13377,count__13378,i__13379,segv_14264,gline_14265,lc_14266,info,seq__13376__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__14267 = cljs.core.next(seq__13376__$1);
var G__14268 = null;
var G__14269 = (0);
var G__14270 = (0);
seq__13376 = G__14267;
chunk__13377 = G__14268;
count__13378 = G__14269;
i__13379 = G__14270;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__13392_14271 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__13393_14272 = null;
var count__13394_14273 = (0);
var i__13395_14274 = (0);
while(true){
if((i__13395_14274 < count__13394_14273)){
var vec__13617_14275 = chunk__13393_14272.cljs$core$IIndexed$_nth$arity$2(null,i__13395_14274);
var source_idx_14276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13617_14275,(0),null);
var vec__13620_14277 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13617_14275,(1),null);
var __14278 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13620_14277,(0),null);
var lines_14279__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13620_14277,(1),null);
var seq__13623_14280 = cljs.core.seq(lines_14279__$1);
var chunk__13624_14281 = null;
var count__13625_14282 = (0);
var i__13626_14283 = (0);
while(true){
if((i__13626_14283 < count__13625_14282)){
var vec__13678_14284 = chunk__13624_14281.cljs$core$IIndexed$_nth$arity$2(null,i__13626_14283);
var line_14285 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13678_14284,(0),null);
var cols_14286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13678_14284,(1),null);
var seq__13681_14287 = cljs.core.seq(cols_14286);
var chunk__13682_14288 = null;
var count__13683_14289 = (0);
var i__13684_14290 = (0);
while(true){
if((i__13684_14290 < count__13683_14289)){
var vec__13691_14291 = chunk__13682_14288.cljs$core$IIndexed$_nth$arity$2(null,i__13684_14290);
var col_14292 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13691_14291,(0),null);
var infos_14293 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13691_14291,(1),null);
encode_cols(infos_14293,source_idx_14276,line_14285,col_14292);


var G__14294 = seq__13681_14287;
var G__14295 = chunk__13682_14288;
var G__14296 = count__13683_14289;
var G__14297 = (i__13684_14290 + (1));
seq__13681_14287 = G__14294;
chunk__13682_14288 = G__14295;
count__13683_14289 = G__14296;
i__13684_14290 = G__14297;
continue;
} else {
var temp__5735__auto___14298 = cljs.core.seq(seq__13681_14287);
if(temp__5735__auto___14298){
var seq__13681_14299__$1 = temp__5735__auto___14298;
if(cljs.core.chunked_seq_QMARK_(seq__13681_14299__$1)){
var c__4609__auto___14300 = cljs.core.chunk_first(seq__13681_14299__$1);
var G__14301 = cljs.core.chunk_rest(seq__13681_14299__$1);
var G__14302 = c__4609__auto___14300;
var G__14303 = cljs.core.count(c__4609__auto___14300);
var G__14304 = (0);
seq__13681_14287 = G__14301;
chunk__13682_14288 = G__14302;
count__13683_14289 = G__14303;
i__13684_14290 = G__14304;
continue;
} else {
var vec__13694_14305 = cljs.core.first(seq__13681_14299__$1);
var col_14306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13694_14305,(0),null);
var infos_14307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13694_14305,(1),null);
encode_cols(infos_14307,source_idx_14276,line_14285,col_14306);


var G__14308 = cljs.core.next(seq__13681_14299__$1);
var G__14309 = null;
var G__14310 = (0);
var G__14311 = (0);
seq__13681_14287 = G__14308;
chunk__13682_14288 = G__14309;
count__13683_14289 = G__14310;
i__13684_14290 = G__14311;
continue;
}
} else {
}
}
break;
}


var G__14312 = seq__13623_14280;
var G__14313 = chunk__13624_14281;
var G__14314 = count__13625_14282;
var G__14315 = (i__13626_14283 + (1));
seq__13623_14280 = G__14312;
chunk__13624_14281 = G__14313;
count__13625_14282 = G__14314;
i__13626_14283 = G__14315;
continue;
} else {
var temp__5735__auto___14316 = cljs.core.seq(seq__13623_14280);
if(temp__5735__auto___14316){
var seq__13623_14317__$1 = temp__5735__auto___14316;
if(cljs.core.chunked_seq_QMARK_(seq__13623_14317__$1)){
var c__4609__auto___14318 = cljs.core.chunk_first(seq__13623_14317__$1);
var G__14319 = cljs.core.chunk_rest(seq__13623_14317__$1);
var G__14320 = c__4609__auto___14318;
var G__14321 = cljs.core.count(c__4609__auto___14318);
var G__14322 = (0);
seq__13623_14280 = G__14319;
chunk__13624_14281 = G__14320;
count__13625_14282 = G__14321;
i__13626_14283 = G__14322;
continue;
} else {
var vec__13697_14323 = cljs.core.first(seq__13623_14317__$1);
var line_14324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13697_14323,(0),null);
var cols_14325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13697_14323,(1),null);
var seq__13700_14326 = cljs.core.seq(cols_14325);
var chunk__13701_14327 = null;
var count__13702_14328 = (0);
var i__13703_14329 = (0);
while(true){
if((i__13703_14329 < count__13702_14328)){
var vec__13710_14330 = chunk__13701_14327.cljs$core$IIndexed$_nth$arity$2(null,i__13703_14329);
var col_14331 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13710_14330,(0),null);
var infos_14332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13710_14330,(1),null);
encode_cols(infos_14332,source_idx_14276,line_14324,col_14331);


var G__14333 = seq__13700_14326;
var G__14334 = chunk__13701_14327;
var G__14335 = count__13702_14328;
var G__14336 = (i__13703_14329 + (1));
seq__13700_14326 = G__14333;
chunk__13701_14327 = G__14334;
count__13702_14328 = G__14335;
i__13703_14329 = G__14336;
continue;
} else {
var temp__5735__auto___14337__$1 = cljs.core.seq(seq__13700_14326);
if(temp__5735__auto___14337__$1){
var seq__13700_14338__$1 = temp__5735__auto___14337__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13700_14338__$1)){
var c__4609__auto___14339 = cljs.core.chunk_first(seq__13700_14338__$1);
var G__14340 = cljs.core.chunk_rest(seq__13700_14338__$1);
var G__14341 = c__4609__auto___14339;
var G__14342 = cljs.core.count(c__4609__auto___14339);
var G__14343 = (0);
seq__13700_14326 = G__14340;
chunk__13701_14327 = G__14341;
count__13702_14328 = G__14342;
i__13703_14329 = G__14343;
continue;
} else {
var vec__13713_14344 = cljs.core.first(seq__13700_14338__$1);
var col_14345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13713_14344,(0),null);
var infos_14346 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13713_14344,(1),null);
encode_cols(infos_14346,source_idx_14276,line_14324,col_14345);


var G__14347 = cljs.core.next(seq__13700_14338__$1);
var G__14348 = null;
var G__14349 = (0);
var G__14350 = (0);
seq__13700_14326 = G__14347;
chunk__13701_14327 = G__14348;
count__13702_14328 = G__14349;
i__13703_14329 = G__14350;
continue;
}
} else {
}
}
break;
}


var G__14351 = cljs.core.next(seq__13623_14317__$1);
var G__14352 = null;
var G__14353 = (0);
var G__14354 = (0);
seq__13623_14280 = G__14351;
chunk__13624_14281 = G__14352;
count__13625_14282 = G__14353;
i__13626_14283 = G__14354;
continue;
}
} else {
}
}
break;
}


var G__14355 = seq__13392_14271;
var G__14356 = chunk__13393_14272;
var G__14357 = count__13394_14273;
var G__14358 = (i__13395_14274 + (1));
seq__13392_14271 = G__14355;
chunk__13393_14272 = G__14356;
count__13394_14273 = G__14357;
i__13395_14274 = G__14358;
continue;
} else {
var temp__5735__auto___14359 = cljs.core.seq(seq__13392_14271);
if(temp__5735__auto___14359){
var seq__13392_14360__$1 = temp__5735__auto___14359;
if(cljs.core.chunked_seq_QMARK_(seq__13392_14360__$1)){
var c__4609__auto___14361 = cljs.core.chunk_first(seq__13392_14360__$1);
var G__14362 = cljs.core.chunk_rest(seq__13392_14360__$1);
var G__14363 = c__4609__auto___14361;
var G__14364 = cljs.core.count(c__4609__auto___14361);
var G__14365 = (0);
seq__13392_14271 = G__14362;
chunk__13393_14272 = G__14363;
count__13394_14273 = G__14364;
i__13395_14274 = G__14365;
continue;
} else {
var vec__13716_14366 = cljs.core.first(seq__13392_14360__$1);
var source_idx_14367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13716_14366,(0),null);
var vec__13719_14368 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13716_14366,(1),null);
var __14369 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13719_14368,(0),null);
var lines_14370__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13719_14368,(1),null);
var seq__13722_14371 = cljs.core.seq(lines_14370__$1);
var chunk__13723_14372 = null;
var count__13724_14373 = (0);
var i__13725_14374 = (0);
while(true){
if((i__13725_14374 < count__13724_14373)){
var vec__13768_14375 = chunk__13723_14372.cljs$core$IIndexed$_nth$arity$2(null,i__13725_14374);
var line_14376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13768_14375,(0),null);
var cols_14377 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13768_14375,(1),null);
var seq__13771_14378 = cljs.core.seq(cols_14377);
var chunk__13772_14379 = null;
var count__13773_14380 = (0);
var i__13774_14381 = (0);
while(true){
if((i__13774_14381 < count__13773_14380)){
var vec__13783_14382 = chunk__13772_14379.cljs$core$IIndexed$_nth$arity$2(null,i__13774_14381);
var col_14383 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13783_14382,(0),null);
var infos_14384 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13783_14382,(1),null);
encode_cols(infos_14384,source_idx_14367,line_14376,col_14383);


var G__14385 = seq__13771_14378;
var G__14386 = chunk__13772_14379;
var G__14387 = count__13773_14380;
var G__14388 = (i__13774_14381 + (1));
seq__13771_14378 = G__14385;
chunk__13772_14379 = G__14386;
count__13773_14380 = G__14387;
i__13774_14381 = G__14388;
continue;
} else {
var temp__5735__auto___14389__$1 = cljs.core.seq(seq__13771_14378);
if(temp__5735__auto___14389__$1){
var seq__13771_14390__$1 = temp__5735__auto___14389__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13771_14390__$1)){
var c__4609__auto___14391 = cljs.core.chunk_first(seq__13771_14390__$1);
var G__14392 = cljs.core.chunk_rest(seq__13771_14390__$1);
var G__14393 = c__4609__auto___14391;
var G__14394 = cljs.core.count(c__4609__auto___14391);
var G__14395 = (0);
seq__13771_14378 = G__14392;
chunk__13772_14379 = G__14393;
count__13773_14380 = G__14394;
i__13774_14381 = G__14395;
continue;
} else {
var vec__13786_14396 = cljs.core.first(seq__13771_14390__$1);
var col_14397 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13786_14396,(0),null);
var infos_14398 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13786_14396,(1),null);
encode_cols(infos_14398,source_idx_14367,line_14376,col_14397);


var G__14400 = cljs.core.next(seq__13771_14390__$1);
var G__14401 = null;
var G__14402 = (0);
var G__14403 = (0);
seq__13771_14378 = G__14400;
chunk__13772_14379 = G__14401;
count__13773_14380 = G__14402;
i__13774_14381 = G__14403;
continue;
}
} else {
}
}
break;
}


var G__14405 = seq__13722_14371;
var G__14406 = chunk__13723_14372;
var G__14407 = count__13724_14373;
var G__14408 = (i__13725_14374 + (1));
seq__13722_14371 = G__14405;
chunk__13723_14372 = G__14406;
count__13724_14373 = G__14407;
i__13725_14374 = G__14408;
continue;
} else {
var temp__5735__auto___14410__$1 = cljs.core.seq(seq__13722_14371);
if(temp__5735__auto___14410__$1){
var seq__13722_14411__$1 = temp__5735__auto___14410__$1;
if(cljs.core.chunked_seq_QMARK_(seq__13722_14411__$1)){
var c__4609__auto___14412 = cljs.core.chunk_first(seq__13722_14411__$1);
var G__14413 = cljs.core.chunk_rest(seq__13722_14411__$1);
var G__14414 = c__4609__auto___14412;
var G__14415 = cljs.core.count(c__4609__auto___14412);
var G__14416 = (0);
seq__13722_14371 = G__14413;
chunk__13723_14372 = G__14414;
count__13724_14373 = G__14415;
i__13725_14374 = G__14416;
continue;
} else {
var vec__13789_14418 = cljs.core.first(seq__13722_14411__$1);
var line_14419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13789_14418,(0),null);
var cols_14420 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13789_14418,(1),null);
var seq__13792_14421 = cljs.core.seq(cols_14420);
var chunk__13793_14422 = null;
var count__13794_14423 = (0);
var i__13795_14424 = (0);
while(true){
if((i__13795_14424 < count__13794_14423)){
var vec__13802_14426 = chunk__13793_14422.cljs$core$IIndexed$_nth$arity$2(null,i__13795_14424);
var col_14427 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13802_14426,(0),null);
var infos_14428 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13802_14426,(1),null);
encode_cols(infos_14428,source_idx_14367,line_14419,col_14427);


var G__14432 = seq__13792_14421;
var G__14433 = chunk__13793_14422;
var G__14434 = count__13794_14423;
var G__14435 = (i__13795_14424 + (1));
seq__13792_14421 = G__14432;
chunk__13793_14422 = G__14433;
count__13794_14423 = G__14434;
i__13795_14424 = G__14435;
continue;
} else {
var temp__5735__auto___14436__$2 = cljs.core.seq(seq__13792_14421);
if(temp__5735__auto___14436__$2){
var seq__13792_14437__$1 = temp__5735__auto___14436__$2;
if(cljs.core.chunked_seq_QMARK_(seq__13792_14437__$1)){
var c__4609__auto___14438 = cljs.core.chunk_first(seq__13792_14437__$1);
var G__14439 = cljs.core.chunk_rest(seq__13792_14437__$1);
var G__14440 = c__4609__auto___14438;
var G__14441 = cljs.core.count(c__4609__auto___14438);
var G__14442 = (0);
seq__13792_14421 = G__14439;
chunk__13793_14422 = G__14440;
count__13794_14423 = G__14441;
i__13795_14424 = G__14442;
continue;
} else {
var vec__13805_14443 = cljs.core.first(seq__13792_14437__$1);
var col_14444 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13805_14443,(0),null);
var infos_14445 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13805_14443,(1),null);
encode_cols(infos_14445,source_idx_14367,line_14419,col_14444);


var G__14448 = cljs.core.next(seq__13792_14437__$1);
var G__14449 = null;
var G__14450 = (0);
var G__14451 = (0);
seq__13792_14421 = G__14448;
chunk__13793_14422 = G__14449;
count__13794_14423 = G__14450;
i__13795_14424 = G__14451;
continue;
}
} else {
}
}
break;
}


var G__14453 = cljs.core.next(seq__13722_14411__$1);
var G__14454 = null;
var G__14455 = (0);
var G__14456 = (0);
seq__13722_14371 = G__14453;
chunk__13723_14372 = G__14454;
count__13724_14373 = G__14455;
i__13725_14374 = G__14456;
continue;
}
} else {
}
}
break;
}


var G__14457 = cljs.core.next(seq__13392_14360__$1);
var G__14458 = null;
var G__14459 = (0);
var G__14460 = (0);
seq__13392_14271 = G__14457;
chunk__13393_14272 = G__14458;
count__13394_14273 = G__14459;
i__13395_14274 = G__14460;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__13808 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__13355_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__13355_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__13356_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__13356_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__13357_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__13357_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__13809 = G__13808;
var G__13810_14463 = G__13809;
var G__13811_14464 = "sourcesContent";
var G__13812_14465 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__13810_14463,G__13811_14464,G__13812_14465);

return G__13809;
} else {
return G__13808;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__13813 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13813,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13813,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__13816 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13816,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13816,(1),null);
var G__14466 = cljs.core.next(col_map_seq);
var G__14467 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__13816,col,infos,vec__13813,line,col_map){
return (function (v,p__13819){
var map__13820 = p__13819;
var map__13820__$1 = (((((!((map__13820 == null))))?(((((map__13820.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13820.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13820):map__13820);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13820__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13820__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__13816,col,infos,vec__13813,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__14466;
new_cols = G__14467;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__14468 = cljs.core.next(line_map_seq);
var G__14469 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__14468;
new_lines = G__14469;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__13822_14470 = cljs.core.seq(reverse_map);
var chunk__13823_14471 = null;
var count__13824_14472 = (0);
var i__13825_14473 = (0);
while(true){
if((i__13825_14473 < count__13824_14472)){
var vec__14005_14474 = chunk__13823_14471.cljs$core$IIndexed$_nth$arity$2(null,i__13825_14473);
var line_14475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14005_14474,(0),null);
var columns_14476 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14005_14474,(1),null);
var seq__14008_14477 = cljs.core.seq(columns_14476);
var chunk__14009_14478 = null;
var count__14010_14479 = (0);
var i__14011_14480 = (0);
while(true){
if((i__14011_14480 < count__14010_14479)){
var vec__14050_14481 = chunk__14009_14478.cljs$core$IIndexed$_nth$arity$2(null,i__14011_14480);
var column_14482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14050_14481,(0),null);
var column_info_14483 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14050_14481,(1),null);
var seq__14053_14484 = cljs.core.seq(column_info_14483);
var chunk__14054_14485 = null;
var count__14055_14486 = (0);
var i__14056_14487 = (0);
while(true){
if((i__14056_14487 < count__14055_14486)){
var map__14066_14488 = chunk__14054_14485.cljs$core$IIndexed$_nth$arity$2(null,i__14056_14487);
var map__14066_14489__$1 = (((((!((map__14066_14488 == null))))?(((((map__14066_14488.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14066_14488.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14066_14488):map__14066_14488);
var gline_14490 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14066_14489__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14491 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14066_14489__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14492 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14066_14489__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14490], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14053_14484,chunk__14054_14485,count__14055_14486,i__14056_14487,seq__14008_14477,chunk__14009_14478,count__14010_14479,i__14011_14480,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14066_14488,map__14066_14489__$1,gline_14490,gcol_14491,name_14492,vec__14050_14481,column_14482,column_info_14483,vec__14005_14474,line_14475,columns_14476,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14491], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14475,new cljs.core.Keyword(null,"col","col",-1959363084),column_14482,new cljs.core.Keyword(null,"name","name",1843675177),name_14492], null));
});})(seq__14053_14484,chunk__14054_14485,count__14055_14486,i__14056_14487,seq__14008_14477,chunk__14009_14478,count__14010_14479,i__14011_14480,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14066_14488,map__14066_14489__$1,gline_14490,gcol_14491,name_14492,vec__14050_14481,column_14482,column_info_14483,vec__14005_14474,line_14475,columns_14476,inverted))
,cljs.core.sorted_map()));


var G__14493 = seq__14053_14484;
var G__14494 = chunk__14054_14485;
var G__14495 = count__14055_14486;
var G__14496 = (i__14056_14487 + (1));
seq__14053_14484 = G__14493;
chunk__14054_14485 = G__14494;
count__14055_14486 = G__14495;
i__14056_14487 = G__14496;
continue;
} else {
var temp__5735__auto___14497 = cljs.core.seq(seq__14053_14484);
if(temp__5735__auto___14497){
var seq__14053_14498__$1 = temp__5735__auto___14497;
if(cljs.core.chunked_seq_QMARK_(seq__14053_14498__$1)){
var c__4609__auto___14499 = cljs.core.chunk_first(seq__14053_14498__$1);
var G__14500 = cljs.core.chunk_rest(seq__14053_14498__$1);
var G__14501 = c__4609__auto___14499;
var G__14502 = cljs.core.count(c__4609__auto___14499);
var G__14503 = (0);
seq__14053_14484 = G__14500;
chunk__14054_14485 = G__14501;
count__14055_14486 = G__14502;
i__14056_14487 = G__14503;
continue;
} else {
var map__14070_14504 = cljs.core.first(seq__14053_14498__$1);
var map__14070_14505__$1 = (((((!((map__14070_14504 == null))))?(((((map__14070_14504.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14070_14504.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14070_14504):map__14070_14504);
var gline_14506 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14070_14505__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14507 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14070_14505__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14508 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14070_14505__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14506], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14053_14484,chunk__14054_14485,count__14055_14486,i__14056_14487,seq__14008_14477,chunk__14009_14478,count__14010_14479,i__14011_14480,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14070_14504,map__14070_14505__$1,gline_14506,gcol_14507,name_14508,seq__14053_14498__$1,temp__5735__auto___14497,vec__14050_14481,column_14482,column_info_14483,vec__14005_14474,line_14475,columns_14476,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14507], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14475,new cljs.core.Keyword(null,"col","col",-1959363084),column_14482,new cljs.core.Keyword(null,"name","name",1843675177),name_14508], null));
});})(seq__14053_14484,chunk__14054_14485,count__14055_14486,i__14056_14487,seq__14008_14477,chunk__14009_14478,count__14010_14479,i__14011_14480,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14070_14504,map__14070_14505__$1,gline_14506,gcol_14507,name_14508,seq__14053_14498__$1,temp__5735__auto___14497,vec__14050_14481,column_14482,column_info_14483,vec__14005_14474,line_14475,columns_14476,inverted))
,cljs.core.sorted_map()));


var G__14509 = cljs.core.next(seq__14053_14498__$1);
var G__14510 = null;
var G__14511 = (0);
var G__14512 = (0);
seq__14053_14484 = G__14509;
chunk__14054_14485 = G__14510;
count__14055_14486 = G__14511;
i__14056_14487 = G__14512;
continue;
}
} else {
}
}
break;
}


var G__14513 = seq__14008_14477;
var G__14514 = chunk__14009_14478;
var G__14515 = count__14010_14479;
var G__14516 = (i__14011_14480 + (1));
seq__14008_14477 = G__14513;
chunk__14009_14478 = G__14514;
count__14010_14479 = G__14515;
i__14011_14480 = G__14516;
continue;
} else {
var temp__5735__auto___14517 = cljs.core.seq(seq__14008_14477);
if(temp__5735__auto___14517){
var seq__14008_14518__$1 = temp__5735__auto___14517;
if(cljs.core.chunked_seq_QMARK_(seq__14008_14518__$1)){
var c__4609__auto___14519 = cljs.core.chunk_first(seq__14008_14518__$1);
var G__14520 = cljs.core.chunk_rest(seq__14008_14518__$1);
var G__14521 = c__4609__auto___14519;
var G__14522 = cljs.core.count(c__4609__auto___14519);
var G__14523 = (0);
seq__14008_14477 = G__14520;
chunk__14009_14478 = G__14521;
count__14010_14479 = G__14522;
i__14011_14480 = G__14523;
continue;
} else {
var vec__14080_14524 = cljs.core.first(seq__14008_14518__$1);
var column_14525 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14080_14524,(0),null);
var column_info_14526 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14080_14524,(1),null);
var seq__14083_14527 = cljs.core.seq(column_info_14526);
var chunk__14084_14528 = null;
var count__14085_14529 = (0);
var i__14086_14530 = (0);
while(true){
if((i__14086_14530 < count__14085_14529)){
var map__14091_14531 = chunk__14084_14528.cljs$core$IIndexed$_nth$arity$2(null,i__14086_14530);
var map__14091_14532__$1 = (((((!((map__14091_14531 == null))))?(((((map__14091_14531.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14091_14531.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14091_14531):map__14091_14531);
var gline_14533 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14091_14532__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14534 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14091_14532__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14535 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14091_14532__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14533], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14083_14527,chunk__14084_14528,count__14085_14529,i__14086_14530,seq__14008_14477,chunk__14009_14478,count__14010_14479,i__14011_14480,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14091_14531,map__14091_14532__$1,gline_14533,gcol_14534,name_14535,vec__14080_14524,column_14525,column_info_14526,seq__14008_14518__$1,temp__5735__auto___14517,vec__14005_14474,line_14475,columns_14476,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14534], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14475,new cljs.core.Keyword(null,"col","col",-1959363084),column_14525,new cljs.core.Keyword(null,"name","name",1843675177),name_14535], null));
});})(seq__14083_14527,chunk__14084_14528,count__14085_14529,i__14086_14530,seq__14008_14477,chunk__14009_14478,count__14010_14479,i__14011_14480,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14091_14531,map__14091_14532__$1,gline_14533,gcol_14534,name_14535,vec__14080_14524,column_14525,column_info_14526,seq__14008_14518__$1,temp__5735__auto___14517,vec__14005_14474,line_14475,columns_14476,inverted))
,cljs.core.sorted_map()));


var G__14537 = seq__14083_14527;
var G__14538 = chunk__14084_14528;
var G__14539 = count__14085_14529;
var G__14540 = (i__14086_14530 + (1));
seq__14083_14527 = G__14537;
chunk__14084_14528 = G__14538;
count__14085_14529 = G__14539;
i__14086_14530 = G__14540;
continue;
} else {
var temp__5735__auto___14541__$1 = cljs.core.seq(seq__14083_14527);
if(temp__5735__auto___14541__$1){
var seq__14083_14542__$1 = temp__5735__auto___14541__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14083_14542__$1)){
var c__4609__auto___14543 = cljs.core.chunk_first(seq__14083_14542__$1);
var G__14544 = cljs.core.chunk_rest(seq__14083_14542__$1);
var G__14545 = c__4609__auto___14543;
var G__14546 = cljs.core.count(c__4609__auto___14543);
var G__14547 = (0);
seq__14083_14527 = G__14544;
chunk__14084_14528 = G__14545;
count__14085_14529 = G__14546;
i__14086_14530 = G__14547;
continue;
} else {
var map__14093_14548 = cljs.core.first(seq__14083_14542__$1);
var map__14093_14549__$1 = (((((!((map__14093_14548 == null))))?(((((map__14093_14548.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14093_14548.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14093_14548):map__14093_14548);
var gline_14550 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14093_14549__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14551 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14093_14549__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14552 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14093_14549__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14550], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14083_14527,chunk__14084_14528,count__14085_14529,i__14086_14530,seq__14008_14477,chunk__14009_14478,count__14010_14479,i__14011_14480,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14093_14548,map__14093_14549__$1,gline_14550,gcol_14551,name_14552,seq__14083_14542__$1,temp__5735__auto___14541__$1,vec__14080_14524,column_14525,column_info_14526,seq__14008_14518__$1,temp__5735__auto___14517,vec__14005_14474,line_14475,columns_14476,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14551], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14475,new cljs.core.Keyword(null,"col","col",-1959363084),column_14525,new cljs.core.Keyword(null,"name","name",1843675177),name_14552], null));
});})(seq__14083_14527,chunk__14084_14528,count__14085_14529,i__14086_14530,seq__14008_14477,chunk__14009_14478,count__14010_14479,i__14011_14480,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14093_14548,map__14093_14549__$1,gline_14550,gcol_14551,name_14552,seq__14083_14542__$1,temp__5735__auto___14541__$1,vec__14080_14524,column_14525,column_info_14526,seq__14008_14518__$1,temp__5735__auto___14517,vec__14005_14474,line_14475,columns_14476,inverted))
,cljs.core.sorted_map()));


var G__14553 = cljs.core.next(seq__14083_14542__$1);
var G__14554 = null;
var G__14555 = (0);
var G__14556 = (0);
seq__14083_14527 = G__14553;
chunk__14084_14528 = G__14554;
count__14085_14529 = G__14555;
i__14086_14530 = G__14556;
continue;
}
} else {
}
}
break;
}


var G__14557 = cljs.core.next(seq__14008_14518__$1);
var G__14558 = null;
var G__14559 = (0);
var G__14560 = (0);
seq__14008_14477 = G__14557;
chunk__14009_14478 = G__14558;
count__14010_14479 = G__14559;
i__14011_14480 = G__14560;
continue;
}
} else {
}
}
break;
}


var G__14561 = seq__13822_14470;
var G__14562 = chunk__13823_14471;
var G__14563 = count__13824_14472;
var G__14564 = (i__13825_14473 + (1));
seq__13822_14470 = G__14561;
chunk__13823_14471 = G__14562;
count__13824_14472 = G__14563;
i__13825_14473 = G__14564;
continue;
} else {
var temp__5735__auto___14565 = cljs.core.seq(seq__13822_14470);
if(temp__5735__auto___14565){
var seq__13822_14566__$1 = temp__5735__auto___14565;
if(cljs.core.chunked_seq_QMARK_(seq__13822_14566__$1)){
var c__4609__auto___14567 = cljs.core.chunk_first(seq__13822_14566__$1);
var G__14568 = cljs.core.chunk_rest(seq__13822_14566__$1);
var G__14569 = c__4609__auto___14567;
var G__14570 = cljs.core.count(c__4609__auto___14567);
var G__14571 = (0);
seq__13822_14470 = G__14568;
chunk__13823_14471 = G__14569;
count__13824_14472 = G__14570;
i__13825_14473 = G__14571;
continue;
} else {
var vec__14095_14572 = cljs.core.first(seq__13822_14566__$1);
var line_14573 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14095_14572,(0),null);
var columns_14574 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14095_14572,(1),null);
var seq__14098_14575 = cljs.core.seq(columns_14574);
var chunk__14099_14576 = null;
var count__14100_14577 = (0);
var i__14101_14578 = (0);
while(true){
if((i__14101_14578 < count__14100_14577)){
var vec__14156_14579 = chunk__14099_14576.cljs$core$IIndexed$_nth$arity$2(null,i__14101_14578);
var column_14580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14156_14579,(0),null);
var column_info_14581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14156_14579,(1),null);
var seq__14159_14582 = cljs.core.seq(column_info_14581);
var chunk__14160_14583 = null;
var count__14161_14584 = (0);
var i__14162_14585 = (0);
while(true){
if((i__14162_14585 < count__14161_14584)){
var map__14173_14586 = chunk__14160_14583.cljs$core$IIndexed$_nth$arity$2(null,i__14162_14585);
var map__14173_14587__$1 = (((((!((map__14173_14586 == null))))?(((((map__14173_14586.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14173_14586.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14173_14586):map__14173_14586);
var gline_14588 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14173_14587__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14589 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14173_14587__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14590 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14173_14587__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14588], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14159_14582,chunk__14160_14583,count__14161_14584,i__14162_14585,seq__14098_14575,chunk__14099_14576,count__14100_14577,i__14101_14578,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14173_14586,map__14173_14587__$1,gline_14588,gcol_14589,name_14590,vec__14156_14579,column_14580,column_info_14581,vec__14095_14572,line_14573,columns_14574,seq__13822_14566__$1,temp__5735__auto___14565,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14589], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14573,new cljs.core.Keyword(null,"col","col",-1959363084),column_14580,new cljs.core.Keyword(null,"name","name",1843675177),name_14590], null));
});})(seq__14159_14582,chunk__14160_14583,count__14161_14584,i__14162_14585,seq__14098_14575,chunk__14099_14576,count__14100_14577,i__14101_14578,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14173_14586,map__14173_14587__$1,gline_14588,gcol_14589,name_14590,vec__14156_14579,column_14580,column_info_14581,vec__14095_14572,line_14573,columns_14574,seq__13822_14566__$1,temp__5735__auto___14565,inverted))
,cljs.core.sorted_map()));


var G__14591 = seq__14159_14582;
var G__14592 = chunk__14160_14583;
var G__14593 = count__14161_14584;
var G__14594 = (i__14162_14585 + (1));
seq__14159_14582 = G__14591;
chunk__14160_14583 = G__14592;
count__14161_14584 = G__14593;
i__14162_14585 = G__14594;
continue;
} else {
var temp__5735__auto___14595__$1 = cljs.core.seq(seq__14159_14582);
if(temp__5735__auto___14595__$1){
var seq__14159_14596__$1 = temp__5735__auto___14595__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14159_14596__$1)){
var c__4609__auto___14597 = cljs.core.chunk_first(seq__14159_14596__$1);
var G__14598 = cljs.core.chunk_rest(seq__14159_14596__$1);
var G__14599 = c__4609__auto___14597;
var G__14600 = cljs.core.count(c__4609__auto___14597);
var G__14601 = (0);
seq__14159_14582 = G__14598;
chunk__14160_14583 = G__14599;
count__14161_14584 = G__14600;
i__14162_14585 = G__14601;
continue;
} else {
var map__14181_14602 = cljs.core.first(seq__14159_14596__$1);
var map__14181_14603__$1 = (((((!((map__14181_14602 == null))))?(((((map__14181_14602.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14181_14602.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14181_14602):map__14181_14602);
var gline_14604 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14181_14603__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14605 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14181_14603__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14606 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14181_14603__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14604], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14159_14582,chunk__14160_14583,count__14161_14584,i__14162_14585,seq__14098_14575,chunk__14099_14576,count__14100_14577,i__14101_14578,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14181_14602,map__14181_14603__$1,gline_14604,gcol_14605,name_14606,seq__14159_14596__$1,temp__5735__auto___14595__$1,vec__14156_14579,column_14580,column_info_14581,vec__14095_14572,line_14573,columns_14574,seq__13822_14566__$1,temp__5735__auto___14565,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14605], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14573,new cljs.core.Keyword(null,"col","col",-1959363084),column_14580,new cljs.core.Keyword(null,"name","name",1843675177),name_14606], null));
});})(seq__14159_14582,chunk__14160_14583,count__14161_14584,i__14162_14585,seq__14098_14575,chunk__14099_14576,count__14100_14577,i__14101_14578,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14181_14602,map__14181_14603__$1,gline_14604,gcol_14605,name_14606,seq__14159_14596__$1,temp__5735__auto___14595__$1,vec__14156_14579,column_14580,column_info_14581,vec__14095_14572,line_14573,columns_14574,seq__13822_14566__$1,temp__5735__auto___14565,inverted))
,cljs.core.sorted_map()));


var G__14607 = cljs.core.next(seq__14159_14596__$1);
var G__14608 = null;
var G__14609 = (0);
var G__14610 = (0);
seq__14159_14582 = G__14607;
chunk__14160_14583 = G__14608;
count__14161_14584 = G__14609;
i__14162_14585 = G__14610;
continue;
}
} else {
}
}
break;
}


var G__14611 = seq__14098_14575;
var G__14612 = chunk__14099_14576;
var G__14613 = count__14100_14577;
var G__14614 = (i__14101_14578 + (1));
seq__14098_14575 = G__14611;
chunk__14099_14576 = G__14612;
count__14100_14577 = G__14613;
i__14101_14578 = G__14614;
continue;
} else {
var temp__5735__auto___14615__$1 = cljs.core.seq(seq__14098_14575);
if(temp__5735__auto___14615__$1){
var seq__14098_14616__$1 = temp__5735__auto___14615__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14098_14616__$1)){
var c__4609__auto___14617 = cljs.core.chunk_first(seq__14098_14616__$1);
var G__14618 = cljs.core.chunk_rest(seq__14098_14616__$1);
var G__14619 = c__4609__auto___14617;
var G__14620 = cljs.core.count(c__4609__auto___14617);
var G__14621 = (0);
seq__14098_14575 = G__14618;
chunk__14099_14576 = G__14619;
count__14100_14577 = G__14620;
i__14101_14578 = G__14621;
continue;
} else {
var vec__14189_14622 = cljs.core.first(seq__14098_14616__$1);
var column_14623 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14189_14622,(0),null);
var column_info_14624 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14189_14622,(1),null);
var seq__14192_14625 = cljs.core.seq(column_info_14624);
var chunk__14193_14626 = null;
var count__14194_14627 = (0);
var i__14195_14628 = (0);
while(true){
if((i__14195_14628 < count__14194_14627)){
var map__14204_14629 = chunk__14193_14626.cljs$core$IIndexed$_nth$arity$2(null,i__14195_14628);
var map__14204_14630__$1 = (((((!((map__14204_14629 == null))))?(((((map__14204_14629.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14204_14629.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14204_14629):map__14204_14629);
var gline_14631 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14204_14630__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14632 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14204_14630__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14204_14630__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14631], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14192_14625,chunk__14193_14626,count__14194_14627,i__14195_14628,seq__14098_14575,chunk__14099_14576,count__14100_14577,i__14101_14578,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14204_14629,map__14204_14630__$1,gline_14631,gcol_14632,name_14633,vec__14189_14622,column_14623,column_info_14624,seq__14098_14616__$1,temp__5735__auto___14615__$1,vec__14095_14572,line_14573,columns_14574,seq__13822_14566__$1,temp__5735__auto___14565,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14632], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14573,new cljs.core.Keyword(null,"col","col",-1959363084),column_14623,new cljs.core.Keyword(null,"name","name",1843675177),name_14633], null));
});})(seq__14192_14625,chunk__14193_14626,count__14194_14627,i__14195_14628,seq__14098_14575,chunk__14099_14576,count__14100_14577,i__14101_14578,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14204_14629,map__14204_14630__$1,gline_14631,gcol_14632,name_14633,vec__14189_14622,column_14623,column_info_14624,seq__14098_14616__$1,temp__5735__auto___14615__$1,vec__14095_14572,line_14573,columns_14574,seq__13822_14566__$1,temp__5735__auto___14565,inverted))
,cljs.core.sorted_map()));


var G__14634 = seq__14192_14625;
var G__14635 = chunk__14193_14626;
var G__14636 = count__14194_14627;
var G__14637 = (i__14195_14628 + (1));
seq__14192_14625 = G__14634;
chunk__14193_14626 = G__14635;
count__14194_14627 = G__14636;
i__14195_14628 = G__14637;
continue;
} else {
var temp__5735__auto___14638__$2 = cljs.core.seq(seq__14192_14625);
if(temp__5735__auto___14638__$2){
var seq__14192_14639__$1 = temp__5735__auto___14638__$2;
if(cljs.core.chunked_seq_QMARK_(seq__14192_14639__$1)){
var c__4609__auto___14640 = cljs.core.chunk_first(seq__14192_14639__$1);
var G__14641 = cljs.core.chunk_rest(seq__14192_14639__$1);
var G__14642 = c__4609__auto___14640;
var G__14643 = cljs.core.count(c__4609__auto___14640);
var G__14644 = (0);
seq__14192_14625 = G__14641;
chunk__14193_14626 = G__14642;
count__14194_14627 = G__14643;
i__14195_14628 = G__14644;
continue;
} else {
var map__14206_14645 = cljs.core.first(seq__14192_14639__$1);
var map__14206_14646__$1 = (((((!((map__14206_14645 == null))))?(((((map__14206_14645.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14206_14645.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14206_14645):map__14206_14645);
var gline_14647 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14206_14646__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_14648 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14206_14646__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_14649 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14206_14646__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_14647], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__14192_14625,chunk__14193_14626,count__14194_14627,i__14195_14628,seq__14098_14575,chunk__14099_14576,count__14100_14577,i__14101_14578,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14206_14645,map__14206_14646__$1,gline_14647,gcol_14648,name_14649,seq__14192_14639__$1,temp__5735__auto___14638__$2,vec__14189_14622,column_14623,column_info_14624,seq__14098_14616__$1,temp__5735__auto___14615__$1,vec__14095_14572,line_14573,columns_14574,seq__13822_14566__$1,temp__5735__auto___14565,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_14648], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_14573,new cljs.core.Keyword(null,"col","col",-1959363084),column_14623,new cljs.core.Keyword(null,"name","name",1843675177),name_14649], null));
});})(seq__14192_14625,chunk__14193_14626,count__14194_14627,i__14195_14628,seq__14098_14575,chunk__14099_14576,count__14100_14577,i__14101_14578,seq__13822_14470,chunk__13823_14471,count__13824_14472,i__13825_14473,map__14206_14645,map__14206_14646__$1,gline_14647,gcol_14648,name_14649,seq__14192_14639__$1,temp__5735__auto___14638__$2,vec__14189_14622,column_14623,column_info_14624,seq__14098_14616__$1,temp__5735__auto___14615__$1,vec__14095_14572,line_14573,columns_14574,seq__13822_14566__$1,temp__5735__auto___14565,inverted))
,cljs.core.sorted_map()));


var G__14652 = cljs.core.next(seq__14192_14639__$1);
var G__14653 = null;
var G__14654 = (0);
var G__14655 = (0);
seq__14192_14625 = G__14652;
chunk__14193_14626 = G__14653;
count__14194_14627 = G__14654;
i__14195_14628 = G__14655;
continue;
}
} else {
}
}
break;
}


var G__14658 = cljs.core.next(seq__14098_14616__$1);
var G__14659 = null;
var G__14660 = (0);
var G__14661 = (0);
seq__14098_14575 = G__14658;
chunk__14099_14576 = G__14659;
count__14100_14577 = G__14660;
i__14101_14578 = G__14661;
continue;
}
} else {
}
}
break;
}


var G__14662 = cljs.core.next(seq__13822_14566__$1);
var G__14663 = null;
var G__14664 = (0);
var G__14665 = (0);
seq__13822_14470 = G__14662;
chunk__13823_14471 = G__14663;
count__13824_14472 = G__14664;
i__13825_14473 = G__14665;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
