goog.provide('quil.sketch');
quil.sketch._STAR_applet_STAR_ = null;
quil.sketch.current_applet = (function quil$sketch$current_applet(){
return quil.sketch._STAR_applet_STAR_;
});
quil.sketch.rendering_modes = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"java2d","java2d",166099237),(p5.prototype["JAVA2D"]),new cljs.core.Keyword(null,"p2d","p2d",-2106175755),(p5.prototype["P2D"]),new cljs.core.Keyword(null,"p3d","p3d",-850380194),(p5.prototype["P3D"]),new cljs.core.Keyword(null,"opengl","opengl",-614998103),(p5.prototype["OPENGL"])], null);
quil.sketch.resolve_renderer = (function quil$sketch$resolve_renderer(mode){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p3d","p3d",-850380194),mode)){
return (p5.prototype["WEBGL"]);
} else {
return quil.util.resolve_constant_key(mode,quil.sketch.rendering_modes);
}
});
quil.sketch.set_size = (function quil$sketch$set_size(applet,width,height){
var temp__5735__auto__ = applet.quil_canvas;
if(cljs.core.truth_(temp__5735__auto__)){
var el = temp__5735__auto__;
var inner_canvas = el.querySelector("canvas");
applet.resizeCanvas(width,height);

inner_canvas.setAttribute("width",width);

inner_canvas.setAttribute("height",height);

(inner_canvas.style["width"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(width),"px"].join(''));

(inner_canvas.style["height"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(height),"px"].join(''));

(applet.width = window.parseInt(goog.style.getComputedStyle(inner_canvas,"width")));

return (applet.height = window.parseInt(goog.style.getComputedStyle(inner_canvas,"height")));
} else {
return null;
}
});
quil.sketch.size = (function quil$sketch$size(var_args){
var G__11661 = arguments.length;
switch (G__11661) {
case 2:
return quil.sketch.size.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return quil.sketch.size.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(quil.sketch.size.cljs$core$IFn$_invoke$arity$2 = (function (width,height){
return quil.sketch.current_applet().createCanvas((width | (0)),(height | (0)));
}));

(quil.sketch.size.cljs$core$IFn$_invoke$arity$3 = (function (width,height,mode){
return quil.sketch.current_applet().createCanvas((width | (0)),(height | (0)),quil.sketch.resolve_renderer(mode));
}));

(quil.sketch.size.cljs$lang$maxFixedArity = 3);

quil.sketch.bind_handlers = (function quil$sketch$bind_handlers(prc,opts){
var seq__11664 = cljs.core.seq(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"keyPressed","keyPressed",1791025256),new cljs.core.Keyword(null,"mouseOut","mouseOut",-386669045),new cljs.core.Keyword(null,"mouseDragged","mouseDragged",129975181),new cljs.core.Keyword(null,"setup","setup",1987730512),new cljs.core.Keyword(null,"mouseWheel","mouseWheel",-1057803856),new cljs.core.Keyword(null,"keyReleased","keyReleased",541714964),new cljs.core.Keyword(null,"mouseClicked","mouseClicked",1764302965),new cljs.core.Keyword(null,"mouseReleased","mouseReleased",1116234838),new cljs.core.Keyword(null,"mousePressed","mousePressed",1776186454),new cljs.core.Keyword(null,"mouseMoved","mouseMoved",-1936954058),new cljs.core.Keyword(null,"mouseOver","mouseOver",-1334461930),new cljs.core.Keyword(null,"keyTyped","keyTyped",1437329399),new cljs.core.Keyword(null,"draw","draw",1358331674)],[new cljs.core.Keyword(null,"key-pressed","key-pressed",-757100364),new cljs.core.Keyword(null,"mouse-exited","mouse-exited",-483205244),new cljs.core.Keyword(null,"mouse-dragged","mouse-dragged",-1220073441),new cljs.core.Keyword(null,"setup","setup",1987730512),new cljs.core.Keyword(null,"mouse-wheel","mouse-wheel",1811662439),new cljs.core.Keyword(null,"key-released","key-released",215919828),new cljs.core.Keyword(null,"mouse-clicked","mouse-clicked",-199339421),new cljs.core.Keyword(null,"mouse-released","mouse-released",-664480061),new cljs.core.Keyword(null,"mouse-pressed","mouse-pressed",736955536),new cljs.core.Keyword(null,"mouse-moved","mouse-moved",-1918152310),new cljs.core.Keyword(null,"mouse-entered","mouse-entered",811350322),new cljs.core.Keyword(null,"key-typed","key-typed",-876037597),new cljs.core.Keyword(null,"draw","draw",1358331674)]));
var chunk__11665 = null;
var count__11666 = (0);
var i__11667 = (0);
while(true){
if((i__11667 < count__11666)){
var vec__11678 = chunk__11665.cljs$core$IIndexed$_nth$arity$2(null,i__11667);
var processing_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11678,(0),null);
var quil_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11678,(1),null);
var temp__5735__auto___11723 = (opts.cljs$core$IFn$_invoke$arity$1 ? opts.cljs$core$IFn$_invoke$arity$1(quil_name) : opts.call(null,quil_name));
if(cljs.core.truth_(temp__5735__auto___11723)){
var handler_11724 = temp__5735__auto___11723;
(prc[cljs.core.name(processing_name)] = ((function (seq__11664,chunk__11665,count__11666,i__11667,handler_11724,temp__5735__auto___11723,vec__11678,processing_name,quil_name){
return (function() { 
var G__11725__delegate = function (args){
var _STAR_applet_STAR__orig_val__11681 = quil.sketch._STAR_applet_STAR_;
var _STAR_applet_STAR__temp_val__11682 = prc;
(quil.sketch._STAR_applet_STAR_ = _STAR_applet_STAR__temp_val__11682);

try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(handler_11724,args);
}finally {(quil.sketch._STAR_applet_STAR_ = _STAR_applet_STAR__orig_val__11681);
}};
var G__11725 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__11726__i = 0, G__11726__a = new Array(arguments.length -  0);
while (G__11726__i < G__11726__a.length) {G__11726__a[G__11726__i] = arguments[G__11726__i + 0]; ++G__11726__i;}
  args = new cljs.core.IndexedSeq(G__11726__a,0,null);
} 
return G__11725__delegate.call(this,args);};
G__11725.cljs$lang$maxFixedArity = 0;
G__11725.cljs$lang$applyTo = (function (arglist__11727){
var args = cljs.core.seq(arglist__11727);
return G__11725__delegate(args);
});
G__11725.cljs$core$IFn$_invoke$arity$variadic = G__11725__delegate;
return G__11725;
})()
;})(seq__11664,chunk__11665,count__11666,i__11667,handler_11724,temp__5735__auto___11723,vec__11678,processing_name,quil_name))
);
} else {
}


var G__11728 = seq__11664;
var G__11729 = chunk__11665;
var G__11730 = count__11666;
var G__11731 = (i__11667 + (1));
seq__11664 = G__11728;
chunk__11665 = G__11729;
count__11666 = G__11730;
i__11667 = G__11731;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__11664);
if(temp__5735__auto__){
var seq__11664__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11664__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__11664__$1);
var G__11732 = cljs.core.chunk_rest(seq__11664__$1);
var G__11733 = c__4609__auto__;
var G__11734 = cljs.core.count(c__4609__auto__);
var G__11735 = (0);
seq__11664 = G__11732;
chunk__11665 = G__11733;
count__11666 = G__11734;
i__11667 = G__11735;
continue;
} else {
var vec__11683 = cljs.core.first(seq__11664__$1);
var processing_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11683,(0),null);
var quil_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11683,(1),null);
var temp__5735__auto___11736__$1 = (opts.cljs$core$IFn$_invoke$arity$1 ? opts.cljs$core$IFn$_invoke$arity$1(quil_name) : opts.call(null,quil_name));
if(cljs.core.truth_(temp__5735__auto___11736__$1)){
var handler_11737 = temp__5735__auto___11736__$1;
(prc[cljs.core.name(processing_name)] = ((function (seq__11664,chunk__11665,count__11666,i__11667,handler_11737,temp__5735__auto___11736__$1,vec__11683,processing_name,quil_name,seq__11664__$1,temp__5735__auto__){
return (function() { 
var G__11738__delegate = function (args){
var _STAR_applet_STAR__orig_val__11686 = quil.sketch._STAR_applet_STAR_;
var _STAR_applet_STAR__temp_val__11687 = prc;
(quil.sketch._STAR_applet_STAR_ = _STAR_applet_STAR__temp_val__11687);

try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(handler_11737,args);
}finally {(quil.sketch._STAR_applet_STAR_ = _STAR_applet_STAR__orig_val__11686);
}};
var G__11738 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__11739__i = 0, G__11739__a = new Array(arguments.length -  0);
while (G__11739__i < G__11739__a.length) {G__11739__a[G__11739__i] = arguments[G__11739__i + 0]; ++G__11739__i;}
  args = new cljs.core.IndexedSeq(G__11739__a,0,null);
} 
return G__11738__delegate.call(this,args);};
G__11738.cljs$lang$maxFixedArity = 0;
G__11738.cljs$lang$applyTo = (function (arglist__11740){
var args = cljs.core.seq(arglist__11740);
return G__11738__delegate(args);
});
G__11738.cljs$core$IFn$_invoke$arity$variadic = G__11738__delegate;
return G__11738;
})()
;})(seq__11664,chunk__11665,count__11666,i__11667,handler_11737,temp__5735__auto___11736__$1,vec__11683,processing_name,quil_name,seq__11664__$1,temp__5735__auto__))
);
} else {
}


var G__11741 = cljs.core.next(seq__11664__$1);
var G__11742 = null;
var G__11743 = (0);
var G__11744 = (0);
seq__11664 = G__11741;
chunk__11665 = G__11742;
count__11666 = G__11743;
i__11667 = G__11744;
continue;
}
} else {
return null;
}
}
break;
}
});
quil.sketch.in_fullscreen_QMARK_ = (function quil$sketch$in_fullscreen_QMARK_(){
var or__4185__auto__ = document.fullscreenElement;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return document.mozFullScreenElement;
}
});
/**
 * Adds fullscreen support for the provided `p5` object.
 *   Fullscreen is enabled when the user presses `F11`. We turn
 *   the sketch `<canvas>` element to fullscreen storing the old size
 *   in an `atom`. When the user cancels fullscreen (`F11` or `Esc`)
 *   we resize the sketch back to the old size.
 */
quil.sketch.add_fullscreen_support = (function quil$sketch$add_fullscreen_support(applet){
var old_size = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var adjust_canvas_size = (function (){
if(cljs.core.truth_(quil.sketch.in_fullscreen_QMARK_())){
cljs.core.reset_BANG_(old_size,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [applet.width,applet.height], null));

return quil.sketch.set_size(applet,window.screen.width,window.screen.height);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(quil.sketch.set_size,applet,cljs.core.deref(old_size));
}
});
var G__11689_11745 = window;
var G__11690_11746 = goog.events.EventType.KEYDOWN;
var G__11691_11747 = (function (event){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(event.key,"F11")) && (cljs.core.not(quil.sketch.in_fullscreen_QMARK_())))){
event.preventDefault();

var canvas = applet.quil_canvas;
if(cljs.core.truth_(canvas.requestFullscreen)){
return canvas.requestFullscreen();
} else {
if(cljs.core.truth_(canvas.mozRequestFullScreen)){
return canvas.mozRequestFullScreen();
} else {
return console.warn("Fullscreen mode is not supported in current browser.");

}
}
} else {
return null;
}
});
goog.events.listen(G__11689_11745,G__11690_11746,G__11691_11747);

goog.events.listen(document,"fullscreenchange",adjust_canvas_size);

goog.events.listen(document,"mozfullscreenchange",adjust_canvas_size);

var G__11692 = document;
var G__11693 = "fullscreenerror";
var G__11694 = (function (p1__11688_SHARP_){
return console.error("Error while switching to/from fullscreen: ",p1__11688_SHARP_);
});
return goog.events.listen(G__11692,G__11693,G__11694);
});
quil.sketch.make_sketch = (function quil$sketch$make_sketch(options){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(500),(300)], null)], null),(function (){var G__11697 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,cljs.core.cons(quil.middlewares.deprecated_options.deprecated_options,new cljs.core.Keyword(null,"middleware","middleware",1462115504).cljs$core$IFn$_invoke$arity$2(options,cljs.core.PersistentVector.EMPTY)));
var fexpr__11696 = (function (p1__11695_SHARP_){
return (p1__11695_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11695_SHARP_.cljs$core$IFn$_invoke$arity$1(options) : p1__11695_SHARP_.call(null,options));
});
return fexpr__11696(G__11697);
})()], 0));
var sketch_size = new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(opts);
var renderer = new cljs.core.Keyword(null,"renderer","renderer",336841071).cljs$core$IFn$_invoke$arity$1(opts);
var features = cljs.core.set(new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(opts));
var setup = (function (){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(quil.sketch.size,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(sketch_size,(cljs.core.truth_(renderer)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [renderer], null):cljs.core.PersistentVector.EMPTY)));

if(cljs.core.truth_(new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(opts))){
var fexpr__11698_11748 = new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(opts);
(fexpr__11698_11748.cljs$core$IFn$_invoke$arity$0 ? fexpr__11698_11748.cljs$core$IFn$_invoke$arity$0() : fexpr__11698_11748.call(null));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"setup","setup",1987730512).cljs$core$IFn$_invoke$arity$1(opts))){
var fexpr__11699 = new cljs.core.Keyword(null,"setup","setup",1987730512).cljs$core$IFn$_invoke$arity$1(opts);
return (fexpr__11699.cljs$core$IFn$_invoke$arity$0 ? fexpr__11699.cljs$core$IFn$_invoke$arity$0() : fexpr__11699.call(null));
} else {
return null;
}
});
var mouse_wheel = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"mouse-wheel","mouse-wheel",1811662439).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var wheel_handler = temp__5735__auto__;
return (function (evt){
var G__11700 = goog.object.get(evt,"delta");
return (wheel_handler.cljs$core$IFn$_invoke$arity$1 ? wheel_handler.cljs$core$IFn$_invoke$arity$1(G__11700) : wheel_handler.call(null,G__11700));
});
} else {
return null;
}
})();
var opts__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"setup","setup",1987730512),setup,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"mouse-wheel","mouse-wheel",1811662439),mouse_wheel], 0));
var sketch = (function (prc){
quil.sketch.bind_handlers(prc,opts__$1);

(prc.quil = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null));

return (prc.quil_internal_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(quil.util.initial_internal_state));
});
return sketch;
});
quil.sketch.destroy_previous_sketch = (function quil$sketch$destroy_previous_sketch(host_elem){
var temp__5735__auto__ = host_elem.processing_obj;
if(cljs.core.truth_(temp__5735__auto__)){
var proc_obj = temp__5735__auto__;
return proc_obj.remove();
} else {
return null;
}
});
quil.sketch.sketch = (function quil$sketch$sketch(var_args){
var args__4795__auto__ = [];
var len__4789__auto___11749 = arguments.length;
var i__4790__auto___11750 = (0);
while(true){
if((i__4790__auto___11750 < len__4789__auto___11749)){
args__4795__auto__.push((arguments[i__4790__auto___11750]));

var G__11751 = (i__4790__auto___11750 + (1));
i__4790__auto___11750 = G__11751;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((0) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((0)),(0),null)):null);
return quil.sketch.sketch.cljs$core$IFn$_invoke$arity$variadic(argseq__4796__auto__);
});

(quil.sketch.sketch.cljs$core$IFn$_invoke$arity$variadic = (function (opts){
var opts_map = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,opts);
var host_elem = new cljs.core.Keyword(null,"host","host",-1558485167).cljs$core$IFn$_invoke$arity$1(opts_map);
var renderer = (function (){var or__4185__auto__ = new cljs.core.Keyword(null,"renderer","renderer",336841071).cljs$core$IFn$_invoke$arity$1(opts_map);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"p2d","p2d",-2106175755);
}
})();
var host_elem__$1 = ((typeof host_elem === 'string')?document.getElementById(host_elem):host_elem);
if(cljs.core.truth_(host_elem__$1)){
if(cljs.core.truth_(host_elem__$1.processing_context)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(renderer,host_elem__$1.processing_context)){
} else {
console.warn("WARNING: Using different context on one canvas!");
}
} else {
(host_elem__$1.processing_context = renderer);
}

quil.sketch.destroy_previous_sketch(host_elem__$1);

var proc_obj = (new p5(quil.sketch.make_sketch(opts_map),host_elem__$1));
(host_elem__$1.processing_obj = proc_obj);

(proc_obj.quil_canvas = host_elem__$1);

quil.sketch.add_fullscreen_support(proc_obj);

return proc_obj;
} else {
return console.error((cljs.core.truth_(new cljs.core.Keyword(null,"host","host",-1558485167).cljs$core$IFn$_invoke$arity$1(opts_map))?["ERROR: Cannot find host element: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"host","host",-1558485167).cljs$core$IFn$_invoke$arity$1(opts_map))].join(''):"ERROR: Cannot create sketch. :host is not specified or element not found."));
}
}));

(quil.sketch.sketch.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(quil.sketch.sketch.cljs$lang$applyTo = (function (seq11705){
var self__4777__auto__ = this;
return self__4777__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq11705));
}));

quil.sketch.sketch_init_list = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.List.EMPTY);
quil.sketch.empty_body_QMARK_ = (function quil$sketch$empty_body_QMARK_(){
var child = document.body.childNodes;
return (child.length <= (1));
});
quil.sketch.add_canvas = (function quil$sketch$add_canvas(canvas_id){
var canvas = document.createElement("canvas");
canvas.setAttribute("id",canvas_id);

return document.body.appendChild(canvas);
});
quil.sketch.init_sketches = (function quil$sketch$init_sketches(){
var add_elem_QMARK__11752 = quil.sketch.empty_body_QMARK_();
var seq__11709_11753 = cljs.core.seq(cljs.core.deref(quil.sketch.sketch_init_list));
var chunk__11710_11754 = null;
var count__11711_11755 = (0);
var i__11712_11756 = (0);
while(true){
if((i__11712_11756 < count__11711_11755)){
var sk_11757 = chunk__11710_11754.cljs$core$IIndexed$_nth$arity$2(null,i__11712_11756);
if(add_elem_QMARK__11752){
quil.sketch.add_canvas(new cljs.core.Keyword(null,"host-id","host-id",742376279).cljs$core$IFn$_invoke$arity$1(sk_11757));
} else {
}

var fexpr__11720_11758 = new cljs.core.Keyword(null,"fn","fn",-1175266204).cljs$core$IFn$_invoke$arity$1(sk_11757);
(fexpr__11720_11758.cljs$core$IFn$_invoke$arity$0 ? fexpr__11720_11758.cljs$core$IFn$_invoke$arity$0() : fexpr__11720_11758.call(null));


var G__11759 = seq__11709_11753;
var G__11760 = chunk__11710_11754;
var G__11761 = count__11711_11755;
var G__11762 = (i__11712_11756 + (1));
seq__11709_11753 = G__11759;
chunk__11710_11754 = G__11760;
count__11711_11755 = G__11761;
i__11712_11756 = G__11762;
continue;
} else {
var temp__5735__auto___11764 = cljs.core.seq(seq__11709_11753);
if(temp__5735__auto___11764){
var seq__11709_11765__$1 = temp__5735__auto___11764;
if(cljs.core.chunked_seq_QMARK_(seq__11709_11765__$1)){
var c__4609__auto___11766 = cljs.core.chunk_first(seq__11709_11765__$1);
var G__11767 = cljs.core.chunk_rest(seq__11709_11765__$1);
var G__11768 = c__4609__auto___11766;
var G__11769 = cljs.core.count(c__4609__auto___11766);
var G__11770 = (0);
seq__11709_11753 = G__11767;
chunk__11710_11754 = G__11768;
count__11711_11755 = G__11769;
i__11712_11756 = G__11770;
continue;
} else {
var sk_11771 = cljs.core.first(seq__11709_11765__$1);
if(add_elem_QMARK__11752){
quil.sketch.add_canvas(new cljs.core.Keyword(null,"host-id","host-id",742376279).cljs$core$IFn$_invoke$arity$1(sk_11771));
} else {
}

var fexpr__11721_11772 = new cljs.core.Keyword(null,"fn","fn",-1175266204).cljs$core$IFn$_invoke$arity$1(sk_11771);
(fexpr__11721_11772.cljs$core$IFn$_invoke$arity$0 ? fexpr__11721_11772.cljs$core$IFn$_invoke$arity$0() : fexpr__11721_11772.call(null));


var G__11773 = cljs.core.next(seq__11709_11765__$1);
var G__11774 = null;
var G__11775 = (0);
var G__11776 = (0);
seq__11709_11753 = G__11773;
chunk__11710_11754 = G__11774;
count__11711_11755 = G__11775;
i__11712_11756 = G__11776;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(quil.sketch.sketch_init_list,cljs.core.PersistentVector.EMPTY);
});
quil.sketch.add_sketch_to_init_list = (function quil$sketch$add_sketch_to_init_list(sk){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(quil.sketch.sketch_init_list,cljs.core.conj,sk);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(document.readyState,"complete")){
return quil.sketch.init_sketches();
} else {
return null;
}
});
goog.events.listenOnce(window,goog.events.EventType.LOAD,quil.sketch.init_sketches);
