shadow$provide["module$node_modules$react_player$lib$ReactPlayer"] = function(global,require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "FilePlayer", {
  enumerable: true,
  get: function get() {
    return _FilePlayer["default"];
  }
});
Object.defineProperty(exports, "YouTube", {
  enumerable: true,
  get: function get() {
    return _YouTube["default"];
  }
});
Object.defineProperty(exports, "SoundCloud", {
  enumerable: true,
  get: function get() {
    return _SoundCloud["default"];
  }
});
Object.defineProperty(exports, "Vimeo", {
  enumerable: true,
  get: function get() {
    return _Vimeo["default"];
  }
});
Object.defineProperty(exports, "Facebook", {
  enumerable: true,
  get: function get() {
    return _Facebook["default"];
  }
});
Object.defineProperty(exports, "Streamable", {
  enumerable: true,
  get: function get() {
    return _Streamable["default"];
  }
});
Object.defineProperty(exports, "Wistia", {
  enumerable: true,
  get: function get() {
    return _Wistia["default"];
  }
});
Object.defineProperty(exports, "Twitch", {
  enumerable: true,
  get: function get() {
    return _Twitch["default"];
  }
});
Object.defineProperty(exports, "DailyMotion", {
  enumerable: true,
  get: function get() {
    return _DailyMotion["default"];
  }
});
Object.defineProperty(exports, "Mixcloud", {
  enumerable: true,
  get: function get() {
    return _Mixcloud["default"];
  }
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _props = require("./props");

var _utils = require("./utils");

var _players = _interopRequireDefault(require("./players"));

var _Player4 = _interopRequireDefault(require("./Player"));

var _Preview = _interopRequireDefault(require("./Preview"));

var _FilePlayer = _interopRequireWildcard(require("./players/FilePlayer"));

var _preload = _interopRequireDefault(require("./preload"));

var _YouTube = _interopRequireDefault(require("./players/YouTube"));

var _SoundCloud = _interopRequireDefault(require("./players/SoundCloud"));

var _Vimeo = _interopRequireDefault(require("./players/Vimeo"));

var _Facebook = _interopRequireDefault(require("./players/Facebook"));

var _Streamable = _interopRequireDefault(require("./players/Streamable"));

var _Wistia = _interopRequireDefault(require("./players/Wistia"));

var _Twitch = _interopRequireDefault(require("./players/Twitch"));

var _DailyMotion = _interopRequireDefault(require("./players/DailyMotion"));

var _Mixcloud = _interopRequireDefault(require("./players/Mixcloud"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var SUPPORTED_PROPS = Object.keys(_props.propTypes);
var customPlayers = [];

var ReactPlayer =
/*#__PURE__*/
function (_Component) {
  _inherits(ReactPlayer, _Component);

  function ReactPlayer() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, ReactPlayer);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(ReactPlayer)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "config", (0, _utils.getConfig)(_this.props, _props.defaultProps, true));

    _defineProperty(_assertThisInitialized(_this), "state", {
      showPreview: !!_this.props.light
    });

    _defineProperty(_assertThisInitialized(_this), "handleClickPreview", function () {
      _this.setState({
        showPreview: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "showPreview", function () {
      _this.setState({
        showPreview: true
      });
    });

    _defineProperty(_assertThisInitialized(_this), "getDuration", function () {
      if (!_this.player) return null;
      return _this.player.getDuration();
    });

    _defineProperty(_assertThisInitialized(_this), "getCurrentTime", function () {
      if (!_this.player) return null;
      return _this.player.getCurrentTime();
    });

    _defineProperty(_assertThisInitialized(_this), "getSecondsLoaded", function () {
      if (!_this.player) return null;
      return _this.player.getSecondsLoaded();
    });

    _defineProperty(_assertThisInitialized(_this), "getInternalPlayer", function () {
      var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'player';
      if (!_this.player) return null;
      return _this.player.getInternalPlayer(key);
    });

    _defineProperty(_assertThisInitialized(_this), "seekTo", function (fraction, type) {
      if (!_this.player) return null;

      _this.player.seekTo(fraction, type);
    });

    _defineProperty(_assertThisInitialized(_this), "handleReady", function () {
      _this.props.onReady(_assertThisInitialized(_this));
    });

    _defineProperty(_assertThisInitialized(_this), "wrapperRef", function (wrapper) {
      _this.wrapper = wrapper;
    });

    _defineProperty(_assertThisInitialized(_this), "activePlayerRef", function (player) {
      _this.player = player;
    });

    return _this;
  }

  _createClass(ReactPlayer, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.progressFrequency) {
        var message = 'ReactPlayer: %cprogressFrequency%c is deprecated, please use %cprogressInterval%c instead';
        console.warn(message, 'font-weight: bold', '', 'font-weight: bold', '');
      }
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      return !(0, _utils.isEqual)(this.props, nextProps) || !(0, _utils.isEqual)(this.state, nextState);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var light = this.props.light;
      this.config = (0, _utils.getConfig)(this.props, _props.defaultProps);

      if (!prevProps.light && light) {
        this.setState({
          showPreview: true
        });
      }

      if (prevProps.light && !light) {
        this.setState({
          showPreview: false
        });
      }
    }
  }, {
    key: "getActivePlayer",
    value: function getActivePlayer(url) {
      for (var _i = 0, _arr = [].concat(_toConsumableArray(customPlayers), _toConsumableArray(_players["default"])); _i < _arr.length; _i++) {
        var _Player = _arr[_i];

        if (_Player.canPlay(url)) {
          return _Player;
        }
      } // Fall back to FilePlayer if nothing else can play the URL


      return _FilePlayer.FilePlayer;
    }
  }, {
    key: "renderActivePlayer",
    value: function renderActivePlayer(url, activePlayer) {
      if (!url) return null;
      return _react["default"].createElement(_Player4["default"], _extends({}, this.props, {
        key: activePlayer.displayName,
        ref: this.activePlayerRef,
        config: this.config,
        activePlayer: activePlayer,
        onReady: this.handleReady
      }));
    }
  }, {
    key: "sortPlayers",
    value: function sortPlayers(a, b) {
      // Retain player order to prevent weird iframe behaviour when switching players
      if (a && b) {
        return a.key < b.key ? -1 : 1;
      }

      return 0;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          url = _this$props.url,
          controls = _this$props.controls,
          style = _this$props.style,
          width = _this$props.width,
          height = _this$props.height,
          light = _this$props.light,
          playIcon = _this$props.playIcon,
          Wrapper = _this$props.wrapper;
      var showPreview = this.state.showPreview && url;
      var otherProps = (0, _utils.omit)(this.props, SUPPORTED_PROPS, _props.DEPRECATED_CONFIG_PROPS);
      var activePlayer = this.getActivePlayer(url);
      var renderedActivePlayer = this.renderActivePlayer(url, activePlayer);
      var preloadPlayers = (0, _preload["default"])(url, controls, this.config);
      var players = [renderedActivePlayer].concat(_toConsumableArray(preloadPlayers)).sort(this.sortPlayers);

      var preview = _react["default"].createElement(_Preview["default"], {
        url: url,
        light: light,
        playIcon: playIcon,
        onClick: this.handleClickPreview
      });

      return _react["default"].createElement(Wrapper, _extends({
        ref: this.wrapperRef,
        style: _objectSpread({}, style, {
          width: width,
          height: height
        })
      }, otherProps), showPreview ? preview : players);
    }
  }]);

  return ReactPlayer;
}(_react.Component);

exports["default"] = ReactPlayer;

_defineProperty(ReactPlayer, "addCustomPlayer", function (player) {
  customPlayers.push(player);
});

_defineProperty(ReactPlayer, "removeCustomPlayers", function () {
  customPlayers = [];
});

_defineProperty(ReactPlayer, "displayName", 'ReactPlayer');

_defineProperty(ReactPlayer, "propTypes", _props.propTypes);

_defineProperty(ReactPlayer, "defaultProps", _props.defaultProps);

_defineProperty(ReactPlayer, "canPlay", function (url) {
  for (var _i2 = 0, _arr2 = [].concat(_toConsumableArray(customPlayers), _toConsumableArray(_players["default"])); _i2 < _arr2.length; _i2++) {
    var _Player2 = _arr2[_i2];

    if (_Player2.canPlay(url)) {
      return true;
    }
  }

  return false;
});

_defineProperty(ReactPlayer, "canEnablePIP", function (url) {
  for (var _i3 = 0, _arr3 = [].concat(_toConsumableArray(customPlayers), _toConsumableArray(_players["default"])); _i3 < _arr3.length; _i3++) {
    var _Player3 = _arr3[_i3];

    if (_Player3.canEnablePIP && _Player3.canEnablePIP(url)) {
      return true;
    }
  }

  return false;
});
};