goog.provide('cljs.compiler');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__15383 = s;
var map__15383__$1 = (((((!((map__15383 == null))))?(((((map__15383.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15383.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15383):map__15383);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15383__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15383__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__15386 = info;
var map__15387 = G__15386;
var map__15387__$1 = (((((!((map__15387 == null))))?(((((map__15387.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15387.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15387):map__15387);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15387__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__15386__$1 = G__15386;
while(true){
var d__$2 = d__$1;
var map__15391 = G__15386__$1;
var map__15391__$1 = (((((!((map__15391 == null))))?(((((map__15391.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15391.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15391):map__15391);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15391__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__16088 = (d__$2 + (1));
var G__16089 = shadow__$2;
d__$1 = G__16088;
G__15386__$1 = G__16089;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__15393){
var map__15394 = p__15393;
var map__15394__$1 = (((((!((map__15394 == null))))?(((((map__15394.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15394.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15394):map__15394);
var name_var = map__15394__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15394__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15394__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__15400 = info;
var map__15400__$1 = (((((!((map__15400 == null))))?(((((map__15400.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15400.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15400):map__15400);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15400__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15400__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__15402 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__15402) : cljs.compiler.munge.call(null,G__15402));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__15406 = arguments.length;
switch (G__15406) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__15407 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11472,11472,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__15407.cljs$core$IFn$_invoke$arity$1 ? fexpr__15407.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__15407.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__15408 = cp;
switch (G__15408) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__15409_16138 = cljs.core.seq(s);
var chunk__15410_16139 = null;
var count__15411_16140 = (0);
var i__15412_16141 = (0);
while(true){
if((i__15412_16141 < count__15411_16140)){
var c_16142 = chunk__15410_16139.cljs$core$IIndexed$_nth$arity$2(null,i__15412_16141);
sb.append(cljs.compiler.escape_char(c_16142));


var G__16147 = seq__15409_16138;
var G__16148 = chunk__15410_16139;
var G__16149 = count__15411_16140;
var G__16150 = (i__15412_16141 + (1));
seq__15409_16138 = G__16147;
chunk__15410_16139 = G__16148;
count__15411_16140 = G__16149;
i__15412_16141 = G__16150;
continue;
} else {
var temp__5735__auto___16151 = cljs.core.seq(seq__15409_16138);
if(temp__5735__auto___16151){
var seq__15409_16152__$1 = temp__5735__auto___16151;
if(cljs.core.chunked_seq_QMARK_(seq__15409_16152__$1)){
var c__4609__auto___16153 = cljs.core.chunk_first(seq__15409_16152__$1);
var G__16154 = cljs.core.chunk_rest(seq__15409_16152__$1);
var G__16155 = c__4609__auto___16153;
var G__16156 = cljs.core.count(c__4609__auto___16153);
var G__16157 = (0);
seq__15409_16138 = G__16154;
chunk__15410_16139 = G__16155;
count__15411_16140 = G__16156;
i__15412_16141 = G__16157;
continue;
} else {
var c_16158 = cljs.core.first(seq__15409_16152__$1);
sb.append(cljs.compiler.escape_char(c_16158));


var G__16159 = cljs.core.next(seq__15409_16152__$1);
var G__16160 = null;
var G__16161 = (0);
var G__16162 = (0);
seq__15409_16138 = G__16159;
chunk__15410_16139 = G__16160;
count__15411_16140 = G__16161;
i__15412_16141 = G__16162;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__15413 = cljs.core.get_global_hierarchy;
return (fexpr__15413.cljs$core$IFn$_invoke$arity$0 ? fexpr__15413.cljs$core$IFn$_invoke$arity$0() : fexpr__15413.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__15414_16163 = ast;
var map__15414_16164__$1 = (((((!((map__15414_16163 == null))))?(((((map__15414_16163.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15414_16163.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15414_16163):map__15414_16163);
var env_16165 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15414_16164__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_16165))){
var map__15416_16166 = env_16165;
var map__15416_16167__$1 = (((((!((map__15416_16166 == null))))?(((((map__15416_16166.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15416_16166.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15416_16166):map__15416_16166);
var line_16168 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15416_16167__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_16169 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15416_16167__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__15418 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__15421 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__15420 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__15420.cljs$core$IFn$_invoke$arity$1 ? fexpr__15420.cljs$core$IFn$_invoke$arity$1(G__15421) : fexpr__15420.call(null,G__15421));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__15418,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__15418;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_16168 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_16169)?(column_16169 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__15434 = arguments.length;
switch (G__15434) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___16185 = arguments.length;
var i__4790__auto___16186 = (0);
while(true){
if((i__4790__auto___16186 < len__4789__auto___16185)){
args_arr__4810__auto__.push((arguments[i__4790__auto___16186]));

var G__16187 = (i__4790__auto___16186 + (1));
i__4790__auto___16186 = G__16187;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_16188 = (function (){var G__15444 = a;
if((!(typeof a === 'string'))){
return G__15444.toString();
} else {
return G__15444;
}
})();
var temp__5739__auto___16189 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___16189 == null)){
} else {
var sm_data_16190 = temp__5739__auto___16189;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_16190,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__15422_SHARP_){
return (p1__15422_SHARP_ + s_16188.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_16188], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__15446 = cljs.core.seq(xs);
var chunk__15447 = null;
var count__15448 = (0);
var i__15449 = (0);
while(true){
if((i__15449 < count__15448)){
var x = chunk__15447.cljs$core$IIndexed$_nth$arity$2(null,i__15449);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__16193 = seq__15446;
var G__16194 = chunk__15447;
var G__16195 = count__15448;
var G__16196 = (i__15449 + (1));
seq__15446 = G__16193;
chunk__15447 = G__16194;
count__15448 = G__16195;
i__15449 = G__16196;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15446);
if(temp__5735__auto__){
var seq__15446__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15446__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15446__$1);
var G__16197 = cljs.core.chunk_rest(seq__15446__$1);
var G__16198 = c__4609__auto__;
var G__16199 = cljs.core.count(c__4609__auto__);
var G__16200 = (0);
seq__15446 = G__16197;
chunk__15447 = G__16198;
count__15448 = G__16199;
i__15449 = G__16200;
continue;
} else {
var x = cljs.core.first(seq__15446__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__16201 = cljs.core.next(seq__15446__$1);
var G__16202 = null;
var G__16203 = (0);
var G__16204 = (0);
seq__15446 = G__16201;
chunk__15447 = G__16202;
count__15448 = G__16203;
i__15449 = G__16204;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq15426){
var G__15429 = cljs.core.first(seq15426);
var seq15426__$1 = cljs.core.next(seq15426);
var G__15430 = cljs.core.first(seq15426__$1);
var seq15426__$2 = cljs.core.next(seq15426__$1);
var G__15431 = cljs.core.first(seq15426__$2);
var seq15426__$3 = cljs.core.next(seq15426__$2);
var G__15432 = cljs.core.first(seq15426__$3);
var seq15426__$4 = cljs.core.next(seq15426__$3);
var G__15433 = cljs.core.first(seq15426__$4);
var seq15426__$5 = cljs.core.next(seq15426__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15429,G__15430,G__15431,G__15432,G__15433,seq15426__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__15453){
var map__15454 = p__15453;
var map__15454__$1 = (((((!((map__15454 == null))))?(((((map__15454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15454.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15454):map__15454);
var m = map__15454__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15454__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__15463 = arguments.length;
switch (G__15463) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___16208 = arguments.length;
var i__4790__auto___16221 = (0);
while(true){
if((i__4790__auto___16221 < len__4789__auto___16208)){
args_arr__4810__auto__.push((arguments[i__4790__auto___16221]));

var G__16224 = (i__4790__auto___16221 + (1));
i__4790__auto___16221 = G__16224;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__15474_16232 = cljs.core.seq(xs);
var chunk__15475_16233 = null;
var count__15476_16234 = (0);
var i__15477_16235 = (0);
while(true){
if((i__15477_16235 < count__15476_16234)){
var x_16236 = chunk__15475_16233.cljs$core$IIndexed$_nth$arity$2(null,i__15477_16235);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_16236);


var G__16237 = seq__15474_16232;
var G__16238 = chunk__15475_16233;
var G__16239 = count__15476_16234;
var G__16240 = (i__15477_16235 + (1));
seq__15474_16232 = G__16237;
chunk__15475_16233 = G__16238;
count__15476_16234 = G__16239;
i__15477_16235 = G__16240;
continue;
} else {
var temp__5735__auto___16242 = cljs.core.seq(seq__15474_16232);
if(temp__5735__auto___16242){
var seq__15474_16243__$1 = temp__5735__auto___16242;
if(cljs.core.chunked_seq_QMARK_(seq__15474_16243__$1)){
var c__4609__auto___16244 = cljs.core.chunk_first(seq__15474_16243__$1);
var G__16245 = cljs.core.chunk_rest(seq__15474_16243__$1);
var G__16246 = c__4609__auto___16244;
var G__16247 = cljs.core.count(c__4609__auto___16244);
var G__16248 = (0);
seq__15474_16232 = G__16245;
chunk__15475_16233 = G__16246;
count__15476_16234 = G__16247;
i__15477_16235 = G__16248;
continue;
} else {
var x_16249 = cljs.core.first(seq__15474_16243__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_16249);


var G__16250 = cljs.core.next(seq__15474_16243__$1);
var G__16251 = null;
var G__16252 = (0);
var G__16253 = (0);
seq__15474_16232 = G__16250;
chunk__15475_16233 = G__16251;
count__15476_16234 = G__16252;
i__15477_16235 = G__16253;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq15457){
var G__15458 = cljs.core.first(seq15457);
var seq15457__$1 = cljs.core.next(seq15457);
var G__15459 = cljs.core.first(seq15457__$1);
var seq15457__$2 = cljs.core.next(seq15457__$1);
var G__15460 = cljs.core.first(seq15457__$2);
var seq15457__$3 = cljs.core.next(seq15457__$2);
var G__15461 = cljs.core.first(seq15457__$3);
var seq15457__$4 = cljs.core.next(seq15457__$3);
var G__15462 = cljs.core.first(seq15457__$4);
var seq15457__$5 = cljs.core.next(seq15457__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15458,G__15459,G__15460,G__15461,G__15462,seq15457__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__15478_16254 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__15479_16255 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__15480_16256 = true;
var _STAR_print_fn_STAR__temp_val__15481_16257 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__15480_16256);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__15481_16257);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__15479_16255);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__15478_16254);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__15482 = cljs.core.get_global_hierarchy;
return (fexpr__15482.cljs$core$IFn$_invoke$arity$0 ? fexpr__15482.cljs$core$IFn$_invoke$arity$0() : fexpr__15482.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__15483 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15483,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15483,(1),null);
var G__15486 = ns;
var G__15487 = name;
var G__15488 = (function (){
var G__15489 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__15489) : cljs.compiler.emit_constant.call(null,G__15489));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__15486,G__15487,G__15488) : cljs.compiler.emit_record_value.call(null,G__15486,G__15487,G__15488));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__15490 = cljs.core.keys(x);
var G__15491 = cljs.core.vals(x);
var G__15492 = cljs.compiler.emit_constants_comma_sep;
var G__15493 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__15490,G__15491,G__15492,G__15493) : cljs.compiler.emit_map.call(null,G__15490,G__15491,G__15492,G__15493));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__15496 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__15497 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__15496,G__15497) : cljs.compiler.emit_with_meta.call(null,G__15496,G__15497));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__15498 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15498,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15498,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15498,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__15501 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__15501) : x.call(null,G__15501));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__15502 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__15502) : x.call(null,G__15502));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__15507 = items;
var G__15508 = (function (p1__15506_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__15506_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__15507,G__15508) : cljs.compiler.emit_js_object.call(null,G__15507,G__15508));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__15510){
var map__15511 = p__15510;
var map__15511__$1 = (((((!((map__15511 == null))))?(((((map__15511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15511.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15511):map__15511);
var ast = map__15511__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15511__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15511__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15511__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__15513 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__15513__$1 = (((((!((map__15513 == null))))?(((((map__15513.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15513.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15513):map__15513);
var cenv = map__15513__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15513__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4185__auto__ = js_module_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__15515 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4174__auto__ = (function (){var G__15518 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__15518) : cljs.compiler.es5_GT__EQ_.call(null,G__15518));
})();
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4174__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__15515,cljs.analyzer.es5_allowed);
} else {
return G__15515;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4185__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__15519 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__15519,reserved);
} else {
return G__15519;
}
})();
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__15520_16260 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__15520_16261__$1 = (((G__15520_16260 instanceof cljs.core.Keyword))?G__15520_16260.fqn:null);
switch (G__15520_16261__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4174__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__15521){
var map__15522 = p__15521;
var map__15522__$1 = (((((!((map__15522 == null))))?(((((map__15522.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15522.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15522):map__15522);
var arg = map__15522__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15522__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15522__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15522__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15522__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));


var map__15524 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__15524__$1 = (((((!((map__15524 == null))))?(((((map__15524.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15524.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15524):map__15524);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15524__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__15526){
var map__15527 = p__15526;
var map__15527__$1 = (((((!((map__15527 == null))))?(((((map__15527.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15527.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15527):map__15527);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15527__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15527__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15527__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__15529_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__15529_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__15536 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__15536) : comma_sep.call(null,G__15536));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__15537 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__15537) : comma_sep.call(null,G__15537));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__15538){
var map__15539 = p__15538;
var map__15539__$1 = (((((!((map__15539 == null))))?(((((map__15539.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15539.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15539):map__15539);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15539__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15539__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15539__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__15547){
var map__15548 = p__15547;
var map__15548__$1 = (((((!((map__15548 == null))))?(((((map__15548.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15548.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15548):map__15548);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15548__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15548__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__15556_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__15556_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__15561 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__15561) : comma_sep.call(null,G__15561));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__15562){
var map__15563 = p__15562;
var map__15563__$1 = (((((!((map__15563 == null))))?(((((map__15563.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15563.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15563):map__15563);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15563__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15563__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___16268 = cljs.core.seq(items);
if(temp__5735__auto___16268){
var items_16269__$1 = temp__5735__auto___16268;
var vec__15565_16270 = items_16269__$1;
var seq__15566_16271 = cljs.core.seq(vec__15565_16270);
var first__15567_16272 = cljs.core.first(seq__15566_16271);
var seq__15566_16273__$1 = cljs.core.next(seq__15566_16271);
var vec__15568_16274 = first__15567_16272;
var k_16275 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15568_16274,(0),null);
var v_16276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15568_16274,(1),null);
var r_16277 = seq__15566_16273__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_16275),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16276) : emit_js_object_val.call(null,v_16276)));

var seq__15571_16278 = cljs.core.seq(r_16277);
var chunk__15572_16279 = null;
var count__15573_16280 = (0);
var i__15574_16281 = (0);
while(true){
if((i__15574_16281 < count__15573_16280)){
var vec__15581_16282 = chunk__15572_16279.cljs$core$IIndexed$_nth$arity$2(null,i__15574_16281);
var k_16283__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15581_16282,(0),null);
var v_16284__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15581_16282,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_16283__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16284__$1) : emit_js_object_val.call(null,v_16284__$1)));


var G__16285 = seq__15571_16278;
var G__16286 = chunk__15572_16279;
var G__16287 = count__15573_16280;
var G__16288 = (i__15574_16281 + (1));
seq__15571_16278 = G__16285;
chunk__15572_16279 = G__16286;
count__15573_16280 = G__16287;
i__15574_16281 = G__16288;
continue;
} else {
var temp__5735__auto___16289__$1 = cljs.core.seq(seq__15571_16278);
if(temp__5735__auto___16289__$1){
var seq__15571_16290__$1 = temp__5735__auto___16289__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15571_16290__$1)){
var c__4609__auto___16291 = cljs.core.chunk_first(seq__15571_16290__$1);
var G__16292 = cljs.core.chunk_rest(seq__15571_16290__$1);
var G__16293 = c__4609__auto___16291;
var G__16294 = cljs.core.count(c__4609__auto___16291);
var G__16295 = (0);
seq__15571_16278 = G__16292;
chunk__15572_16279 = G__16293;
count__15573_16280 = G__16294;
i__15574_16281 = G__16295;
continue;
} else {
var vec__15584_16296 = cljs.core.first(seq__15571_16290__$1);
var k_16297__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15584_16296,(0),null);
var v_16298__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15584_16296,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_16297__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_16298__$1) : emit_js_object_val.call(null,v_16298__$1)));


var G__16299 = cljs.core.next(seq__15571_16290__$1);
var G__16300 = null;
var G__16301 = (0);
var G__16302 = (0);
seq__15571_16278 = G__16299;
chunk__15572_16279 = G__16300;
count__15573_16280 = G__16301;
i__15574_16281 = G__16302;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__15587){
var map__15588 = p__15587;
var map__15588__$1 = (((((!((map__15588 == null))))?(((((map__15588.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15588.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15588):map__15588);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15588__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15588__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15588__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__15590){
var map__15591 = p__15590;
var map__15591__$1 = (((((!((map__15591 == null))))?(((((map__15591.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15591.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15591):map__15591);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15591__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15591__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__15593){
var map__15594 = p__15593;
var map__15594__$1 = (((((!((map__15594 == null))))?(((((map__15594.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15594.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15594):map__15594);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15594__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__15596){
var map__15597 = p__15596;
var map__15597__$1 = (((((!((map__15597 == null))))?(((((map__15597.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15597.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15597):map__15597);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15597__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15597__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__15599 = cljs.analyzer.unwrap_quote(expr);
var map__15599__$1 = (((((!((map__15599 == null))))?(((((map__15599.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15599.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15599):map__15599);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15599__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15599__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15599__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4174__auto__ = form;
if(cljs.core.truth_(and__4174__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4174__auto__;
}
})():false);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__15603 = cljs.analyzer.unwrap_quote(expr);
var map__15603__$1 = (((((!((map__15603 == null))))?(((((map__15603.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15603.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15603):map__15603);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15603__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15603__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15603__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4185__auto__){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4185__auto__ = (function (){var fexpr__15609 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__15609.cljs$core$IFn$_invoke$arity$1 ? fexpr__15609.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__15609.call(null,tag));
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__15610){
var map__15611 = p__15610;
var map__15611__$1 = (((((!((map__15611 == null))))?(((((map__15611.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15611.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15611):map__15611);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15611__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4185__auto__ = unchecked;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__15613){
var map__15614 = p__15613;
var map__15614__$1 = (((((!((map__15614 == null))))?(((((map__15614.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15614.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15614):map__15614);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15614__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__15616_16311 = cljs.core.seq(nodes);
var chunk__15617_16312 = null;
var count__15618_16313 = (0);
var i__15619_16314 = (0);
while(true){
if((i__15619_16314 < count__15618_16313)){
var map__15641_16315 = chunk__15617_16312.cljs$core$IIndexed$_nth$arity$2(null,i__15619_16314);
var map__15641_16316__$1 = (((((!((map__15641_16315 == null))))?(((((map__15641_16315.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15641_16315.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15641_16315):map__15641_16315);
var ts_16317 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15641_16316__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__15642_16318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15641_16316__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__15642_16319__$1 = (((((!((map__15642_16318 == null))))?(((((map__15642_16318.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15642_16318.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15642_16318):map__15642_16318);
var then_16320 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15642_16319__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__15645_16321 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_16317));
var chunk__15646_16322 = null;
var count__15647_16323 = (0);
var i__15648_16324 = (0);
while(true){
if((i__15648_16324 < count__15647_16323)){
var test_16325 = chunk__15646_16322.cljs$core$IIndexed$_nth$arity$2(null,i__15648_16324);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16325,":");


var G__16326 = seq__15645_16321;
var G__16327 = chunk__15646_16322;
var G__16328 = count__15647_16323;
var G__16329 = (i__15648_16324 + (1));
seq__15645_16321 = G__16326;
chunk__15646_16322 = G__16327;
count__15647_16323 = G__16328;
i__15648_16324 = G__16329;
continue;
} else {
var temp__5735__auto___16332 = cljs.core.seq(seq__15645_16321);
if(temp__5735__auto___16332){
var seq__15645_16333__$1 = temp__5735__auto___16332;
if(cljs.core.chunked_seq_QMARK_(seq__15645_16333__$1)){
var c__4609__auto___16334 = cljs.core.chunk_first(seq__15645_16333__$1);
var G__16335 = cljs.core.chunk_rest(seq__15645_16333__$1);
var G__16336 = c__4609__auto___16334;
var G__16337 = cljs.core.count(c__4609__auto___16334);
var G__16338 = (0);
seq__15645_16321 = G__16335;
chunk__15646_16322 = G__16336;
count__15647_16323 = G__16337;
i__15648_16324 = G__16338;
continue;
} else {
var test_16339 = cljs.core.first(seq__15645_16333__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16339,":");


var G__16340 = cljs.core.next(seq__15645_16333__$1);
var G__16341 = null;
var G__16342 = (0);
var G__16343 = (0);
seq__15645_16321 = G__16340;
chunk__15646_16322 = G__16341;
count__15647_16323 = G__16342;
i__15648_16324 = G__16343;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_16320);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_16320);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__16344 = seq__15616_16311;
var G__16345 = chunk__15617_16312;
var G__16346 = count__15618_16313;
var G__16347 = (i__15619_16314 + (1));
seq__15616_16311 = G__16344;
chunk__15617_16312 = G__16345;
count__15618_16313 = G__16346;
i__15619_16314 = G__16347;
continue;
} else {
var temp__5735__auto___16348 = cljs.core.seq(seq__15616_16311);
if(temp__5735__auto___16348){
var seq__15616_16349__$1 = temp__5735__auto___16348;
if(cljs.core.chunked_seq_QMARK_(seq__15616_16349__$1)){
var c__4609__auto___16350 = cljs.core.chunk_first(seq__15616_16349__$1);
var G__16351 = cljs.core.chunk_rest(seq__15616_16349__$1);
var G__16352 = c__4609__auto___16350;
var G__16353 = cljs.core.count(c__4609__auto___16350);
var G__16354 = (0);
seq__15616_16311 = G__16351;
chunk__15617_16312 = G__16352;
count__15618_16313 = G__16353;
i__15619_16314 = G__16354;
continue;
} else {
var map__15649_16355 = cljs.core.first(seq__15616_16349__$1);
var map__15649_16356__$1 = (((((!((map__15649_16355 == null))))?(((((map__15649_16355.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15649_16355.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15649_16355):map__15649_16355);
var ts_16357 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15649_16356__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__15650_16358 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15649_16356__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__15650_16359__$1 = (((((!((map__15650_16358 == null))))?(((((map__15650_16358.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15650_16358.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15650_16358):map__15650_16358);
var then_16360 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15650_16359__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__15653_16361 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_16357));
var chunk__15654_16362 = null;
var count__15655_16363 = (0);
var i__15656_16364 = (0);
while(true){
if((i__15656_16364 < count__15655_16363)){
var test_16365 = chunk__15654_16362.cljs$core$IIndexed$_nth$arity$2(null,i__15656_16364);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16365,":");


var G__16366 = seq__15653_16361;
var G__16367 = chunk__15654_16362;
var G__16368 = count__15655_16363;
var G__16369 = (i__15656_16364 + (1));
seq__15653_16361 = G__16366;
chunk__15654_16362 = G__16367;
count__15655_16363 = G__16368;
i__15656_16364 = G__16369;
continue;
} else {
var temp__5735__auto___16370__$1 = cljs.core.seq(seq__15653_16361);
if(temp__5735__auto___16370__$1){
var seq__15653_16371__$1 = temp__5735__auto___16370__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15653_16371__$1)){
var c__4609__auto___16372 = cljs.core.chunk_first(seq__15653_16371__$1);
var G__16373 = cljs.core.chunk_rest(seq__15653_16371__$1);
var G__16374 = c__4609__auto___16372;
var G__16375 = cljs.core.count(c__4609__auto___16372);
var G__16376 = (0);
seq__15653_16361 = G__16373;
chunk__15654_16362 = G__16374;
count__15655_16363 = G__16375;
i__15656_16364 = G__16376;
continue;
} else {
var test_16377 = cljs.core.first(seq__15653_16371__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_16377,":");


var G__16378 = cljs.core.next(seq__15653_16371__$1);
var G__16379 = null;
var G__16380 = (0);
var G__16381 = (0);
seq__15653_16361 = G__16378;
chunk__15654_16362 = G__16379;
count__15655_16363 = G__16380;
i__15656_16364 = G__16381;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_16360);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_16360);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__16382 = cljs.core.next(seq__15616_16349__$1);
var G__16383 = null;
var G__16384 = (0);
var G__16385 = (0);
seq__15616_16311 = G__16382;
chunk__15617_16312 = G__16383;
count__15618_16313 = G__16384;
i__15619_16314 = G__16385;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__15660){
var map__15661 = p__15660;
var map__15661__$1 = (((((!((map__15661 == null))))?(((((map__15661.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15661.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15661):map__15661);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15661__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15661__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__15666 = env;
var G__15667 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__15666,G__15667) : cljs.compiler.resolve_type.call(null,G__15666,G__15667));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__15668 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15668,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15668,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__15663_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__15663_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__15663_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__15671 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__15671,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__15671;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__15674 = env;
var G__15675 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__15674,G__15675) : cljs.compiler.resolve_type.call(null,G__15674,G__15675));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15676_SHARP_){
return cljs.compiler.resolve_type(env,p1__15676_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__15677 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__15678 = cljs.core.seq(vec__15677);
var first__15679 = cljs.core.first(seq__15678);
var seq__15678__$1 = cljs.core.next(seq__15678);
var p = first__15679;
var first__15679__$1 = cljs.core.first(seq__15678__$1);
var seq__15678__$2 = cljs.core.next(seq__15678__$1);
var ts = first__15679__$1;
var first__15679__$2 = cljs.core.first(seq__15678__$2);
var seq__15678__$3 = cljs.core.next(seq__15678__$2);
var n = first__15679__$2;
var xs = seq__15678__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__15680 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__15681 = cljs.core.seq(vec__15680);
var first__15682 = cljs.core.first(seq__15681);
var seq__15681__$1 = cljs.core.next(seq__15681);
var p = first__15682;
var first__15682__$1 = cljs.core.first(seq__15681__$1);
var seq__15681__$2 = cljs.core.next(seq__15681__$1);
var ts = first__15682__$1;
var xs = seq__15681__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__15684 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__15683 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__15683.cljs$core$IFn$_invoke$arity$1 ? fexpr__15683.cljs$core$IFn$_invoke$arity$1(G__15684) : fexpr__15683.call(null,G__15684));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__15687 = arguments.length;
switch (G__15687) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__15695 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15685_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__15685_SHARP_);
} else {
return p1__15685_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__15696 = cljs.core.seq(vec__15695);
var first__15697 = cljs.core.first(seq__15696);
var seq__15696__$1 = cljs.core.next(seq__15696);
var x = first__15697;
var ys = seq__15696__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__15698 = cljs.core.seq(ys);
var chunk__15699 = null;
var count__15700 = (0);
var i__15701 = (0);
while(true){
if((i__15701 < count__15700)){
var next_line = chunk__15699.cljs$core$IIndexed$_nth$arity$2(null,i__15701);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__16388 = seq__15698;
var G__16389 = chunk__15699;
var G__16390 = count__15700;
var G__16391 = (i__15701 + (1));
seq__15698 = G__16388;
chunk__15699 = G__16389;
count__15700 = G__16390;
i__15701 = G__16391;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15698);
if(temp__5735__auto__){
var seq__15698__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15698__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15698__$1);
var G__16392 = cljs.core.chunk_rest(seq__15698__$1);
var G__16393 = c__4609__auto__;
var G__16394 = cljs.core.count(c__4609__auto__);
var G__16395 = (0);
seq__15698 = G__16392;
chunk__15699 = G__16393;
count__15700 = G__16394;
i__15701 = G__16395;
continue;
} else {
var next_line = cljs.core.first(seq__15698__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__16396 = cljs.core.next(seq__15698__$1);
var G__16397 = null;
var G__16398 = (0);
var G__16399 = (0);
seq__15698 = G__16396;
chunk__15699 = G__16397;
count__15700 = G__16398;
i__15701 = G__16399;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__15704_16400 = cljs.core.seq(docs__$2);
var chunk__15705_16401 = null;
var count__15706_16402 = (0);
var i__15707_16403 = (0);
while(true){
if((i__15707_16403 < count__15706_16402)){
var e_16404 = chunk__15705_16401.cljs$core$IIndexed$_nth$arity$2(null,i__15707_16403);
if(cljs.core.truth_(e_16404)){
print_comment_lines(e_16404);
} else {
}


var G__16405 = seq__15704_16400;
var G__16406 = chunk__15705_16401;
var G__16407 = count__15706_16402;
var G__16408 = (i__15707_16403 + (1));
seq__15704_16400 = G__16405;
chunk__15705_16401 = G__16406;
count__15706_16402 = G__16407;
i__15707_16403 = G__16408;
continue;
} else {
var temp__5735__auto___16409 = cljs.core.seq(seq__15704_16400);
if(temp__5735__auto___16409){
var seq__15704_16410__$1 = temp__5735__auto___16409;
if(cljs.core.chunked_seq_QMARK_(seq__15704_16410__$1)){
var c__4609__auto___16411 = cljs.core.chunk_first(seq__15704_16410__$1);
var G__16412 = cljs.core.chunk_rest(seq__15704_16410__$1);
var G__16413 = c__4609__auto___16411;
var G__16414 = cljs.core.count(c__4609__auto___16411);
var G__16415 = (0);
seq__15704_16400 = G__16412;
chunk__15705_16401 = G__16413;
count__15706_16402 = G__16414;
i__15707_16403 = G__16415;
continue;
} else {
var e_16416 = cljs.core.first(seq__15704_16410__$1);
if(cljs.core.truth_(e_16416)){
print_comment_lines(e_16416);
} else {
}


var G__16417 = cljs.core.next(seq__15704_16410__$1);
var G__16418 = null;
var G__16419 = (0);
var G__16420 = (0);
seq__15704_16400 = G__16417;
chunk__15705_16401 = G__16418;
count__15706_16402 = G__16419;
i__15707_16403 = G__16420;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4174__auto__ = cljs.core.some((function (p1__15713_SHARP_){
return goog.string.startsWith(p1__15713_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = opts;
if(cljs.core.truth_(and__4174__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__15714){
var map__15715 = p__15714;
var map__15715__$1 = (((((!((map__15715 == null))))?(((((map__15715.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15715.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15715):map__15715);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"test","test",577538877));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15715__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4185__auto__ = init;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
return test;
} else {
return and__4174__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__15717){
var map__15718 = p__15717;
var map__15718__$1 = (((((!((map__15718 == null))))?(((((map__15718.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15718.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15718):map__15718);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15718__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15718__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15718__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__15720_16421 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__15721_16422 = null;
var count__15722_16423 = (0);
var i__15723_16424 = (0);
while(true){
if((i__15723_16424 < count__15722_16423)){
var vec__15730_16425 = chunk__15721_16422.cljs$core$IIndexed$_nth$arity$2(null,i__15723_16424);
var i_16426 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15730_16425,(0),null);
var param_16427 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15730_16425,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_16427);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__16428 = seq__15720_16421;
var G__16429 = chunk__15721_16422;
var G__16430 = count__15722_16423;
var G__16431 = (i__15723_16424 + (1));
seq__15720_16421 = G__16428;
chunk__15721_16422 = G__16429;
count__15722_16423 = G__16430;
i__15723_16424 = G__16431;
continue;
} else {
var temp__5735__auto___16432 = cljs.core.seq(seq__15720_16421);
if(temp__5735__auto___16432){
var seq__15720_16433__$1 = temp__5735__auto___16432;
if(cljs.core.chunked_seq_QMARK_(seq__15720_16433__$1)){
var c__4609__auto___16434 = cljs.core.chunk_first(seq__15720_16433__$1);
var G__16435 = cljs.core.chunk_rest(seq__15720_16433__$1);
var G__16436 = c__4609__auto___16434;
var G__16437 = cljs.core.count(c__4609__auto___16434);
var G__16438 = (0);
seq__15720_16421 = G__16435;
chunk__15721_16422 = G__16436;
count__15722_16423 = G__16437;
i__15723_16424 = G__16438;
continue;
} else {
var vec__15733_16439 = cljs.core.first(seq__15720_16433__$1);
var i_16440 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15733_16439,(0),null);
var param_16441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15733_16439,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_16441);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__16442 = cljs.core.next(seq__15720_16433__$1);
var G__16443 = null;
var G__16444 = (0);
var G__16445 = (0);
seq__15720_16421 = G__16442;
chunk__15721_16422 = G__16443;
count__15722_16423 = G__16444;
i__15723_16424 = G__16445;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__15736_16446 = cljs.core.seq(params);
var chunk__15737_16447 = null;
var count__15738_16448 = (0);
var i__15739_16449 = (0);
while(true){
if((i__15739_16449 < count__15738_16448)){
var param_16450 = chunk__15737_16447.cljs$core$IIndexed$_nth$arity$2(null,i__15739_16449);
cljs.compiler.emit(param_16450);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16450,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16451 = seq__15736_16446;
var G__16452 = chunk__15737_16447;
var G__16453 = count__15738_16448;
var G__16454 = (i__15739_16449 + (1));
seq__15736_16446 = G__16451;
chunk__15737_16447 = G__16452;
count__15738_16448 = G__16453;
i__15739_16449 = G__16454;
continue;
} else {
var temp__5735__auto___16455 = cljs.core.seq(seq__15736_16446);
if(temp__5735__auto___16455){
var seq__15736_16456__$1 = temp__5735__auto___16455;
if(cljs.core.chunked_seq_QMARK_(seq__15736_16456__$1)){
var c__4609__auto___16457 = cljs.core.chunk_first(seq__15736_16456__$1);
var G__16458 = cljs.core.chunk_rest(seq__15736_16456__$1);
var G__16459 = c__4609__auto___16457;
var G__16460 = cljs.core.count(c__4609__auto___16457);
var G__16461 = (0);
seq__15736_16446 = G__16458;
chunk__15737_16447 = G__16459;
count__15738_16448 = G__16460;
i__15739_16449 = G__16461;
continue;
} else {
var param_16462 = cljs.core.first(seq__15736_16456__$1);
cljs.compiler.emit(param_16462);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16462,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16463 = cljs.core.next(seq__15736_16456__$1);
var G__16464 = null;
var G__16465 = (0);
var G__16466 = (0);
seq__15736_16446 = G__16463;
chunk__15737_16447 = G__16464;
count__15738_16448 = G__16465;
i__15739_16449 = G__16466;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__15740_16467 = cljs.core.seq(params);
var chunk__15741_16468 = null;
var count__15742_16469 = (0);
var i__15743_16470 = (0);
while(true){
if((i__15743_16470 < count__15742_16469)){
var param_16471 = chunk__15741_16468.cljs$core$IIndexed$_nth$arity$2(null,i__15743_16470);
cljs.compiler.emit(param_16471);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16471,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16472 = seq__15740_16467;
var G__16473 = chunk__15741_16468;
var G__16474 = count__15742_16469;
var G__16475 = (i__15743_16470 + (1));
seq__15740_16467 = G__16472;
chunk__15741_16468 = G__16473;
count__15742_16469 = G__16474;
i__15743_16470 = G__16475;
continue;
} else {
var temp__5735__auto___16476 = cljs.core.seq(seq__15740_16467);
if(temp__5735__auto___16476){
var seq__15740_16477__$1 = temp__5735__auto___16476;
if(cljs.core.chunked_seq_QMARK_(seq__15740_16477__$1)){
var c__4609__auto___16478 = cljs.core.chunk_first(seq__15740_16477__$1);
var G__16479 = cljs.core.chunk_rest(seq__15740_16477__$1);
var G__16480 = c__4609__auto___16478;
var G__16481 = cljs.core.count(c__4609__auto___16478);
var G__16482 = (0);
seq__15740_16467 = G__16479;
chunk__15741_16468 = G__16480;
count__15742_16469 = G__16481;
i__15743_16470 = G__16482;
continue;
} else {
var param_16483 = cljs.core.first(seq__15740_16477__$1);
cljs.compiler.emit(param_16483);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16483,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16484 = cljs.core.next(seq__15740_16477__$1);
var G__16485 = null;
var G__16486 = (0);
var G__16487 = (0);
seq__15740_16467 = G__16484;
chunk__15741_16468 = G__16485;
count__15742_16469 = G__16486;
i__15743_16470 = G__16487;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__15746 = cljs.core.seq(params);
var chunk__15747 = null;
var count__15748 = (0);
var i__15749 = (0);
while(true){
if((i__15749 < count__15748)){
var param = chunk__15747.cljs$core$IIndexed$_nth$arity$2(null,i__15749);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16488 = seq__15746;
var G__16489 = chunk__15747;
var G__16490 = count__15748;
var G__16491 = (i__15749 + (1));
seq__15746 = G__16488;
chunk__15747 = G__16489;
count__15748 = G__16490;
i__15749 = G__16491;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__15746);
if(temp__5735__auto__){
var seq__15746__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15746__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__15746__$1);
var G__16492 = cljs.core.chunk_rest(seq__15746__$1);
var G__16493 = c__4609__auto__;
var G__16494 = cljs.core.count(c__4609__auto__);
var G__16495 = (0);
seq__15746 = G__16492;
chunk__15747 = G__16493;
count__15748 = G__16494;
i__15749 = G__16495;
continue;
} else {
var param = cljs.core.first(seq__15746__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16497 = cljs.core.next(seq__15746__$1);
var G__16498 = null;
var G__16499 = (0);
var G__16500 = (0);
seq__15746 = G__16497;
chunk__15747 = G__16498;
count__15748 = G__16499;
i__15749 = G__16500;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__15750){
var map__15751 = p__15750;
var map__15751__$1 = (((((!((map__15751 == null))))?(((((map__15751.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15751.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15751):map__15751);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15751__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15751__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15751__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15751__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15751__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15751__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__15753){
var map__15754 = p__15753;
var map__15754__$1 = (((((!((map__15754 == null))))?(((((map__15754.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15754.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15754):map__15754);
var f = map__15754__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15754__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_16501__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_16502 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_16501__$1);
var delegate_name_16503 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_16502),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_16503," = function (");

var seq__15756_16504 = cljs.core.seq(params);
var chunk__15757_16505 = null;
var count__15758_16506 = (0);
var i__15759_16507 = (0);
while(true){
if((i__15759_16507 < count__15758_16506)){
var param_16508 = chunk__15757_16505.cljs$core$IIndexed$_nth$arity$2(null,i__15759_16507);
cljs.compiler.emit(param_16508);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16508,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16509 = seq__15756_16504;
var G__16510 = chunk__15757_16505;
var G__16511 = count__15758_16506;
var G__16512 = (i__15759_16507 + (1));
seq__15756_16504 = G__16509;
chunk__15757_16505 = G__16510;
count__15758_16506 = G__16511;
i__15759_16507 = G__16512;
continue;
} else {
var temp__5735__auto___16513 = cljs.core.seq(seq__15756_16504);
if(temp__5735__auto___16513){
var seq__15756_16514__$1 = temp__5735__auto___16513;
if(cljs.core.chunked_seq_QMARK_(seq__15756_16514__$1)){
var c__4609__auto___16515 = cljs.core.chunk_first(seq__15756_16514__$1);
var G__16516 = cljs.core.chunk_rest(seq__15756_16514__$1);
var G__16517 = c__4609__auto___16515;
var G__16518 = cljs.core.count(c__4609__auto___16515);
var G__16519 = (0);
seq__15756_16504 = G__16516;
chunk__15757_16505 = G__16517;
count__15758_16506 = G__16518;
i__15759_16507 = G__16519;
continue;
} else {
var param_16520 = cljs.core.first(seq__15756_16514__$1);
cljs.compiler.emit(param_16520);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16520,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16521 = cljs.core.next(seq__15756_16514__$1);
var G__16522 = null;
var G__16523 = (0);
var G__16524 = (0);
seq__15756_16504 = G__16521;
chunk__15757_16505 = G__16522;
count__15758_16506 = G__16523;
i__15759_16507 = G__16524;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_16502," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_16525 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_16525,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_16503,".call(this,");

var seq__15760_16526 = cljs.core.seq(params);
var chunk__15761_16527 = null;
var count__15762_16528 = (0);
var i__15763_16529 = (0);
while(true){
if((i__15763_16529 < count__15762_16528)){
var param_16530 = chunk__15761_16527.cljs$core$IIndexed$_nth$arity$2(null,i__15763_16529);
cljs.compiler.emit(param_16530);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16530,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16531 = seq__15760_16526;
var G__16532 = chunk__15761_16527;
var G__16533 = count__15762_16528;
var G__16534 = (i__15763_16529 + (1));
seq__15760_16526 = G__16531;
chunk__15761_16527 = G__16532;
count__15762_16528 = G__16533;
i__15763_16529 = G__16534;
continue;
} else {
var temp__5735__auto___16535 = cljs.core.seq(seq__15760_16526);
if(temp__5735__auto___16535){
var seq__15760_16536__$1 = temp__5735__auto___16535;
if(cljs.core.chunked_seq_QMARK_(seq__15760_16536__$1)){
var c__4609__auto___16537 = cljs.core.chunk_first(seq__15760_16536__$1);
var G__16538 = cljs.core.chunk_rest(seq__15760_16536__$1);
var G__16539 = c__4609__auto___16537;
var G__16540 = cljs.core.count(c__4609__auto___16537);
var G__16541 = (0);
seq__15760_16526 = G__16538;
chunk__15761_16527 = G__16539;
count__15762_16528 = G__16540;
i__15763_16529 = G__16541;
continue;
} else {
var param_16542 = cljs.core.first(seq__15760_16536__$1);
cljs.compiler.emit(param_16542);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_16542,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__16543 = cljs.core.next(seq__15760_16536__$1);
var G__16544 = null;
var G__16545 = (0);
var G__16546 = (0);
seq__15760_16526 = G__16543;
chunk__15761_16527 = G__16544;
count__15762_16528 = G__16545;
i__15763_16529 = G__16546;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16502,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_16502,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_16501__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16502,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_16503,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_16502,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__15767){
var map__15768 = p__15767;
var map__15768__$1 = (((((!((map__15768 == null))))?(((((map__15768.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15768.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15768):map__15768);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15768__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15768__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15768__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15768__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15768__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15768__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15768__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15768__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__15764_SHARP_){
var and__4174__auto__ = p1__15764_SHARP_;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__15764_SHARP_));
} else {
return and__4174__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4185__auto__ = in_loop;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_16547__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_16548 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_16547__$1);
var maxparams_16549 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_16550 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_16548),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_16551 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__15765_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__15765_SHARP_)));
}),cljs.core.seq(mmap_16550));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_16548," = null;");

var seq__15770_16552 = cljs.core.seq(ms_16551);
var chunk__15771_16553 = null;
var count__15772_16554 = (0);
var i__15773_16555 = (0);
while(true){
if((i__15773_16555 < count__15772_16554)){
var vec__15780_16556 = chunk__15771_16553.cljs$core$IIndexed$_nth$arity$2(null,i__15773_16555);
var n_16557 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15780_16556,(0),null);
var meth_16558 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15780_16556,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_16557," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16558))){
cljs.compiler.emit_variadic_fn_method(meth_16558);
} else {
cljs.compiler.emit_fn_method(meth_16558);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__16559 = seq__15770_16552;
var G__16560 = chunk__15771_16553;
var G__16561 = count__15772_16554;
var G__16562 = (i__15773_16555 + (1));
seq__15770_16552 = G__16559;
chunk__15771_16553 = G__16560;
count__15772_16554 = G__16561;
i__15773_16555 = G__16562;
continue;
} else {
var temp__5735__auto___16563 = cljs.core.seq(seq__15770_16552);
if(temp__5735__auto___16563){
var seq__15770_16564__$1 = temp__5735__auto___16563;
if(cljs.core.chunked_seq_QMARK_(seq__15770_16564__$1)){
var c__4609__auto___16565 = cljs.core.chunk_first(seq__15770_16564__$1);
var G__16566 = cljs.core.chunk_rest(seq__15770_16564__$1);
var G__16567 = c__4609__auto___16565;
var G__16568 = cljs.core.count(c__4609__auto___16565);
var G__16569 = (0);
seq__15770_16552 = G__16566;
chunk__15771_16553 = G__16567;
count__15772_16554 = G__16568;
i__15773_16555 = G__16569;
continue;
} else {
var vec__15783_16570 = cljs.core.first(seq__15770_16564__$1);
var n_16571 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15783_16570,(0),null);
var meth_16572 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15783_16570,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_16571," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16572))){
cljs.compiler.emit_variadic_fn_method(meth_16572);
} else {
cljs.compiler.emit_fn_method(meth_16572);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__16573 = cljs.core.next(seq__15770_16564__$1);
var G__16574 = null;
var G__16575 = (0);
var G__16576 = (0);
seq__15770_16552 = G__16573;
chunk__15771_16553 = G__16574;
count__15772_16554 = G__16575;
i__15773_16555 = G__16576;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16548," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_16549),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_16549)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_16549));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__15786_16577 = cljs.core.seq(ms_16551);
var chunk__15787_16578 = null;
var count__15788_16579 = (0);
var i__15789_16580 = (0);
while(true){
if((i__15789_16580 < count__15788_16579)){
var vec__15796_16581 = chunk__15787_16578.cljs$core$IIndexed$_nth$arity$2(null,i__15789_16580);
var n_16582 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15796_16581,(0),null);
var meth_16583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15796_16581,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16583))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_16584 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_16584," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_16585 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_16584," = new cljs.core.IndexedSeq(",a_16585,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_16582,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_16549)),(((cljs.core.count(maxparams_16549) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_16584,");"], 0));
} else {
var pcnt_16586 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16583));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_16586,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_16582,".call(this",(((pcnt_16586 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_16586,maxparams_16549)),null,(1),null)),(2),null))),");");
}


var G__16587 = seq__15786_16577;
var G__16588 = chunk__15787_16578;
var G__16589 = count__15788_16579;
var G__16590 = (i__15789_16580 + (1));
seq__15786_16577 = G__16587;
chunk__15787_16578 = G__16588;
count__15788_16579 = G__16589;
i__15789_16580 = G__16590;
continue;
} else {
var temp__5735__auto___16591 = cljs.core.seq(seq__15786_16577);
if(temp__5735__auto___16591){
var seq__15786_16592__$1 = temp__5735__auto___16591;
if(cljs.core.chunked_seq_QMARK_(seq__15786_16592__$1)){
var c__4609__auto___16593 = cljs.core.chunk_first(seq__15786_16592__$1);
var G__16594 = cljs.core.chunk_rest(seq__15786_16592__$1);
var G__16595 = c__4609__auto___16593;
var G__16596 = cljs.core.count(c__4609__auto___16593);
var G__16597 = (0);
seq__15786_16577 = G__16594;
chunk__15787_16578 = G__16595;
count__15788_16579 = G__16596;
i__15789_16580 = G__16597;
continue;
} else {
var vec__15799_16598 = cljs.core.first(seq__15786_16592__$1);
var n_16599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15799_16598,(0),null);
var meth_16600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15799_16598,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16600))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_16601 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_16601," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_16602 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_16601," = new cljs.core.IndexedSeq(",a_16602,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_16599,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_16549)),(((cljs.core.count(maxparams_16549) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_16601,");"], 0));
} else {
var pcnt_16603 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16600));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_16603,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_16599,".call(this",(((pcnt_16603 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_16603,maxparams_16549)),null,(1),null)),(2),null))),");");
}


var G__16604 = cljs.core.next(seq__15786_16592__$1);
var G__16605 = null;
var G__16606 = (0);
var G__16607 = (0);
seq__15786_16577 = G__16604;
chunk__15787_16578 = G__16605;
count__15788_16579 = G__16606;
i__15789_16580 = G__16607;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_16608 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_16551)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_16608,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16548,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16548,".cljs$lang$applyTo = ",cljs.core.some((function (p1__15766_SHARP_){
var vec__15805 = p1__15766_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15805,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15805,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_16551),".cljs$lang$applyTo;");
} else {
}

var seq__15808_16609 = cljs.core.seq(ms_16551);
var chunk__15809_16610 = null;
var count__15810_16611 = (0);
var i__15811_16612 = (0);
while(true){
if((i__15811_16612 < count__15810_16611)){
var vec__15818_16613 = chunk__15809_16610.cljs$core$IIndexed$_nth$arity$2(null,i__15811_16612);
var n_16614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15818_16613,(0),null);
var meth_16615 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15818_16613,(1),null);
var c_16616 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16615));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16615))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16548,".cljs$core$IFn$_invoke$arity$variadic = ",n_16614,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_16548,".cljs$core$IFn$_invoke$arity$",c_16616," = ",n_16614,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__16617 = seq__15808_16609;
var G__16618 = chunk__15809_16610;
var G__16619 = count__15810_16611;
var G__16620 = (i__15811_16612 + (1));
seq__15808_16609 = G__16617;
chunk__15809_16610 = G__16618;
count__15810_16611 = G__16619;
i__15811_16612 = G__16620;
continue;
} else {
var temp__5735__auto___16621 = cljs.core.seq(seq__15808_16609);
if(temp__5735__auto___16621){
var seq__15808_16622__$1 = temp__5735__auto___16621;
if(cljs.core.chunked_seq_QMARK_(seq__15808_16622__$1)){
var c__4609__auto___16623 = cljs.core.chunk_first(seq__15808_16622__$1);
var G__16624 = cljs.core.chunk_rest(seq__15808_16622__$1);
var G__16625 = c__4609__auto___16623;
var G__16626 = cljs.core.count(c__4609__auto___16623);
var G__16627 = (0);
seq__15808_16609 = G__16624;
chunk__15809_16610 = G__16625;
count__15810_16611 = G__16626;
i__15811_16612 = G__16627;
continue;
} else {
var vec__15821_16628 = cljs.core.first(seq__15808_16622__$1);
var n_16629 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15821_16628,(0),null);
var meth_16630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15821_16628,(1),null);
var c_16631 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_16630));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_16630))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_16548,".cljs$core$IFn$_invoke$arity$variadic = ",n_16629,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_16548,".cljs$core$IFn$_invoke$arity$",c_16631," = ",n_16629,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__16632 = cljs.core.next(seq__15808_16622__$1);
var G__16633 = null;
var G__16634 = (0);
var G__16635 = (0);
seq__15808_16609 = G__16632;
chunk__15809_16610 = G__16633;
count__15810_16611 = G__16634;
i__15811_16612 = G__16635;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_16548,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__15824){
var map__15825 = p__15824;
var map__15825__$1 = (((((!((map__15825 == null))))?(((((map__15825.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15825.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15825):map__15825);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15825__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15825__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15825__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__15827_16636 = cljs.core.seq(statements);
var chunk__15828_16637 = null;
var count__15829_16638 = (0);
var i__15830_16639 = (0);
while(true){
if((i__15830_16639 < count__15829_16638)){
var s_16640 = chunk__15828_16637.cljs$core$IIndexed$_nth$arity$2(null,i__15830_16639);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_16640);


var G__16641 = seq__15827_16636;
var G__16642 = chunk__15828_16637;
var G__16643 = count__15829_16638;
var G__16644 = (i__15830_16639 + (1));
seq__15827_16636 = G__16641;
chunk__15828_16637 = G__16642;
count__15829_16638 = G__16643;
i__15830_16639 = G__16644;
continue;
} else {
var temp__5735__auto___16645 = cljs.core.seq(seq__15827_16636);
if(temp__5735__auto___16645){
var seq__15827_16646__$1 = temp__5735__auto___16645;
if(cljs.core.chunked_seq_QMARK_(seq__15827_16646__$1)){
var c__4609__auto___16647 = cljs.core.chunk_first(seq__15827_16646__$1);
var G__16648 = cljs.core.chunk_rest(seq__15827_16646__$1);
var G__16649 = c__4609__auto___16647;
var G__16650 = cljs.core.count(c__4609__auto___16647);
var G__16651 = (0);
seq__15827_16636 = G__16648;
chunk__15828_16637 = G__16649;
count__15829_16638 = G__16650;
i__15830_16639 = G__16651;
continue;
} else {
var s_16652 = cljs.core.first(seq__15827_16646__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_16652);


var G__16653 = cljs.core.next(seq__15827_16646__$1);
var G__16654 = null;
var G__16655 = (0);
var G__16656 = (0);
seq__15827_16636 = G__16653;
chunk__15828_16637 = G__16654;
count__15829_16638 = G__16655;
i__15830_16639 = G__16656;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__15831){
var map__15832 = p__15831;
var map__15832__$1 = (((((!((map__15832 == null))))?(((((map__15832.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15832.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15832):map__15832);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15832__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15832__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15832__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15832__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15832__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__15834,is_loop){
var map__15835 = p__15834;
var map__15835__$1 = (((((!((map__15835 == null))))?(((((map__15835.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15835.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15835):map__15835);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15835__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15835__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15835__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__15837_16658 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__15838_16659 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__15838_16659);

try{var seq__15839_16660 = cljs.core.seq(bindings);
var chunk__15840_16661 = null;
var count__15841_16662 = (0);
var i__15842_16663 = (0);
while(true){
if((i__15842_16663 < count__15841_16662)){
var map__15847_16664 = chunk__15840_16661.cljs$core$IIndexed$_nth$arity$2(null,i__15842_16663);
var map__15847_16665__$1 = (((((!((map__15847_16664 == null))))?(((((map__15847_16664.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15847_16664.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15847_16664):map__15847_16664);
var binding_16666 = map__15847_16665__$1;
var init_16667 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15847_16665__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_16666);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_16667,";");


var G__16668 = seq__15839_16660;
var G__16669 = chunk__15840_16661;
var G__16670 = count__15841_16662;
var G__16671 = (i__15842_16663 + (1));
seq__15839_16660 = G__16668;
chunk__15840_16661 = G__16669;
count__15841_16662 = G__16670;
i__15842_16663 = G__16671;
continue;
} else {
var temp__5735__auto___16672 = cljs.core.seq(seq__15839_16660);
if(temp__5735__auto___16672){
var seq__15839_16673__$1 = temp__5735__auto___16672;
if(cljs.core.chunked_seq_QMARK_(seq__15839_16673__$1)){
var c__4609__auto___16674 = cljs.core.chunk_first(seq__15839_16673__$1);
var G__16675 = cljs.core.chunk_rest(seq__15839_16673__$1);
var G__16676 = c__4609__auto___16674;
var G__16677 = cljs.core.count(c__4609__auto___16674);
var G__16678 = (0);
seq__15839_16660 = G__16675;
chunk__15840_16661 = G__16676;
count__15841_16662 = G__16677;
i__15842_16663 = G__16678;
continue;
} else {
var map__15849_16679 = cljs.core.first(seq__15839_16673__$1);
var map__15849_16680__$1 = (((((!((map__15849_16679 == null))))?(((((map__15849_16679.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15849_16679.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15849_16679):map__15849_16679);
var binding_16681 = map__15849_16680__$1;
var init_16682 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15849_16680__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_16681);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_16682,";");


var G__16683 = cljs.core.next(seq__15839_16673__$1);
var G__16684 = null;
var G__16685 = (0);
var G__16686 = (0);
seq__15839_16660 = G__16683;
chunk__15840_16661 = G__16684;
count__15841_16662 = G__16685;
i__15842_16663 = G__16686;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__15837_16658);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__15851){
var map__15852 = p__15851;
var map__15852__$1 = (((((!((map__15852 == null))))?(((((map__15852.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15852.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15852):map__15852);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15852__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15852__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15852__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4666__auto___16687 = cljs.core.count(exprs);
var i_16688 = (0);
while(true){
if((i_16688 < n__4666__auto___16687)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_16688) : temps.call(null,i_16688))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_16688) : exprs.call(null,i_16688)),";");

var G__16689 = (i_16688 + (1));
i_16688 = G__16689;
continue;
} else {
}
break;
}

var n__4666__auto___16690 = cljs.core.count(exprs);
var i_16691 = (0);
while(true){
if((i_16691 < n__4666__auto___16690)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_16691) : params.call(null,i_16691)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_16691) : temps.call(null,i_16691)),";");

var G__16692 = (i_16691 + (1));
i_16691 = G__16692;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__15861){
var map__15862 = p__15861;
var map__15862__$1 = (((((!((map__15862 == null))))?(((((map__15862.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15862.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15862):map__15862);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15862__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15862__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15862__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__15864_16693 = cljs.core.seq(bindings);
var chunk__15865_16694 = null;
var count__15866_16695 = (0);
var i__15867_16696 = (0);
while(true){
if((i__15867_16696 < count__15866_16695)){
var map__15872_16697 = chunk__15865_16694.cljs$core$IIndexed$_nth$arity$2(null,i__15867_16696);
var map__15872_16698__$1 = (((((!((map__15872_16697 == null))))?(((((map__15872_16697.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15872_16697.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15872_16697):map__15872_16697);
var binding_16699 = map__15872_16698__$1;
var init_16700 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15872_16698__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_16699)," = ",init_16700,";");


var G__16701 = seq__15864_16693;
var G__16702 = chunk__15865_16694;
var G__16703 = count__15866_16695;
var G__16704 = (i__15867_16696 + (1));
seq__15864_16693 = G__16701;
chunk__15865_16694 = G__16702;
count__15866_16695 = G__16703;
i__15867_16696 = G__16704;
continue;
} else {
var temp__5735__auto___16705 = cljs.core.seq(seq__15864_16693);
if(temp__5735__auto___16705){
var seq__15864_16706__$1 = temp__5735__auto___16705;
if(cljs.core.chunked_seq_QMARK_(seq__15864_16706__$1)){
var c__4609__auto___16707 = cljs.core.chunk_first(seq__15864_16706__$1);
var G__16708 = cljs.core.chunk_rest(seq__15864_16706__$1);
var G__16709 = c__4609__auto___16707;
var G__16710 = cljs.core.count(c__4609__auto___16707);
var G__16711 = (0);
seq__15864_16693 = G__16708;
chunk__15865_16694 = G__16709;
count__15866_16695 = G__16710;
i__15867_16696 = G__16711;
continue;
} else {
var map__15874_16712 = cljs.core.first(seq__15864_16706__$1);
var map__15874_16713__$1 = (((((!((map__15874_16712 == null))))?(((((map__15874_16712.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15874_16712.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15874_16712):map__15874_16712);
var binding_16714 = map__15874_16713__$1;
var init_16715 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15874_16713__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_16714)," = ",init_16715,";");


var G__16716 = cljs.core.next(seq__15864_16706__$1);
var G__16717 = null;
var G__16718 = (0);
var G__16719 = (0);
seq__15864_16693 = G__16716;
chunk__15865_16694 = G__16717;
count__15866_16695 = G__16718;
i__15867_16696 = G__16719;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__15878){
var map__15879 = p__15878;
var map__15879__$1 = (((((!((map__15879 == null))))?(((((map__15879.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15879.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15879):map__15879);
var expr = map__15879__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15879__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15879__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15879__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4174__auto__ = protocol;
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = tag;
if(cljs.core.truth_(and__4174__auto____$1)){
var or__4185__auto__ = (function (){var and__4174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto____$2)){
var and__4174__auto____$3 = protocol;
if(cljs.core.truth_(and__4174__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4174__auto____$3;
}
} else {
return and__4174__auto____$2;
}
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto____$2 = (function (){var or__4185__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4174__auto____$2)){
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__15891 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__15891.cljs$core$IFn$_invoke$arity$1 ? fexpr__15891.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__15891.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4174__auto____$2;
}
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__15893 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__15893.cljs$core$IFn$_invoke$arity$1 ? fexpr__15893.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__15893.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4185__auto__){
return or__4185__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__15881 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4174__auto__)){
return (arity > mfa);
} else {
return and__4174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__15876_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__15876_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__15877_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__15877_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15881,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15881,(1),null);
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_16720 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_16720,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_16721 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_16721,args)),(((mfa_16721 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_16721,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
var G__15895 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__15894 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__15894.cljs$core$IFn$_invoke$arity$1 ? fexpr__15894.cljs$core$IFn$_invoke$arity$1(G__15895) : fexpr__15894.call(null,G__15895));
} else {
return and__4174__auto__;
}
})())){
var fprop_16722 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_16722," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_16722,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_16722," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_16722,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__15896){
var map__15897 = p__15896;
var map__15897__$1 = (((((!((map__15897 == null))))?(((((map__15897.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15897.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15897):map__15897);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15897__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15897__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15897__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__15899){
var map__15900 = p__15899;
var map__15900__$1 = (((((!((map__15900 == null))))?(((((map__15900.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15900.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15900):map__15900);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15900__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15900__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15900__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__15902 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__15902__$1 = (((((!((map__15902 == null))))?(((((map__15902.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15902.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15902):map__15902);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15902__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15902__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__15903 = options;
var map__15903__$1 = (((((!((map__15903 == null))))?(((((map__15903.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15903.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15903):map__15903);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15903__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15903__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__15904 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__15909 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__15909__$1 = (((((!((map__15909 == null))))?(((((map__15909.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15909.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15909):map__15909);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15909__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15909__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15904,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15904,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__15911_16734 = cljs.core.seq(libs_to_load);
var chunk__15912_16735 = null;
var count__15913_16736 = (0);
var i__15914_16737 = (0);
while(true){
if((i__15914_16737 < count__15913_16736)){
var lib_16738 = chunk__15912_16735.cljs$core$IIndexed$_nth$arity$2(null,i__15914_16737);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_16738)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16738),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16738),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16738),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16738),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_16738,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16738),"');");
}

}
}
}


var G__16739 = seq__15911_16734;
var G__16740 = chunk__15912_16735;
var G__16741 = count__15913_16736;
var G__16742 = (i__15914_16737 + (1));
seq__15911_16734 = G__16739;
chunk__15912_16735 = G__16740;
count__15913_16736 = G__16741;
i__15914_16737 = G__16742;
continue;
} else {
var temp__5735__auto___16743 = cljs.core.seq(seq__15911_16734);
if(temp__5735__auto___16743){
var seq__15911_16744__$1 = temp__5735__auto___16743;
if(cljs.core.chunked_seq_QMARK_(seq__15911_16744__$1)){
var c__4609__auto___16745 = cljs.core.chunk_first(seq__15911_16744__$1);
var G__16746 = cljs.core.chunk_rest(seq__15911_16744__$1);
var G__16747 = c__4609__auto___16745;
var G__16748 = cljs.core.count(c__4609__auto___16745);
var G__16749 = (0);
seq__15911_16734 = G__16746;
chunk__15912_16735 = G__16747;
count__15913_16736 = G__16748;
i__15914_16737 = G__16749;
continue;
} else {
var lib_16750 = cljs.core.first(seq__15911_16744__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_16750)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16750),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16750),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_16750),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16750),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_16750,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_16750),"');");
}

}
}
}


var G__16754 = cljs.core.next(seq__15911_16744__$1);
var G__16755 = null;
var G__16756 = (0);
var G__16757 = (0);
seq__15911_16734 = G__16754;
chunk__15912_16735 = G__16755;
count__15913_16736 = G__16756;
i__15914_16737 = G__16757;
continue;
}
} else {
}
}
break;
}

var seq__15916_16758 = cljs.core.seq(node_libs);
var chunk__15917_16759 = null;
var count__15918_16760 = (0);
var i__15919_16761 = (0);
while(true){
if((i__15919_16761 < count__15918_16760)){
var lib_16762 = chunk__15917_16759.cljs$core$IIndexed$_nth$arity$2(null,i__15919_16761);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_16762)," = require('",lib_16762,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__16763 = seq__15916_16758;
var G__16764 = chunk__15917_16759;
var G__16765 = count__15918_16760;
var G__16766 = (i__15919_16761 + (1));
seq__15916_16758 = G__16763;
chunk__15917_16759 = G__16764;
count__15918_16760 = G__16765;
i__15919_16761 = G__16766;
continue;
} else {
var temp__5735__auto___16767 = cljs.core.seq(seq__15916_16758);
if(temp__5735__auto___16767){
var seq__15916_16768__$1 = temp__5735__auto___16767;
if(cljs.core.chunked_seq_QMARK_(seq__15916_16768__$1)){
var c__4609__auto___16769 = cljs.core.chunk_first(seq__15916_16768__$1);
var G__16770 = cljs.core.chunk_rest(seq__15916_16768__$1);
var G__16771 = c__4609__auto___16769;
var G__16772 = cljs.core.count(c__4609__auto___16769);
var G__16773 = (0);
seq__15916_16758 = G__16770;
chunk__15917_16759 = G__16771;
count__15918_16760 = G__16772;
i__15919_16761 = G__16773;
continue;
} else {
var lib_16774 = cljs.core.first(seq__15916_16768__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_16774)," = require('",lib_16774,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__16775 = cljs.core.next(seq__15916_16768__$1);
var G__16776 = null;
var G__16777 = (0);
var G__16778 = (0);
seq__15916_16758 = G__16775;
chunk__15917_16759 = G__16776;
count__15918_16760 = G__16777;
i__15919_16761 = G__16778;
continue;
}
} else {
}
}
break;
}

var seq__15924_16779 = cljs.core.seq(global_exports_libs);
var chunk__15925_16780 = null;
var count__15926_16781 = (0);
var i__15927_16782 = (0);
while(true){
if((i__15927_16782 < count__15926_16781)){
var lib_16783 = chunk__15925_16780.cljs$core$IIndexed$_nth$arity$2(null,i__15927_16782);
var map__15932_16784 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_16783));
var map__15932_16785__$1 = (((((!((map__15932_16784 == null))))?(((((map__15932_16784.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15932_16784.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15932_16784):map__15932_16784);
var global_exports_16786 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15932_16785__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_16786,lib_16783);


var G__16787 = seq__15924_16779;
var G__16788 = chunk__15925_16780;
var G__16789 = count__15926_16781;
var G__16790 = (i__15927_16782 + (1));
seq__15924_16779 = G__16787;
chunk__15925_16780 = G__16788;
count__15926_16781 = G__16789;
i__15927_16782 = G__16790;
continue;
} else {
var temp__5735__auto___16791 = cljs.core.seq(seq__15924_16779);
if(temp__5735__auto___16791){
var seq__15924_16792__$1 = temp__5735__auto___16791;
if(cljs.core.chunked_seq_QMARK_(seq__15924_16792__$1)){
var c__4609__auto___16793 = cljs.core.chunk_first(seq__15924_16792__$1);
var G__16794 = cljs.core.chunk_rest(seq__15924_16792__$1);
var G__16795 = c__4609__auto___16793;
var G__16796 = cljs.core.count(c__4609__auto___16793);
var G__16797 = (0);
seq__15924_16779 = G__16794;
chunk__15925_16780 = G__16795;
count__15926_16781 = G__16796;
i__15927_16782 = G__16797;
continue;
} else {
var lib_16798 = cljs.core.first(seq__15924_16792__$1);
var map__15934_16799 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_16798));
var map__15934_16800__$1 = (((((!((map__15934_16799 == null))))?(((((map__15934_16799.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15934_16799.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15934_16799):map__15934_16799);
var global_exports_16801 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15934_16800__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_16801,lib_16798);


var G__16802 = cljs.core.next(seq__15924_16792__$1);
var G__16803 = null;
var G__16804 = (0);
var G__16805 = (0);
seq__15924_16779 = G__16802;
chunk__15925_16780 = G__16803;
count__15926_16781 = G__16804;
i__15927_16782 = G__16805;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__15936){
var map__15937 = p__15936;
var map__15937__$1 = (((((!((map__15937 == null))))?(((((map__15937.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15937.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15937):map__15937);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15937__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15937__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15937__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15937__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15937__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15937__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15937__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__15939){
var map__15940 = p__15939;
var map__15940__$1 = (((((!((map__15940 == null))))?(((((map__15940.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15940.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15940):map__15940);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15940__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15940__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15940__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15940__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15940__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15940__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15940__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__15942){
var map__15943 = p__15942;
var map__15943__$1 = (((((!((map__15943 == null))))?(((((map__15943.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15943.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15943):map__15943);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15943__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15943__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15943__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15943__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15943__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__15945_16812 = cljs.core.seq(protocols);
var chunk__15946_16813 = null;
var count__15947_16814 = (0);
var i__15948_16815 = (0);
while(true){
if((i__15948_16815 < count__15947_16814)){
var protocol_16816 = chunk__15946_16813.cljs$core$IIndexed$_nth$arity$2(null,i__15948_16815);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16816)),"}");


var G__16817 = seq__15945_16812;
var G__16818 = chunk__15946_16813;
var G__16819 = count__15947_16814;
var G__16820 = (i__15948_16815 + (1));
seq__15945_16812 = G__16817;
chunk__15946_16813 = G__16818;
count__15947_16814 = G__16819;
i__15948_16815 = G__16820;
continue;
} else {
var temp__5735__auto___16821 = cljs.core.seq(seq__15945_16812);
if(temp__5735__auto___16821){
var seq__15945_16822__$1 = temp__5735__auto___16821;
if(cljs.core.chunked_seq_QMARK_(seq__15945_16822__$1)){
var c__4609__auto___16823 = cljs.core.chunk_first(seq__15945_16822__$1);
var G__16824 = cljs.core.chunk_rest(seq__15945_16822__$1);
var G__16825 = c__4609__auto___16823;
var G__16826 = cljs.core.count(c__4609__auto___16823);
var G__16827 = (0);
seq__15945_16812 = G__16824;
chunk__15946_16813 = G__16825;
count__15947_16814 = G__16826;
i__15948_16815 = G__16827;
continue;
} else {
var protocol_16828 = cljs.core.first(seq__15945_16822__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16828)),"}");


var G__16829 = cljs.core.next(seq__15945_16822__$1);
var G__16830 = null;
var G__16831 = (0);
var G__16832 = (0);
seq__15945_16812 = G__16829;
chunk__15946_16813 = G__16830;
count__15947_16814 = G__16831;
i__15948_16815 = G__16832;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__15949_16833 = cljs.core.seq(fields__$1);
var chunk__15950_16834 = null;
var count__15951_16835 = (0);
var i__15952_16836 = (0);
while(true){
if((i__15952_16836 < count__15951_16835)){
var fld_16837 = chunk__15950_16834.cljs$core$IIndexed$_nth$arity$2(null,i__15952_16836);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16837," = ",fld_16837,";");


var G__16838 = seq__15949_16833;
var G__16839 = chunk__15950_16834;
var G__16840 = count__15951_16835;
var G__16841 = (i__15952_16836 + (1));
seq__15949_16833 = G__16838;
chunk__15950_16834 = G__16839;
count__15951_16835 = G__16840;
i__15952_16836 = G__16841;
continue;
} else {
var temp__5735__auto___16842 = cljs.core.seq(seq__15949_16833);
if(temp__5735__auto___16842){
var seq__15949_16843__$1 = temp__5735__auto___16842;
if(cljs.core.chunked_seq_QMARK_(seq__15949_16843__$1)){
var c__4609__auto___16844 = cljs.core.chunk_first(seq__15949_16843__$1);
var G__16845 = cljs.core.chunk_rest(seq__15949_16843__$1);
var G__16846 = c__4609__auto___16844;
var G__16847 = cljs.core.count(c__4609__auto___16844);
var G__16848 = (0);
seq__15949_16833 = G__16845;
chunk__15950_16834 = G__16846;
count__15951_16835 = G__16847;
i__15952_16836 = G__16848;
continue;
} else {
var fld_16849 = cljs.core.first(seq__15949_16843__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16849," = ",fld_16849,";");


var G__16850 = cljs.core.next(seq__15949_16843__$1);
var G__16851 = null;
var G__16852 = (0);
var G__16853 = (0);
seq__15949_16833 = G__16850;
chunk__15950_16834 = G__16851;
count__15951_16835 = G__16852;
i__15952_16836 = G__16853;
continue;
}
} else {
}
}
break;
}

var seq__15954_16854 = cljs.core.seq(pmasks);
var chunk__15955_16855 = null;
var count__15956_16856 = (0);
var i__15957_16857 = (0);
while(true){
if((i__15957_16857 < count__15956_16856)){
var vec__15964_16858 = chunk__15955_16855.cljs$core$IIndexed$_nth$arity$2(null,i__15957_16857);
var pno_16859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15964_16858,(0),null);
var pmask_16860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15964_16858,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16859,"$ = ",pmask_16860,";");


var G__16861 = seq__15954_16854;
var G__16862 = chunk__15955_16855;
var G__16863 = count__15956_16856;
var G__16864 = (i__15957_16857 + (1));
seq__15954_16854 = G__16861;
chunk__15955_16855 = G__16862;
count__15956_16856 = G__16863;
i__15957_16857 = G__16864;
continue;
} else {
var temp__5735__auto___16865 = cljs.core.seq(seq__15954_16854);
if(temp__5735__auto___16865){
var seq__15954_16866__$1 = temp__5735__auto___16865;
if(cljs.core.chunked_seq_QMARK_(seq__15954_16866__$1)){
var c__4609__auto___16867 = cljs.core.chunk_first(seq__15954_16866__$1);
var G__16868 = cljs.core.chunk_rest(seq__15954_16866__$1);
var G__16869 = c__4609__auto___16867;
var G__16870 = cljs.core.count(c__4609__auto___16867);
var G__16871 = (0);
seq__15954_16854 = G__16868;
chunk__15955_16855 = G__16869;
count__15956_16856 = G__16870;
i__15957_16857 = G__16871;
continue;
} else {
var vec__15968_16872 = cljs.core.first(seq__15954_16866__$1);
var pno_16873 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15968_16872,(0),null);
var pmask_16874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15968_16872,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16873,"$ = ",pmask_16874,";");


var G__16875 = cljs.core.next(seq__15954_16866__$1);
var G__16876 = null;
var G__16877 = (0);
var G__16878 = (0);
seq__15954_16854 = G__16875;
chunk__15955_16855 = G__16876;
count__15956_16856 = G__16877;
i__15957_16857 = G__16878;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__15984){
var map__15985 = p__15984;
var map__15985__$1 = (((((!((map__15985 == null))))?(((((map__15985.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15985.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15985):map__15985);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15985__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15985__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15985__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15985__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15985__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__15987_16879 = cljs.core.seq(protocols);
var chunk__15988_16880 = null;
var count__15989_16881 = (0);
var i__15990_16882 = (0);
while(true){
if((i__15990_16882 < count__15989_16881)){
var protocol_16883 = chunk__15988_16880.cljs$core$IIndexed$_nth$arity$2(null,i__15990_16882);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16883)),"}");


var G__16884 = seq__15987_16879;
var G__16885 = chunk__15988_16880;
var G__16886 = count__15989_16881;
var G__16887 = (i__15990_16882 + (1));
seq__15987_16879 = G__16884;
chunk__15988_16880 = G__16885;
count__15989_16881 = G__16886;
i__15990_16882 = G__16887;
continue;
} else {
var temp__5735__auto___16888 = cljs.core.seq(seq__15987_16879);
if(temp__5735__auto___16888){
var seq__15987_16889__$1 = temp__5735__auto___16888;
if(cljs.core.chunked_seq_QMARK_(seq__15987_16889__$1)){
var c__4609__auto___16890 = cljs.core.chunk_first(seq__15987_16889__$1);
var G__16891 = cljs.core.chunk_rest(seq__15987_16889__$1);
var G__16892 = c__4609__auto___16890;
var G__16893 = cljs.core.count(c__4609__auto___16890);
var G__16894 = (0);
seq__15987_16879 = G__16891;
chunk__15988_16880 = G__16892;
count__15989_16881 = G__16893;
i__15990_16882 = G__16894;
continue;
} else {
var protocol_16895 = cljs.core.first(seq__15987_16889__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_16895)),"}");


var G__16896 = cljs.core.next(seq__15987_16889__$1);
var G__16897 = null;
var G__16898 = (0);
var G__16899 = (0);
seq__15987_16879 = G__16896;
chunk__15988_16880 = G__16897;
count__15989_16881 = G__16898;
i__15990_16882 = G__16899;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__15991_16900 = cljs.core.seq(fields__$1);
var chunk__15992_16901 = null;
var count__15993_16902 = (0);
var i__15994_16903 = (0);
while(true){
if((i__15994_16903 < count__15993_16902)){
var fld_16904 = chunk__15992_16901.cljs$core$IIndexed$_nth$arity$2(null,i__15994_16903);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16904," = ",fld_16904,";");


var G__16905 = seq__15991_16900;
var G__16906 = chunk__15992_16901;
var G__16907 = count__15993_16902;
var G__16908 = (i__15994_16903 + (1));
seq__15991_16900 = G__16905;
chunk__15992_16901 = G__16906;
count__15993_16902 = G__16907;
i__15994_16903 = G__16908;
continue;
} else {
var temp__5735__auto___16909 = cljs.core.seq(seq__15991_16900);
if(temp__5735__auto___16909){
var seq__15991_16910__$1 = temp__5735__auto___16909;
if(cljs.core.chunked_seq_QMARK_(seq__15991_16910__$1)){
var c__4609__auto___16911 = cljs.core.chunk_first(seq__15991_16910__$1);
var G__16912 = cljs.core.chunk_rest(seq__15991_16910__$1);
var G__16913 = c__4609__auto___16911;
var G__16914 = cljs.core.count(c__4609__auto___16911);
var G__16915 = (0);
seq__15991_16900 = G__16912;
chunk__15992_16901 = G__16913;
count__15993_16902 = G__16914;
i__15994_16903 = G__16915;
continue;
} else {
var fld_16916 = cljs.core.first(seq__15991_16910__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_16916," = ",fld_16916,";");


var G__16917 = cljs.core.next(seq__15991_16910__$1);
var G__16918 = null;
var G__16919 = (0);
var G__16920 = (0);
seq__15991_16900 = G__16917;
chunk__15992_16901 = G__16918;
count__15993_16902 = G__16919;
i__15994_16903 = G__16920;
continue;
}
} else {
}
}
break;
}

var seq__15995_16921 = cljs.core.seq(pmasks);
var chunk__15996_16922 = null;
var count__15997_16923 = (0);
var i__15998_16924 = (0);
while(true){
if((i__15998_16924 < count__15997_16923)){
var vec__16005_16925 = chunk__15996_16922.cljs$core$IIndexed$_nth$arity$2(null,i__15998_16924);
var pno_16926 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16005_16925,(0),null);
var pmask_16927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16005_16925,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16926,"$ = ",pmask_16927,";");


var G__16928 = seq__15995_16921;
var G__16929 = chunk__15996_16922;
var G__16930 = count__15997_16923;
var G__16931 = (i__15998_16924 + (1));
seq__15995_16921 = G__16928;
chunk__15996_16922 = G__16929;
count__15997_16923 = G__16930;
i__15998_16924 = G__16931;
continue;
} else {
var temp__5735__auto___16932 = cljs.core.seq(seq__15995_16921);
if(temp__5735__auto___16932){
var seq__15995_16933__$1 = temp__5735__auto___16932;
if(cljs.core.chunked_seq_QMARK_(seq__15995_16933__$1)){
var c__4609__auto___16934 = cljs.core.chunk_first(seq__15995_16933__$1);
var G__16935 = cljs.core.chunk_rest(seq__15995_16933__$1);
var G__16936 = c__4609__auto___16934;
var G__16937 = cljs.core.count(c__4609__auto___16934);
var G__16938 = (0);
seq__15995_16921 = G__16935;
chunk__15996_16922 = G__16936;
count__15997_16923 = G__16937;
i__15998_16924 = G__16938;
continue;
} else {
var vec__16008_16939 = cljs.core.first(seq__15995_16933__$1);
var pno_16940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16008_16939,(0),null);
var pmask_16941 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16008_16939,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_16940,"$ = ",pmask_16941,";");


var G__16942 = cljs.core.next(seq__15995_16933__$1);
var G__16943 = null;
var G__16944 = (0);
var G__16945 = (0);
seq__15995_16921 = G__16942;
chunk__15996_16922 = G__16943;
count__15997_16923 = G__16944;
i__15998_16924 = G__16945;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__16011){
var map__16012 = p__16011;
var map__16012__$1 = (((((!((map__16012 == null))))?(((((map__16012.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16012.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16012):map__16012);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16012__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16012__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16012__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16012__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16012__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__16014){
var map__16015 = p__16014;
var map__16015__$1 = (((((!((map__16015 == null))))?(((((map__16015.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16015.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16015):map__16015);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16015__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16015__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16015__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16015__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16015__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4174__auto__ = code;
if(cljs.core.truth_(and__4174__auto__)){
var G__16017 = clojure.string.trim(code);
var G__16018 = "/*";
return goog.string.startsWith(G__16017,G__16018);
} else {
return and__4174__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__15327__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__15327__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__16031 = cljs.core.seq(table);
var chunk__16032 = null;
var count__16033 = (0);
var i__16034 = (0);
while(true){
if((i__16034 < count__16033)){
var vec__16041 = chunk__16032.cljs$core$IIndexed$_nth$arity$2(null,i__16034);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16041,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16041,(1),null);
var ns_16946 = cljs.core.namespace(sym);
var name_16947 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__16948 = seq__16031;
var G__16949 = chunk__16032;
var G__16950 = count__16033;
var G__16951 = (i__16034 + (1));
seq__16031 = G__16948;
chunk__16032 = G__16949;
count__16033 = G__16950;
i__16034 = G__16951;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__16031);
if(temp__5735__auto__){
var seq__16031__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16031__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__16031__$1);
var G__16952 = cljs.core.chunk_rest(seq__16031__$1);
var G__16953 = c__4609__auto__;
var G__16954 = cljs.core.count(c__4609__auto__);
var G__16955 = (0);
seq__16031 = G__16952;
chunk__16032 = G__16953;
count__16033 = G__16954;
i__16034 = G__16955;
continue;
} else {
var vec__16044 = cljs.core.first(seq__16031__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16044,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16044,(1),null);
var ns_16956 = cljs.core.namespace(sym);
var name_16957 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__16958 = cljs.core.next(seq__16031__$1);
var G__16959 = null;
var G__16960 = (0);
var G__16961 = (0);
seq__16031 = G__16958;
chunk__16032 = G__16959;
count__16033 = G__16960;
i__16034 = G__16961;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__16060 = arguments.length;
switch (G__16060) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_16963 = cljs.core.first(ks);
var vec__16075_16964 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_16963);
var top_16965 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16075_16964,(0),null);
var prefix_SINGLEQUOTE__16966 = vec__16075_16964;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_16963)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__16966) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_16965)) || (cljs.core.contains_QMARK_(known_externs,top_16965)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__16966)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_16965);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__16966)),";");
}
} else {
}

var m_16967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_16963);
if(cljs.core.empty_QMARK_(m_16967)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__16966,m_16967,top_level,known_externs);
}

var G__16968 = cljs.core.next(ks);
ks = G__16968;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

